/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.hosted.sync.impl;

import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfigHosted;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.model.S7damFolderUploadOptions;
import com.day.cq.dam.s7dam.common.utils.RequestUtils;
import com.day.cq.dam.s7dam.hosted.ips.S7damService;
import com.day.cq.dam.s7dam.hosted.jobs.model.S7damUploadJobDetail;
import com.day.cq.dam.s7dam.hosted.model.S7damAsset;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetUtils;
import com.day.cq.dam.s7dam.hosted.model.S7damFolderAssets;
import com.day.cq.dam.s7dam.hosted.sync.S7damFileMetadataService;
import com.day.cq.dam.s7dam.hosted.sync.S7damPublisher;
import com.day.cq.dam.s7dam.hosted.sync.S7damUploadService;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component
@Service
public class S7damUploadServiceImpl
implements S7damUploadService {
    private static final int ACTIVE_JOB_TIMEOUT = 0x200B20;
    private static final long ACTIVE_JOB_WAITING_INTERVAL = 10000L;
    private static final String[] UPLOAD_MIMETYPES = new String[]{"image/", "video/"};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private S7damPublisher s7damPublisher;
    @Reference
    private S7damService s7damService;
    @Reference
    private S7damConfigResolver s7configResolver;
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;
    @Reference
    private S7damFileMetadataService s7damFileMetadataService;
    @Reference
    private CryptoSupport cryptoSupport;

    @Override
    public String uploadFolder(String path, String cloudServiceConfigPath, ResourceResolver resolver) {
        try {
            S7damConfigHosted s7Config = this.s7configResolver.getS7damConfigHosted(cloudServiceConfigPath);
            Node folderNode = (Node)resolver.getResource(path).adaptTo(Node.class);
            int assetsTotal = 0;
            List<S7damFolderAssets> folderAssetsList = S7damAssetUtils.getFolderAssetsList(folderNode, true);
            for (S7damFolderAssets folderAssets : folderAssetsList) {
                Iterator<String> pathIter = folderAssets.getAssets().iterator();
                this.log.debug("folder path " + folderAssets.getFolderNode().getPath());
                while (pathIter.hasNext()) {
                    this.log.debug(" uploadFolder paths " + pathIter.next());
                    ++assetsTotal;
                }
            }
            this.log.debug(" total Assets to upload =  " + assetsTotal);
            if (assetsTotal > 0) {
                String result = this.internalUploadFolder(folderAssetsList, s7Config, resolver);
                if ("success".equals(result)) {
                    Map<String, String> s7PublishStatusQueryMap = this.getAssetStatusQueryMap(s7Config.getCompanyHandle(), this.scene7EndpointsManager.getAPIServer(s7Config.getRegion()).toString());
                    this.s7damPublisher.addJob(s7Config, null, s7PublishStatusQueryMap);
                }
                return result;
            }
            this.log.debug("uploadFolder no files found to upload for " + path);
            return "success";
        }
        catch (Exception e) {
            this.log.error("storing s7dam upload metadata to asset (" + path + ") failed", (Object)e.getMessage());
            return "failed";
        }
    }

    private String internalUploadFolder(List<S7damFolderAssets> folderAssetsList, S7damConfigHosted s7Config, ResourceResolver resolver) {
        String result;
        HttpClient client = new HttpClient();
        ArrayList<String> uploadedPaths = new ArrayList<String>();
        String publishedServer = s7Config.getPublishServer();
        if (publishedServer == null) {
            this.log.error("upload failed, unable  to retrieve publishedServer");
            return "failed";
        }
        try {
            SimpleDateFormat iso860Local = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss-SSSS");
            String now = iso860Local.format(new Date());
            String uploadJobName = "CQ5_folder_upload_" + now;
            String jobHandle = this.startUploadJob(client, uploadJobName, s7Config);
            if (jobHandle.startsWith("failed")) {
                this.log.error("upload failed, unable  to start upload job");
                return jobHandle;
            }
            HashMap<String, String> filePathUploadNameMap = new HashMap<String, String>();
            for (S7damFolderAssets folder : folderAssetsList) {
                for (String path : folder.getAssets()) {
                    String ipsUploadFilePath = s7Config.getRootPath() + path.replaceFirst("^/content/dam/", "");
                    filePathUploadNameMap.put(path, ipsUploadFilePath);
                    String ipsRootPath = ipsUploadFilePath.substring(0, ipsUploadFilePath.lastIndexOf("/") + 1);
                    String uploadFilename = ipsUploadFilePath.substring(ipsUploadFilePath.lastIndexOf("/") + 1);
                    Node jcrContent = (Node)resolver.getResource(path + "/" + "jcr:content").adaptTo(Node.class);
                    this.setS7FileStatusProp("UploadStart", jcrContent);
                    String uploadResult = this.doUploadJob(client, jobHandle, path, ipsRootPath, resolver, true, uploadFilename, uploadJobName, s7Config);
                    uploadedPaths.add(path);
                    this.log.debug("uploadFolderFiles path " + path + " " + uploadResult);
                }
            }
            result = this.finishUploadJob(client, jobHandle, uploadJobName, s7Config);
            if ("success".equals(result)) {
                List<S7damUploadJobDetail> jobDetailsList = this.s7damService.getMultiFileJobLogDetails(jobHandle, s7Config);
                for (String path : uploadedPaths) {
                    String assetHandle = this.getAssetHandle(jobDetailsList, (String)filePathUploadNameMap.get(path));
                    Resource damAssetResource = resolver.getResource(path);
                    Asset damAsset = (Asset)damAssetResource.adaptTo(Asset.class);
                    Node jcrContent = (Node)damAssetResource.getChild("jcr:content").adaptTo(Node.class);
                    if (!assetHandle.startsWith("failed")) {
                        S7damAsset asset = this.s7damService.getS7damAsset(assetHandle, s7Config);
                        this.s7damFileMetadataService.setAssetMetadataOnSync(damAsset, asset, s7Config, "PublishQueued");
                        continue;
                    }
                    this.setS7FileStatusProp("UploadFailed", jcrContent);
                }
            } else {
                this.log.debug("uploadFolderFiles job completion failed");
                result = "failed";
                this.batchSetS7StatusProps(folderAssetsList, "UploadFailed", resolver);
            }
        }
        catch (Exception e) {
            this.log.error("uploadFolderFiles failed", (Object)e.getMessage());
            result = "failed";
            this.batchSetS7StatusProps(folderAssetsList, "UploadFailed", resolver);
        }
        return result;
    }

    @Override
    public String uploadFile(String assetPath, String cloudServiceConfigPath, ResourceResolver resolver) {
        S7damConfigHosted s7Config = this.s7configResolver.getS7damConfigHosted(cloudServiceConfigPath);
        HttpClient client = new HttpClient();
        String path = assetPath;
        this.log.debug("Cloud Service Config Path = " + cloudServiceConfigPath);
        String publishedServer = s7Config.getPublishServer();
        if (publishedServer == null) {
            this.log.error("upload failed, unable  to retrieve publishedServer");
            return "failed";
        }
        if (path.contains("renditions/")) {
            path = path.substring(0, path.indexOf("jcr:content"));
        }
        Resource damAssetResource = resolver.getResource(path);
        Asset damAsset = (Asset)damAssetResource.adaptTo(Asset.class);
        Node jcrContent = (Node)resolver.getResource(path + "/" + "jcr:content").adaptTo(Node.class);
        String result = "failed";
        try {
            String mimeType = damAsset.getMimeType();
            if (!this.isTypeSupported(mimeType)) {
                this.log.error("upload failed, type not supported: " + mimeType);
                return "failed";
            }
            String uploadFilename = path.substring(path.lastIndexOf("/") + 1);
            String uploadJobname = "CQ5_upload-" + uploadFilename;
            String ipsUploadFilePath = s7Config.getRootPath() + path.replaceFirst("^/content/dam/", "");
            String ipsRootPath = ipsUploadFilePath.substring(0, ipsUploadFilePath.lastIndexOf("/") + 1);
            String jobHandle = this.startUploadJob(client, uploadJobname, s7Config);
            if (jobHandle.startsWith("failed")) {
                this.log.error("upload failed, unable  to start upload job");
                return jobHandle;
            }
            this.setS7FileStatusProp("UploadStart", jcrContent);
            this.doUploadJob(client, jobHandle, path, ipsRootPath, resolver, true, uploadFilename, uploadJobname, s7Config);
            result = this.finishUploadJob(client, jobHandle, uploadJobname, s7Config);
            if ("success".equals(result)) {
                String assetHandle = this.getAssetHandle(jobHandle, s7Config);
                if (StringUtils.isNotBlank((String)assetHandle)) {
                    S7damAsset asset = this.s7damService.getS7damAsset(assetHandle, s7Config);
                    this.s7damFileMetadataService.setAssetMetadataOnSync(damAsset, asset, s7Config, "PublishQueued");
                    Map<String, String> s7PublishStatusQueryMap = this.getAssetStatusQueryMap(s7Config.getCompanyHandle(), this.scene7EndpointsManager.getAPIServer(s7Config.getRegion()).toString());
                    this.s7damPublisher.addJob(s7Config, path, s7PublishStatusQueryMap);
                } else {
                    this.setS7FileStatusProp("UploadFailed", jcrContent);
                }
            }
        }
        catch (Exception e) {
            this.log.error("s7dam upload asset (" + path + ") failed", (Object)e.getMessage());
            this.clearS7NodeProps(jcrContent);
        }
        return result;
    }

    private void batchSetS7StatusProps(List<S7damFolderAssets> folderAssetsList, String status, ResourceResolver resolver) {
        for (S7damFolderAssets folder : folderAssetsList) {
            try {
                for (String s : folder.getAssets()) {
                    Node jcrContent = (Node)resolver.getResource(s + "/" + "jcr:content").adaptTo(Node.class);
                    try {
                        this.setS7FileStatusProp(status, jcrContent);
                    }
                    catch (Exception e) {
                        this.log.error("clearing asset properties failed. " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.log.error("clearing asset properties failed." + e.getMessage());
            }
        }
    }

    private void clearS7NodeProps(Node jcrContent) {
        try {
            if (jcrContent.hasProperty("dam:s7damName")) {
                jcrContent.setProperty("dam:s7damName", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damType")) {
                jcrContent.setProperty("dam:s7damType", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damID")) {
                jcrContent.setProperty("dam:s7damID", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damFileStatus")) {
                jcrContent.setProperty("dam:s7damFileStatus", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damCompanyID")) {
                jcrContent.setProperty("dam:s7damCompanyID", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damDomain")) {
                jcrContent.setProperty("dam:s7damDomain", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damUploadTimeStamp")) {
                jcrContent.setProperty("dam:s7damUploadTimeStamp", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damLastModified")) {
                jcrContent.setProperty("dam:s7damLastModified", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damAPIServer")) {
                jcrContent.setProperty("dam:s7damAPIServer", (String)null);
            }
            if (jcrContent.hasProperty("dam:s7damCloudConfigPath")) {
                jcrContent.setProperty("dam:s7damCloudConfigPath", (String)null);
            }
            jcrContent.getSession().save();
        }
        catch (Exception e) {
            this.log.error("clearing asset properties failure Ignored", (Object)e.getMessage());
        }
    }

    private void setS7FileStatusProp(String status, Node jcrContent) throws Exception {
        try {
            jcrContent.setProperty("dam:s7damFileStatus", status);
            jcrContent.getSession().save();
        }
        catch (VersionException e) {
            this.log.error("setS7FileStatusProps failure (ignored) to write out PN_S7_FILE_STATUS " + status + " for " + jcrContent.getPath() + " " + e.getMessage());
        }
    }

    private Map<String, String> getAssetStatusQueryMap(String companyHandle, String apiServer) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1_property", "dam:s7damCompanyID");
        map.put("1_property.value", companyHandle);
        map.put("2_property", "dam:s7damAPIServer");
        map.put("2_property.value", apiServer);
        return map;
    }

    private synchronized String waitOnUploadJobComplete(String jobHandle, S7damConfigHosted s7Config) {
        long start = System.currentTimeMillis();
        while (this.s7damService.isJobActiveByJobHandle(jobHandle, s7Config)) {
            try {
                if (System.currentTimeMillis() - start > 0x200B20L) {
                    this.log.warn("Timed out waiting for active S7dam upload job complete");
                    return "failed";
                }
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                this.log.error("error waiting for S7dam upload job to complete", (Throwable)e);
                return "failed";
            }
        }
        this.log.debug("S7dam upload job completed");
        return "success";
    }

    protected String startUploadJob(HttpClient client, String uploadJobname, S7damConfigHosted s7Config) {
        try {
            URL ipsServerURL = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion());
            int ipsServerPort = ipsServerURL.getPort() == -1 ? 80 : ipsServerURL.getPort();
            PostMethod request = new PostMethod(ipsServerURL + "/scene7/IPSAccessServlet" + "?threadClass=com.scene7.upload.UploadThread" + "&companyHandle=" + URIUtil.encodeQuery((String)s7Config.getCompanyHandle()));
            client.getParams().setAuthenticationPreemptive(true);
            String password = this.cryptoSupport.unprotect(s7Config.getPassword());
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(s7Config.getEmail(), password);
            client.getState().setCredentials(new AuthScope(ipsServerURL.getHost(), ipsServerPort, AuthScope.ANY_REALM), (Credentials)creds);
            String data = "uploadStarted=true&email=" + URIUtil.encodeQuery((String)s7Config.getEmail()) + "&job=" + uploadJobname + "&userHandle=" + URIUtil.encodeQuery((String)s7Config.getUserHandle());
            request.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/x-www-form-urlencoded", "UTF-8"));
            client.executeMethod((HttpMethod)request);
            String responseBody = IOUtils.toString((InputStream)request.getResponseBodyAsStream());
            this.log.debug(responseBody);
            Document document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody));
            if (document != null) {
                NodeList jobs = document.getElementsByTagName("job");
                if (jobs.getLength() > 0) {
                    Element job = (Element)jobs.item(0);
                    return job.getAttribute("handle");
                }
                NodeList exceptions = document.getElementsByTagName("exception");
                if (exceptions.getLength() > 0) {
                    this.log.error("error while starting s7dam job: " + ((Element)exceptions.item(0)).getAttribute("value"));
                    return "failed: " + ((Element)exceptions.item(0)).getAttribute("value");
                }
            }
        }
        catch (Exception e) {
            this.log.error("error while processing s7dam start job", (Throwable)e);
            return "failed: " + e.getMessage();
        }
        return "failed";
    }

    private String doUploadJob(HttpClient client, String jobHandle, String path, String rootPath, ResourceResolver resolver, boolean doPublish, String uploadFilename, String uploadJobname, S7damConfigHosted s7Config) {
        try {
            String[] propNames;
            URL ipsServerURL = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion());
            int ipsServerPort = ipsServerURL.getPort() == -1 ? 80 : ipsServerURL.getPort();
            PostMethod request = new PostMethod(ipsServerURL + "/scene7/IPSAccessServlet" + "?threadClass=com.scene7.upload.UploadThread" + "&companyHandle=" + URIUtil.encodeQuery((String)s7Config.getCompanyHandle()));
            client.getParams().setAuthenticationPreemptive(true);
            String password = this.cryptoSupport.unprotect(s7Config.getPassword());
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(s7Config.getEmail(), password);
            client.getState().setCredentials(new AuthScope(ipsServerURL.getHost(), ipsServerPort, AuthScope.ANY_REALM), (Credentials)creds);
            this.log.debug("doUploadJob for path = " + path);
            Asset asset = (Asset)resolver.getResource(path).adaptTo(Asset.class);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            InputStream input = asset.getOriginal().getStream();
            byte[] buffer = new byte[1024];
            while (input.read(buffer, 0, 1024) != -1) {
                bytes.write(buffer);
            }
            String encodingPresets = "";
            for (String propName : propNames = new String[]{"adaptiveVideoEncodingPresets", "desktopVideoEncodingPresets", "mobileVideoEncodingPresets", "tabletVideoEncodingPresets"}) {
                String encValue = s7Config.get(propName);
                if (encValue == null || encValue.length() <= 0) continue;
                encodingPresets = encodingPresets + (!encodingPresets.equals("") ? "," : "") + encValue;
            }
            Properties props = new Properties(this.getDefaultOptions());
            if (encodingPresets.length() > 0) {
                props.put("videoEncodingPresets", encodingPresets);
            }
            String nodePath = path.substring(0, path.lastIndexOf("/") + 1);
            S7damFolderUploadOptions uploadOpts = new S7damFolderUploadOptions(resolver);
            try {
                Map<String, String> nodeVals = uploadOpts.getUploadOptions(nodePath);
                for (String key : nodeVals.keySet()) {
                    props.put(key, nodeVals.get(key));
                }
            }
            catch (RepositoryException e) {
                this.log.error("error while reading upload option values from Folder node", (Throwable)e);
            }
            ArrayList<Object> parts = new ArrayList<Object>();
            parts.add(new StringPart("email", URIUtil.encodeQuery((String)s7Config.getEmail())));
            parts.add(new StringPart("userHandle", URIUtil.encodeQuery((String)s7Config.getUserHandle())));
            parts.add(new StringPart("job", uploadJobname));
            parts.add(new StringPart("jobHandle", URIUtil.encodeQuery((String)jobHandle)));
            parts.add(new StringPart("strPath", URIUtil.encodeQuery((String)rootPath)));
            parts.add(new StringPart("filename", uploadFilename));
            parts.add(new StringPart("publish", Boolean.toString(doPublish)));
            Set<String> names = props.stringPropertyNames();
            for (String name : names) {
                String key = name;
                String value = props.getProperty(key);
                if (value == null) continue;
                parts.add(new StringPart(key, value));
            }
            parts.add(new FilePart("file", (PartSource)new ByteArrayPartSource(uploadFilename, bytes.toByteArray())));
            Part[] partsArr = new Part[parts.size()];
            parts.toArray(partsArr);
            request.setRequestEntity((RequestEntity)new MultipartRequestEntity(partsArr, request.getParams()));
            client.executeMethod((HttpMethod)request);
            String responseBody = IOUtils.toString((InputStream)request.getResponseBodyAsStream());
            this.log.debug(responseBody);
            Document document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody));
            if (document != null) {
                NodeList exceptions = document.getElementsByTagName("exception");
                if (exceptions.getLength() > 0) {
                    this.log.error("error while doing s7dam job: " + ((Element)exceptions.item(0)).getAttribute("value"));
                    return "failed: " + ((Element)exceptions.item(0)).getAttribute("value");
                }
                return "success";
            }
        }
        catch (Exception e) {
            this.log.error("error while processing s7dam do upload job", (Throwable)e);
            return "failed" + e.getMessage();
        }
        return "failed";
    }

    private Properties getDefaultOptions() {
        Properties props = new Properties();
        props.setProperty("overwrite", "true");
        props.setProperty("maintainLayers", "true");
        props.setProperty("layerNaming", "layerName");
        return props;
    }

    protected String finishUploadJob(HttpClient client, String jobHandle, String uploadJobname, S7damConfigHosted s7Config) {
        try {
            URL ipsServerURL = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion());
            int ipsServerPort = ipsServerURL.getPort() == -1 ? 80 : ipsServerURL.getPort();
            PostMethod request = new PostMethod(ipsServerURL + "/scene7/IPSAccessServlet" + "?threadClass=com.scene7.upload.UploadThread" + "&companyHandle=" + URIUtil.encodeQuery((String)s7Config.getCompanyHandle()));
            client.getParams().setAuthenticationPreemptive(true);
            String password = this.cryptoSupport.unprotect(s7Config.getPassword());
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(s7Config.getEmail(), password);
            client.getState().setCredentials(new AuthScope(ipsServerURL.getHost(), ipsServerPort, AuthScope.ANY_REALM), (Credentials)creds);
            String data = "uploadFinished=true&email=" + URIUtil.encodeQuery((String)s7Config.getEmail()) + "&job=" + uploadJobname + "&userHandle=" + URIUtil.encodeQuery((String)s7Config.getUserHandle()) + "&jobHandle=" + URIUtil.encodeQuery((String)jobHandle);
            request.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/x-www-form-urlencoded", "UTF-8"));
            client.executeMethod((HttpMethod)request);
            String responseBody = IOUtils.toString((InputStream)request.getResponseBodyAsStream());
            this.log.debug(responseBody);
            Document document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody));
            if (document != null) {
                NodeList exceptions = document.getElementsByTagName("exception");
                if (exceptions.getLength() > 0) {
                    this.log.error("error while finishing s7dam job: " + ((Element)exceptions.item(0)).getAttribute("value"));
                    return "failed: " + ((Element)exceptions.item(0)).getAttribute("value");
                }
                return this.waitOnUploadJobComplete(jobHandle, s7Config);
            }
        }
        catch (Exception e) {
            this.log.error("error while processing s7dam finish job", (Throwable)e);
            return "failed: " + e.getMessage();
        }
        return "success";
    }

    private String getAssetHandle(String jobHandle, S7damConfigHosted s7Config) {
        String assetHandle = "";
        List<String> assetHandles = this.s7damService.getJobLogDetails(jobHandle, s7Config);
        if (assetHandles.size() > 0) {
            assetHandle = assetHandles.get(0);
        }
        return assetHandle;
    }

    private String getAssetHandle(List<S7damUploadJobDetail> jobDetailsList, String fileName) {
        if (jobDetailsList.size() > 0) {
            for (int i = jobDetailsList.size() - 1; i >= 0; --i) {
                S7damUploadJobDetail detail = jobDetailsList.get(i);
                if (!StringUtils.containsIgnoreCase((String)detail.getLogMessage(), (String)fileName)) continue;
                return detail.getAssetHandle();
            }
        }
        return "failed";
    }

    private boolean isTypeSupported(String mimeType) {
        for (String element : UPLOAD_MIMETYPES) {
            if (!mimeType.startsWith(element)) continue;
            return true;
        }
        return false;
    }

    protected void bindS7damPublisher(S7damPublisher s7damPublisher) {
        this.s7damPublisher = s7damPublisher;
    }

    protected void unbindS7damPublisher(S7damPublisher s7damPublisher) {
        if (this.s7damPublisher == s7damPublisher) {
            this.s7damPublisher = null;
        }
    }

    protected void bindS7damService(S7damService s7damService) {
        this.s7damService = s7damService;
    }

    protected void unbindS7damService(S7damService s7damService) {
        if (this.s7damService == s7damService) {
            this.s7damService = null;
        }
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }

    protected void bindS7damFileMetadataService(S7damFileMetadataService s7damFileMetadataService) {
        this.s7damFileMetadataService = s7damFileMetadataService;
    }

    protected void unbindS7damFileMetadataService(S7damFileMetadataService s7damFileMetadataService) {
        if (this.s7damFileMetadataService == s7damFileMetadataService) {
            this.s7damFileMetadataService = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }
}

