/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.catalog;

import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.presets.S7damImagePresetsService;
import com.day.cq.dam.s7dam.onprem.catalog.AssetField;
import com.day.cq.dam.s7dam.onprem.catalog.CatalogAssetRecord;
import com.day.cq.dam.s7dam.onprem.catalog.CatalogCompanyRecord;
import com.day.cq.dam.s7dam.onprem.catalog.CompanyField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Value;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogResolver {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogResolver.class);

    public final List<CatalogAssetRecord> getCatalogDataRecords(String path, SlingHttpServletRequest request, S7damConfigResolver s7Resolver) {
        ArrayList<CatalogAssetRecord> records = new ArrayList<CatalogAssetRecord>();
        String companyName = this.getCompanyNameFromResolver(s7Resolver);
        String imgSetDef = "";
        String pathVal = "";
        try {
            String type;
            CatalogAssetRecord imgSetRecord = this.getCatalogAssetRecordFromJcrContent(path + "/" + "jcr:content", request, companyName);
            imgSetRecord.setRootId(companyName);
            if (imgSetRecord.containsField(AssetField.ImageSet_Type) && (type = imgSetRecord.getField(AssetField.ImageSet_Type).toString()).equals("ImageSet")) {
                NodeIterator ntr = imgSetRecord.getNode().getNodes();
                while (ntr.hasNext()) {
                    Node members;
                    Property prop1;
                    Value[] vals;
                    Node setAttr = (Node)ntr.next();
                    if (!setAttr.getName().equals("related") || !setAttr.hasNode("s7Set") || (vals = (prop1 = (members = setAttr.getNode("s7Set").getNode("sling:members")).getProperty("sling:resources")).getValues()).length <= 0) continue;
                    for (Value val : vals) {
                        pathVal = val.getString();
                        pathVal = pathVal.replaceFirst("\\/content\\/dam\\/", "/" + companyName + "/");
                        imgSetDef = imgSetDef + pathVal + ";" + pathVal;
                        imgSetDef = imgSetDef + ",";
                    }
                }
            }
            if (!imgSetDef.equals("")) {
                imgSetDef = imgSetDef.substring(0, imgSetDef.length() - 1);
                imgSetRecord.setField(AssetField.ImageSet, imgSetDef);
            }
            records.add(imgSetRecord);
        }
        catch (Exception ex) {
            LOG.error("Catalog Data lookup error " + ex.getMessage());
        }
        return records;
    }

    private CatalogAssetRecord getCatalogAssetRecordFromJcrContent(String path, SlingHttpServletRequest request, String companyName) throws Exception {
        ResourceResolver resolver = request.getResourceResolver();
        Node asset = (Node)resolver.getResource(path).adaptTo(Node.class);
        String ipsId = "";
        String assetPath = path.replaceFirst("\\/content\\/dam\\/", "");
        ipsId = assetPath = assetPath.replaceFirst("\\/jcr:content", "");
        CatalogAssetRecord record = null;
        if (asset != null) {
            AssetField[] fields;
            record = new CatalogAssetRecord();
            record.setNode(asset);
            record.setIpsId(ipsId);
            for (AssetField field : fields = AssetField.values()) {
                if (!asset.hasProperty(field.getFieldName())) continue;
                record.setField(field, asset.getProperty(field.getFieldName()).getValue().getString());
            }
        }
        return record;
    }

    public final CatalogCompanyRecord getCompanyRecordFromJcrContent(String companyPath, SlingHttpServletRequest request, S7damConfigResolver s7Resolver, S7damImagePresetsService presetsService) throws Exception {
        ResourceResolver resolver = request.getResourceResolver();
        Node company = (Node)resolver.getResource(companyPath + "/" + "companySettings").adaptTo(Node.class);
        CatalogCompanyRecord record = null;
        String companyName = this.getCompanyNameFromResolver(s7Resolver);
        if (company != null) {
            CompanyField[] fields;
            record = new CatalogCompanyRecord();
            for (CompanyField field : fields = CompanyField.values()) {
                if (!company.hasProperty(field.getFieldName())) continue;
                record.setField(field, company.getProperty(field.getFieldName()).getValue().getString());
            }
            Node companyJcrNode = company.getParent();
            if (companyJcrNode.hasProperty("dam:lastInvalidateCache")) {
                record.setField(CompanyField.lastModified, companyJcrNode.getProperty("dam:lastInvalidateCache").getValue().getString());
            }
            if (!company.hasProperty(CompanyField.AllowDirectAccess.getFieldName())) {
                record.setField(CompanyField.AllowDirectAccess, "false");
            }
            if (!company.hasProperty(CompanyField.DownSampleChroma.getFieldName())) {
                record.setField(CompanyField.DownSampleChroma, "false");
            }
            if (companyJcrNode.hasProperty("imageservermount")) {
                record.setRootPath(companyJcrNode.getProperty("imageservermount").getValue().getString() + "/" + companyName);
            }
        }
        record.setRootId(companyName);
        Resource resource = resolver.getResource(companyPath).getParent();
        Iterator<Resource> presetItr = presetsService.getImagePresets(resource);
        while (presetItr.hasNext()) {
            Resource presetName = presetItr.next();
            Iterator presetProps = presetName.listChildren();
            String presetStr = "";
            while (presetProps.hasNext()) {
                Node settings = (Node)((Resource)presetProps.next()).adaptTo(Node.class);
                if (!settings.getName().toLowerCase().equals("settings")) continue;
                PropertyIterator ptr = settings.getProperties();
                while (ptr.hasNext()) {
                    Property presetProp = (Property)ptr.next();
                    String name = presetProp.getName();
                    String val = presetProp.getValue().getString();
                    if (name.startsWith("jcr")) continue;
                    presetStr = presetStr + name + "=" + val + "&";
                }
                presetStr = presetStr.substring(0, presetStr.length() - 1);
                record.setPreset(presetName.getName(), presetStr);
            }
        }
        return record;
    }

    private String getCompanyNameFromResolver(S7damConfigResolver s7resolver) {
        return s7resolver.getS7damConfig(null).getCompanyName();
    }
}

