/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.config.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.config.S7damConfigService;
import com.day.cq.dam.s7dam.common.model.S7damFolderUploadOptions;
import com.day.cq.dam.s7dam.onprem.platform.PlatformServerService;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service
public class S7damConfigServiceImpl
implements S7damConfigService {
    private static final Logger log = LoggerFactory.getLogger(S7damConfigServiceImpl.class);
    private static Map<String, String> defaultCompanySettings = new LinkedHashMap<String, String>();
    @Reference
    private S7damConfigResolver s7damConfigResolver;
    @Reference
    private PlatformServerService platformServerService;

    @Override
    public void initialize(Resource resource, ResourceResolver rr) throws RepositoryException, PersistenceException {
        if (resource == null) {
            return;
        }
        S7damConfigOnPrem s7Config = this.s7damConfigResolver.getS7damConfigOnPrem(null);
        if (s7Config == null || !s7Config.isValid()) {
            return;
        }
        this.platformServerService.invalidateCompanyCache(rr, s7Config);
        if (resource.getPath().endsWith("jcr:content")) {
            Session session = (Session)rr.adaptTo(Session.class);
            Resource configResourceJcrContent = resource;
            PersistableValueMap properties = (PersistableValueMap)configResourceJcrContent.adaptTo(PersistableValueMap.class);
            String ON_PREM_WF_MODEL_ID = "/etc/workflow/models/dam/update_asset_s7dam_on_premise/jcr:content/model";
            if (!properties.containsKey((Object)"uploadAssetModelID")) {
                properties.put((Object)"uploadAssetModelID", (Object)"/etc/workflow/models/dam/update_asset_s7dam_on_premise/jcr:content/model");
                properties.save();
            }
            if (configResourceJcrContent.getChild("/etc/cloudservices/s7dam/companySettings") == null) {
                try {
                    defaultCompanySettings.put("companySettings/resolution", "80");
                    defaultCompanySettings.put("companySettings/maxpix", "100,100");
                    defaultCompanySettings.put("companySettings/bkgcolor", "FFFFFF");
                    defaultCompanySettings.put("companySettings/defaultpix", "200,200");
                    defaultCompanySettings.put("companySettings/defaultthumbpix", "200,200");
                    defaultCompanySettings.put("companySettings/jpegquality", "80");
                    defaultCompanySettings.put("companySettings/resmode", "NORMAL");
                    defaultCompanySettings.put("companySettings/allowdirectaccess", "false");
                    defaultCompanySettings.put("companySettings/downsamplechroma", "false");
                    String path = "/etc/cloudservices/s7dam/companySettings";
                    Node optionsNode = JcrResourceUtil.createPath((String)path, (String)"nt:unstructured", (String)"nt:unstructured", (Session)session, (boolean)false);
                    Map<String, String> defaultVals = defaultCompanySettings;
                    for (String key : defaultVals.keySet()) {
                        String val = defaultVals.get(key);
                        if (optionsNode.hasProperty(key)) continue;
                        optionsNode.setProperty(key, val);
                    }
                }
                catch (RepositoryException r) {
                    log.equals("ERROR: Could not create default company settings.........***********************************");
                }
            }
            if (configResourceJcrContent.getChild("/etc/cloudservices/s7dam/defaultUploadOptions") == null) {
                S7damFolderUploadOptions uploadOpts = new S7damFolderUploadOptions(configResourceJcrContent.getResourceResolver());
                uploadOpts.createDefaultUploadOptionsNode();
            }
        }
    }

    protected void bindS7damConfigResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7damConfigResolver = s7damConfigResolver;
    }

    protected void unbindS7damConfigResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7damConfigResolver == s7damConfigResolver) {
            this.s7damConfigResolver = null;
        }
    }

    protected void bindPlatformServerService(PlatformServerService platformServerService) {
        this.platformServerService = platformServerService;
    }

    protected void unbindPlatformServerService(PlatformServerService platformServerService) {
        if (this.platformServerService == platformServerService) {
            this.platformServerService = null;
        }
    }
}

