/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.imagetools;

import com.day.cq.dam.s7dam.onprem.util.RuntimeExec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageConvert {
    public static final String JPEG_COMPRESS = "-jpegcompress";
    public static final String DEFLATE_COMPRESS = "-deflatecompress";
    public static final String LZW_COMPRESS = "-lzwcompress";
    public static final String DOWNSAMPLE_8X8 = "-downsample8x8";
    public static final String DOWNSAMPLE_2X2 = "-downsample2x2";
    public static final String DOWNSAMPLE_8X8_FLASHPIX = "-downsample8x8FlashPix";
    public static final String DEFAULT_COMPRESS = "-deflatecompress";
    public static final String DEFAULT_JPEG_QUALITY = "99";
    public static final String DEFAULT_DOWNSAMPLE_MODE = "-downsample8x8";
    public static final boolean DEFAULT_EMBED_XMP = true;
    public static final String DEFAULT_COLOR_CONVERSION = "";
    public static final String LOWER_PRIORITY = "50";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageConvert.class);
    private static final String IC_BIN = "ic";
    private String imageFormat = null;
    private String mSrcStr = new String();
    private String mDestStr = new String();
    private String mDestCompressionType = "-deflatecompress";
    private String mDestJPEGQuality = "99";
    private String mDestImageColorConversion = "";
    private String mDestImageProfile = "";
    private String mDestViewProfile = "";
    private boolean mProfileForceEmbed = false;
    private String mDestDownsampleMode = "-downsample8x8";
    private boolean mDestEmbedXMP = true;
    private String[] mOptionalParams;
    private String mLogMessage = "";
    private Long maxMemory;
    private String[] usm = null;

    public void setUnsharpMask(String[] usm) {
        this.usm = usm;
    }

    public void setMaxMemory(Long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void setSource(String srcStr) {
        this.mSrcStr = srcStr;
    }

    public void setDestination(String destStr) {
        this.mDestStr = destStr;
    }

    public void setCompressionType(String destCompressionType) {
        this.mDestCompressionType = destCompressionType;
    }

    public void setJPEGQuality(String destJPEGQuality) {
        this.mDestJPEGQuality = destJPEGQuality;
    }

    public void setImageColorConversion(String destImageColorConversion) {
        this.mDestImageColorConversion = destImageColorConversion;
    }

    public void setImageProfile(String destImageProfile) {
        this.mDestImageProfile = destImageProfile;
    }

    public void setViewProfile(String destViewProfile) {
        this.mDestViewProfile = destViewProfile;
    }

    public void setDownsampleMode(String destDownsampleMode) {
        this.mDestDownsampleMode = destDownsampleMode;
    }

    public void setEmbedXMP(boolean embedXMP) {
        this.mDestEmbedXMP = embedXMP;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    private boolean is32Bit() {
        return false;
    }

    public static void addLowerPriority(ArrayList<String> commandLst) {
        commandLst.add("-lowerpriority");
        commandLst.add(LOWER_PRIORITY);
    }

    public int optimize(String binPathStr) {
        File parentDir = new File(this.mDestStr).getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        ArrayList<String> commandLst = new ArrayList<String>();
        if (binPathStr != null) {
            if (!binPathStr.endsWith("/")) {
                binPathStr = binPathStr + "/";
            }
            commandLst.add(binPathStr + IC_BIN);
        } else {
            commandLst.add(IC_BIN);
        }
        String logFile = this.mSrcStr + ".iclog";
        commandLst.add("-nousage");
        commandLst.add("-logappend");
        commandLst.add("-logfile");
        commandLst.add(logFile);
        commandLst.add("-convert");
        commandLst.add("-overwrite");
        ImageConvert.addLowerPriority(commandLst);
        commandLst.add(this.mSrcStr);
        commandLst.add(this.mDestStr);
        commandLst.add(this.mDestCompressionType);
        commandLst.add(this.mDestDownsampleMode);
        if (this.mDestEmbedXMP) {
            commandLst.add("-embedXmpData");
        }
        if (JPEG_COMPRESS.equalsIgnoreCase(this.mDestCompressionType)) {
            commandLst.add("-jpegquality");
            commandLst.add(this.mDestJPEGQuality);
        }
        if (this.maxMemory != null) {
            commandLst.add("-maxmem");
            commandLst.add(this.maxMemory.toString());
        }
        if ("-embedded".equalsIgnoreCase(this.mDestImageColorConversion) && this.mDestViewProfile != null && this.mDestViewProfile.length() > 0) {
            commandLst.add("-viewprofile");
            commandLst.add(this.mDestViewProfile);
            commandLst.add("-embedColorProfile");
        } else if ("-imageprofile".equalsIgnoreCase(this.mDestImageColorConversion) && this.mDestImageProfile != null && this.mDestImageProfile.length() > 0 && this.mDestViewProfile != null && this.mDestViewProfile.length() > 0) {
            commandLst.add("-imageprofile");
            commandLst.add(this.mDestImageProfile);
            commandLst.add("-viewprofile");
            commandLst.add(this.mDestViewProfile);
            commandLst.add("-embedColorProfile");
        } else if ("-maintainpixeltype".equalsIgnoreCase(this.mDestImageColorConversion)) {
            commandLst.add("-maintainpixeltype");
            commandLst.add("-embedColorProfile");
        }
        if (this.mOptionalParams != null) {
            for (String mOptionalParam : this.mOptionalParams) {
                commandLst.add(mOptionalParam);
            }
        }
        if (this.usm != null) {
            commandLst.add("-usm");
            for (String st : this.usm) {
                commandLst.add(st);
            }
        }
        String[] command = commandLst.toArray(new String[commandLst.size()]);
        LOGGER.debug("ImageConvert.optimize: " + this.getCommandString(command));
        int iRetVal = RuntimeExec.execute(command, null, null, true);
        this.mLogMessage = DEFAULT_COLOR_CONVERSION;
        File log = new File(logFile);
        if (!log.exists()) {
            return iRetVal;
        }
        this.readLogFile(log, logFile);
        return iRetVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLogFile(File log, String logFile) {
        BufferedReader br = null;
        try {
            FileReader fr = new FileReader(log);
            if (fr != null) {
                br = new BufferedReader(fr);
                String logLine = null;
                while ((logLine = br.readLine()) != null) {
                    int because = logLine.indexOf("because");
                    if (because <= 0) continue;
                    this.mLogMessage = logLine.substring(because + "because".length() + 1);
                    int fromFile = this.mLogMessage.indexOf("from file");
                    if (fromFile <= 0) continue;
                    this.mLogMessage = this.mLogMessage.substring(0, fromFile);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("ImageConvert.readLogFile error", (Throwable)e);
        }
        finally {
            this.close(br);
        }
        if (!log.delete()) {
            LOGGER.warn("ImageConvert: Unable to delete log file: " + logFile);
        }
    }

    private void close(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                LOGGER.error("ImageConvert error closing stream.", (Throwable)e);
            }
        }
    }

    public String getLogError() {
        return this.mLogMessage;
    }

    public static String getErrorDescription(int errorCode) {
        if (errorCode == 0) {
            return DEFAULT_COLOR_CONVERSION;
        }
        if (errorCode == -100) {
            return "optimizeit.error.timeout";
        }
        if (errorCode == -101) {
            return "optimizeit.error.ioexception";
        }
        return "optimizeit.error." + errorCode;
    }

    private String getCommandString(String[] commands) {
        String cmdLine = DEFAULT_COLOR_CONVERSION;
        for (String command : commands) {
            if (!cmdLine.isEmpty()) {
                cmdLine = cmdLine + " ";
            }
            cmdLine = cmdLine + command;
        }
        return cmdLine;
    }
}

