/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.imagetools;

import com.day.cq.dam.s7dam.onprem.imagetools.PerspectiveQuad;
import com.day.cq.dam.s7dam.onprem.util.RuntimeExec;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageInfo.class);
    private static final String IMAGE_INFO_BIN = "ImageInfo";
    private static final String VERSION_REGEX = "[\\d\\.]+?";
    private String rootPath = "";
    private String localPath = "";
    private String fileName = "";
    private String displayName = "";
    private int width = 0;
    private int height = 0;
    private int tileBytes = 0;
    private long bytes = 0L;
    private float xRes = 0.0f;
    private float yRes = 0.0f;
    private boolean hasAlpha = false;
    private boolean hasMultipleImages = false;
    private boolean hasLayers = false;
    private boolean hasMasks = false;
    private boolean hasIccProfile = false;
    private String imageFormat = "";
    private String imageColorSpace = "";
    private String pixelEncoding = "";
    private String imageIccProfileColorSpace = "";
    private Hashtable exifInfo = new Hashtable();
    private Hashtable iptcInfo = new Hashtable();
    private boolean hasClipPath = false;
    private boolean extractXMPdata = false;
    private boolean xmpProcessed = false;
    private ArrayList<String> pathNameList = new ArrayList();
    private Vector warningList = new Vector();
    private String xmpFilename = null;
    private String fName = null;
    private String photoshopPathName;
    private final HashMap<String, PerspectiveQuad> pathQuads = new HashMap();
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public String processFile(String fName, String binPathStr) {
        this.fName = fName;
        String xmlFilename = fName + ".xml";
        this.xmpFilename = fName + ".xmp";
        String extension = "";
        Object[] command = null;
        int numArgs = 4;
        if (this.extractXMPdata) {
            numArgs += 2;
        }
        if (!this.isStringEmpty(this.photoshopPathName)) {
            numArgs += 2;
        }
        command = new String[numArgs];
        int i = 0;
        if (binPathStr != null) {
            if (!binPathStr.endsWith("/")) {
                binPathStr = binPathStr + "/";
            }
            command[i++] = binPathStr + IMAGE_INFO_BIN;
        } else {
            command[i++] = IMAGE_INFO_BIN;
        }
        command[i++] = fName;
        command[i++] = "-xmlfile";
        command[i++] = xmlFilename;
        if (this.extractXMPdata) {
            command[i++] = "-xmpfile";
            command[i++] = this.xmpFilename;
        }
        if (!this.isStringEmpty(this.photoshopPathName)) {
            command[i++] = "-quadfrompath";
            command[i++] = this.photoshopPathName;
        }
        LOGGER.info("ImageInfo.processFile: {}", (Object)Arrays.toString(command));
        int result = RuntimeExec.execute((String[])command, null, null, false);
        if (result != 0) {
            LOGGER.warn("ImageInfo.processFile failed with return: " + result);
            return "failed";
        }
        try {
            this.parseXML(xmlFilename);
        }
        catch (Exception e) {
            LOGGER.error("Exception when processing XML file for " + fName, (Throwable)e);
            return "failed";
        }
        String name = fName.replace("\\", "/");
        int nameIdx = name.lastIndexOf("/") + 1;
        this.fileName = name.substring(nameIdx);
        int pathIdx = name.indexOf(this.rootPath);
        if (pathIdx != -1) {
            this.localPath = name.substring(pathIdx + this.rootPath.length(), nameIdx);
        }
        if (this.fileName.length() == 0) {
            LOGGER.error("IMAGE INFO, filename is empty!!");
        }
        boolean xmlDeleted = this.deleteFile(xmlFilename);
        LOGGER.debug("ImageInfo.processFile: Log file = " + xmlFilename + ", deleted = " + xmlDeleted);
        LOGGER.debug("ImageInfo.processFile: Completed " + fName);
        LOGGER.debug("ImageInfo( " + fName + ").hasLayers()=" + this.hasLayers());
        LOGGER.debug("ImageInfo( " + fName + ").hasMasks()=" + this.hasMasks());
        LOGGER.debug("ImageInfo( " + fName + ").hasICCProfile()=" + this.hasICCProfile());
        LOGGER.debug("ImageInfo( " + fName + ").imageFormat()=" + this.imageFormat());
        LOGGER.debug("ImageInfo( " + fName + ").imageColorSpace()=" + this.imageColorSpace());
        LOGGER.debug("ImageInfo( " + fName + ").imageIccProfileColorSpace()=" + this.imageIccProfileColorSpace());
        return "success";
    }

    private void parseXML(String xmlFilename) throws Exception {
        LOGGER.trace("ImageInfo.parseXML: xmlFilename = " + xmlFilename);
        Document document = this.loadXML(xmlFilename);
        NodeList nodes_i = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes_i.getLength(); ++i) {
            String tagName;
            Node node_i = nodes_i.item(i);
            if (node_i.getNodeType() != 1 || !(tagName = ((Element)node_i).getTagName()).equalsIgnoreCase(IMAGE_INFO_BIN)) continue;
            Element ImageInfoNode = (Element)node_i;
            this.width = Integer.parseInt(ImageInfoNode.getAttribute("ImageWidth"));
            this.height = Integer.parseInt(ImageInfoNode.getAttribute("ImageHeight"));
            this.pixelEncoding = ImageInfoNode.getAttribute("ImagePixelEncoding");
            this.tileBytes = Integer.parseInt(ImageInfoNode.getAttribute("ImageTileBytes"));
            this.bytes = Long.parseLong(ImageInfoNode.getAttribute("ImageBytes"));
            String temp = ImageInfoNode.getAttribute("ImageXRes");
            if (temp != null && temp.length() > 0 && !"nan".equalsIgnoreCase(temp)) {
                try {
                    this.xRes = Float.parseFloat(temp);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((temp = ImageInfoNode.getAttribute("ImageYRes")) != null && temp.length() > 0 && !"nan".equalsIgnoreCase(temp)) {
                try {
                    this.yRes = Float.parseFloat(temp);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.hasAlpha = ImageInfoNode.getAttribute("ImageHasAlpha").equalsIgnoreCase("true");
            this.hasMultipleImages = ImageInfoNode.getAttribute("ImageHasMultipleImages").equalsIgnoreCase("true");
            this.hasLayers = ImageInfoNode.getAttribute("ImageHasLayers").equalsIgnoreCase("true");
            this.hasMasks = ImageInfoNode.getAttribute("ImageHasLayerMasks").equalsIgnoreCase("true");
            this.hasIccProfile = ImageInfoNode.getAttribute("ImageHasIccProfile").equalsIgnoreCase("true");
            this.hasClipPath = ImageInfoNode.getAttribute("ImageHasClipPath").equalsIgnoreCase("true");
            NodeList nodes_j = node_i.getChildNodes();
            for (int j = 0; j < nodes_j.getLength(); ++j) {
                Node item;
                int k;
                Node node_j = nodes_j.item(j);
                if (node_j.getNodeType() != 1) continue;
                tagName = ((Element)node_j).getTagName();
                NodeList nodes_k = node_j.getChildNodes();
                if (tagName.equalsIgnoreCase("ImageFormat")) {
                    Node node_k;
                    if (nodes_k.item(1) == null || (node_k = nodes_k.item(1)).getNodeType() != 1) continue;
                    this.imageFormat = ((Element)node_k).getTagName();
                    continue;
                }
                if (tagName.equalsIgnoreCase("ImageColorSpace")) {
                    Node node_k;
                    if (nodes_k.item(1) == null || (node_k = nodes_k.item(1)).getNodeType() != 1) continue;
                    this.imageColorSpace = ((Element)node_k).getTagName();
                    continue;
                }
                if (tagName.equalsIgnoreCase("ImageIccProfileColorSpace")) {
                    Node node_k;
                    if (nodes_k.item(1) == null || (node_k = nodes_k.item(1)).getNodeType() != 1) continue;
                    this.imageIccProfileColorSpace = ((Element)node_k).getTagName();
                    continue;
                }
                if (tagName.equalsIgnoreCase("ExifInfo")) {
                    NamedNodeMap map = node_j.getAttributes();
                    for (k = 0; k < map.getLength(); ++k) {
                        item = map.item(k);
                        this.exifInfo.put(item.getNodeName(), item.getNodeValue());
                    }
                    continue;
                }
                if (tagName.equalsIgnoreCase("IptcInfo")) {
                    NamedNodeMap map = node_j.getAttributes();
                    for (k = 0; k < map.getLength(); ++k) {
                        item = map.item(k);
                        this.iptcInfo.put(item.getNodeName(), item.getNodeValue());
                    }
                    continue;
                }
                if (tagName.equalsIgnoreCase("PhotoshopPathList")) {
                    for (int k2 = 0; k2 < nodes_k.getLength(); ++k2) {
                        String pathName;
                        Node node_k = nodes_k.item(k2);
                        if (node_k.getNodeType() != 1 || !node_k.getNodeName().equals("PhotoshopPath") || (pathName = ((Element)node_k).getAttribute("PhotoshopPathName")) == null) continue;
                        this.pathNameList.add(pathName);
                        NodeList nodes_l = node_k.getChildNodes();
                        for (int l = 0; l < nodes_l.getLength(); ++l) {
                            Node node_l = nodes_l.item(l);
                            if (node_l.getNodeType() != 1 || !node_l.getNodeName().equals("PerspectiveQuad")) continue;
                            try {
                                double x0 = Double.parseDouble(((Element)node_l).getAttribute("X0"));
                                double y0 = Double.parseDouble(((Element)node_l).getAttribute("Y0"));
                                double x1 = Double.parseDouble(((Element)node_l).getAttribute("X1"));
                                double y1 = Double.parseDouble(((Element)node_l).getAttribute("Y1"));
                                double x2 = Double.parseDouble(((Element)node_l).getAttribute("X2"));
                                double y2 = Double.parseDouble(((Element)node_l).getAttribute("Y2"));
                                double x3 = Double.parseDouble(((Element)node_l).getAttribute("X3"));
                                double y3 = Double.parseDouble(((Element)node_l).getAttribute("Y3"));
                                PerspectiveQuad quad = new PerspectiveQuad(x0, y0, x1, y1, x2, y2, x3, y3);
                                this.pathQuads.put(pathName, quad);
                                continue;
                            }
                            catch (Exception e) {
                                LOGGER.warn("ImageInfo.parseXml: Invalid PerspectiveQuad attributes.");
                            }
                        }
                    }
                    continue;
                }
                if (!tagName.equalsIgnoreCase("WarningList")) continue;
                for (int k3 = 0; k3 < nodes_k.getLength(); ++k3) {
                    String warning;
                    Node node_k = nodes_k.item(k3);
                    if (node_k.getNodeType() != 1 || (warning = ((Element)node_k).getAttribute("WarningDescription")) == null || warning.length() <= 0 || warning.startsWith("Error trying to get XMP data for")) continue;
                    this.warningList.add(warning);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadXML(String xmlFilename) throws Exception {
        FileInputStream xmlStream = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlStream = new FileInputStream(xmlFilename);
            InputSource inputSource = new InputSource(new InputStreamReader((InputStream)xmlStream, "UTF-8"));
            Document document = builder.parse(inputSource);
            return document;
        }
        finally {
            try {
                if (xmlStream != null) {
                    xmlStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("ImageInfo.loadXML error closing stream.", (Throwable)e);
            }
        }
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public float xRes() {
        return (float)Math.round(this.xRes * 10.0f) * 0.1f;
    }

    public float yRes() {
        return (float)Math.round(this.yRes * 10.0f) * 0.1f;
    }

    public String pixelEncoding() {
        return this.pixelEncoding;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public boolean hasLayers() {
        return this.hasLayers;
    }

    public boolean hasMasks() {
        return this.hasMasks;
    }

    public boolean hasMultipleImages() {
        return this.hasMultipleImages;
    }

    public boolean hasICCProfile() {
        return this.hasIccProfile;
    }

    public String imageFormat() {
        return this.imageFormat;
    }

    public String imageColorSpace() {
        return this.imageColorSpace;
    }

    public String imageIccProfileColorSpace() {
        return this.imageIccProfileColorSpace;
    }

    public String imagename() {
        if (this.fileName.lastIndexOf(46) >= 0) {
            return this.fileName.substring(0, this.fileName.lastIndexOf(46));
        }
        return this.fileName;
    }

    public String filename() {
        return this.fileName;
    }

    public void setRootPath(String rootPath) {
        if (!(rootPath = rootPath.replace('\\', '/')).endsWith("/")) {
            rootPath = rootPath + "/";
        }
    }

    public String rootpath() {
        return this.rootPath;
    }

    public String localpath() {
        return this.localPath;
    }

    public String rootpathlocalpath() {
        return this.rootPath + this.localPath;
    }

    public String localpathimagename() {
        return this.localPath + this.fileName;
    }

    public String filespec() {
        return this.rootPath + this.localPath + this.fileName;
    }

    public long bytes() {
        return this.bytes;
    }

    public int tileBytes() {
        return this.tileBytes;
    }

    public Hashtable exifInfo() {
        return this.exifInfo;
    }

    public Hashtable iptcInfo() {
        return this.iptcInfo;
    }

    public List<String> getPathNameList() {
        return this.pathNameList;
    }

    public Vector warningList() {
        return this.warningList;
    }

    public boolean hasWarnings() {
        return this.warningList != null && this.warningList.size() > 0;
    }

    public boolean hasClipPath() {
        return this.hasClipPath;
    }

    public boolean knownFormat() {
        String format = this.imageFormat();
        return format != null && format.length() > 0 && format.indexOf("Unknown") < 0;
    }

    public void setFilename(String fName) {
        this.fileName = fName;
    }

    public void setLocalPath(String localPath) {
    }

    public void setDisplayname(String fDisplayname) {
        this.displayName = fDisplayname;
    }

    public String getDisplayname() {
        return this.displayName;
    }

    public void setExtractXMP(boolean extractXMP) {
        this.extractXMPdata = extractXMP;
    }

    public boolean getExtractXMP() {
        return this.extractXMPdata;
    }

    public void setXMPProcessed() {
        this.xmpProcessed = true;
    }

    public boolean isXMPProcessed() {
        return this.xmpProcessed;
    }

    public Document getXMPDocument() {
        if (this.extractXMPdata) {
            File xmpFile = new File(this.xmpFilename);
            LOGGER.debug("ImageInfo.processFile: xmpFilename = " + this.xmpFilename + "; exists = " + xmpFile.exists() + "; length = " + xmpFile.length());
            if (xmpFile.exists() && xmpFile.length() > 0L) {
                try {
                    return this.loadXML(this.xmpFilename);
                }
                catch (Exception e) {
                    LOGGER.error("Exception when processing XMP file for " + this.fName, (Throwable)e);
                    this.warningList.add(e.getMessage());
                }
            } else {
                LOGGER.debug("ImageInfo.processFile: No XMP block to process for " + this.fName);
            }
        }
        return null;
    }

    public String getSuffix() {
        int index;
        if (this.fileName != null && (index = this.fileName.lastIndexOf(".")) > 0) {
            return this.fileName.substring(index + 1);
        }
        return null;
    }

    public boolean suffix(String suffix) {
        if (this.fileName != null) {
            if (suffix.startsWith(".")) {
                return this.fileName.toLowerCase().endsWith(suffix.toLowerCase());
            }
            return this.fileName.toLowerCase().endsWith("." + suffix.toLowerCase());
        }
        return false;
    }

    public String getXmpFilename() {
        return this.xmpFilename;
    }

    public String getPhotoshopPathName() {
        return this.photoshopPathName;
    }

    public void setPhotoshopPathName(String photoshopPathName) {
        this.photoshopPathName = photoshopPathName;
    }

    public PerspectiveQuad getPerspectiveQuad(String pathName) {
        return this.pathQuads.get(pathName);
    }

    public Map<String, PerspectiveQuad> getPerspectiveQuads() {
        return this.pathQuads;
    }

    public String getVersion() {
        String[] command = new String[]{IMAGE_INFO_BIN, "-version"};
        String versionRegEx = VERSION_REGEX;
        try {
            return RuntimeExec.version(command, null, null, versionRegEx);
        }
        catch (Exception ex) {
            LOGGER.error("ImageInfo.getVersion error.", (Throwable)ex);
            return null;
        }
    }

    private boolean isStringEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private boolean deleteFile(String filePath) {
        File file = new File(filePath);
        return file.delete();
    }

    static {
        factory.setNamespaceAware(true);
    }
}

