/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.platform.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.s7dam.onprem.platform.PlatformServerService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class PlatformServerServiceImpl
implements PlatformServerService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String IS_CMD_SERVLET = "lookup-cache";
    private final String IS_ASSET_TYPE = "IS";
    private HttpClient httpClient;

    @Override
    public void invalidateAssetCache(String path, ResourceResolver resolver, S7damConfigOnPrem s7damConfig) {
        if (StringUtils.isEmpty((String)path) || s7damConfig == null || StringUtils.isEmpty((String)s7damConfig.getCompanyName())) {
            this.log.error("Invalidate path or config");
            return;
        }
        Calendar assetInvalidateCacheDate = Calendar.getInstance();
        try {
            this.setLastModifiedDate(path, assetInvalidateCacheDate, resolver);
            this.saveLastModifiedDate(path, resolver);
            List catalogServers = s7damConfig.getCatalogServers();
            if (catalogServers != null) {
                for (String catalogServer : catalogServers) {
                    this.invalidateAssetCache(s7damConfig.getCompanyName(), this.getAssetCacheId(path), assetInvalidateCacheDate, "IS", catalogServer);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error invalidating asset in s7 platform server Cache {}", (Object)e.getMessage());
        }
    }

    private void invalidateAssetCache(String company, String path, Calendar lastModified, String assetType, String endpoint) {
        try {
            URL platformServerURL = new URL(endpoint);
            PostMethod request = new PostMethod(platformServerURL + "lookup-cache" + "?action=purgeAsset");
            String data = "&rootId=" + URIUtil.encodeQuery((String)company) + "&assetId=" + URIUtil.encodeQuery((String)path) + "&assetType=" + URIUtil.encodeQuery((String)assetType) + "&lastModified=" + lastModified.getTimeInMillis();
            String response = this.executeRequest(request, data);
            this.log.info("invalidateAssetCache for [{}] with response [{}]", (Object)path, (Object)response);
        }
        catch (URIException e) {
            this.log.error("failed to invalidateAssetCache - malformed URI {}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            this.log.error("failed to invalidateAssetCache - malformed URL {}", (Object)e.getMessage());
        }
    }

    private String getAssetCacheId(String path) {
        return path.replaceFirst("^/content/dam/", "");
    }

    @Override
    public void invalidateCompanyCache(ResourceResolver resolver, S7damConfigOnPrem s7damConfig) {
        if (s7damConfig == null || StringUtils.isEmpty((String)s7damConfig.getCompanyName())) {
            this.log.error("Invalidate config");
            return;
        }
        Calendar invalidateCacheDate = Calendar.getInstance();
        try {
            this.log.info("Invalidate S7 On Premise Company platform server catalog cache");
            this.setLastModifiedDate(s7damConfig.getCloudConfigPath(), invalidateCacheDate, resolver);
            List catalogServers = s7damConfig.getCatalogServers();
            for (String catalogServer : catalogServers) {
                this.invalidateCompanyCache(s7damConfig.getCompanyName(), invalidateCacheDate, catalogServer);
            }
        }
        catch (Exception e) {
            this.log.error("Error invalidating s7 On Premise Company platform server catalog cache {}", (Object)e.getMessage());
        }
    }

    private void invalidateCompanyCache(String company, Calendar lastModified, String endpoint) {
        try {
            URL platformServerURL = new URL(endpoint);
            PostMethod request = new PostMethod(platformServerURL + "lookup-cache" + "?action=purgeCompany");
            String data = "&rootId=" + URIUtil.encodeQuery((String)company) + "&lastModified=" + lastModified.getTimeInMillis();
            String response = this.executeRequest(request, data);
            this.log.info("invalidateCompanyCache Catalog Server Cache! [{}]", (Object)response);
        }
        catch (URIException e) {
            this.log.error("failed invalidateCompanyCache - malformed URI {}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            this.log.error("failed invalidateCompanyCache - malformed URL {}", (Object)e.getMessage());
        }
    }

    @Override
    public void invalidateEntireServerCache(S7damConfigOnPrem s7damConfig) {
        if (s7damConfig == null || StringUtils.isEmpty((String)s7damConfig.getCompanyName())) {
            this.log.error("Invalidate config");
            return;
        }
        try {
            this.log.info("Invalidate entire s7 On Premise Server cache");
            List catalogServers = s7damConfig.getCatalogServers();
            for (String catalogServer : catalogServers) {
                this.invalidateEntireServerCache(catalogServer);
            }
        }
        catch (Exception e) {
            this.log.error("Error invalidating asset in platform server catalog cache {}", (Object)e.getMessage());
        }
    }

    private void invalidateEntireServerCache(String endpoint) {
        try {
            URL platformServerURL = new URL(endpoint);
            PostMethod request = new PostMethod(platformServerURL + "lookup-cache" + "?action=clearCache");
            String response = this.executeRequest(request, null);
            this.log.info("invalidateEntire Catalog Server Cache! [{}]", (Object)response);
        }
        catch (MalformedURLException e) {
            this.log.error("failed to invalidateEntireServerCache - malformed URL {}", (Object)e.getMessage());
        }
    }

    @Override
    public boolean isAssetCached(String path, S7damConfigOnPrem s7damConfig) {
        if (StringUtils.isEmpty((String)path) || s7damConfig == null || StringUtils.isEmpty((String)s7damConfig.getCompanyName())) {
            this.log.error("Invalidate path or config");
            return false;
        }
        try {
            this.log.info("check asset Caches for {}", (Object)path);
            List catalogServers = s7damConfig.getCatalogServers();
            for (String catalogServer : catalogServers) {
                if (!this.isAssetCached(s7damConfig.getCompanyName(), path, "IS", catalogServer)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Error checking asset Catalog Server Cache Status {}", (Object)e.getMessage());
        }
        return false;
    }

    private boolean isAssetCached(String company, String path, String assetType, String endpoint) {
        try {
            URL platformServerURL = new URL(endpoint);
            PostMethod request = new PostMethod(platformServerURL + "lookup-cache" + "?action=isAssetCached");
            String data = "&rootId=" + URIUtil.encodeQuery((String)company) + "&assetId=" + URIUtil.encodeQuery((String)path) + "&assetType=" + URIUtil.encodeQuery((String)assetType);
            String response = this.executeRequest(request, data);
            if ("true".equals(response)) {
                return true;
            }
        }
        catch (URIException e) {
            this.log.error("failed isAssetCached - malformed URI {}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            this.log.error("failed isAssetCached - malformed URL {}", (Object)e.getMessage());
        }
        return false;
    }

    @Override
    public boolean isCompanyCached(S7damConfigOnPrem s7damConfig) {
        if (s7damConfig == null || StringUtils.isEmpty((String)s7damConfig.getCompanyName())) {
            this.log.error("Invalidate config");
            return false;
        }
        try {
            this.log.info("is On premise company Cached for");
            List catalogServers = s7damConfig.getCatalogServers();
            for (String catalogServer : catalogServers) {
                if (!this.isCompanyCached(s7damConfig.getCompanyName(), catalogServer)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("failed in isCompanyCached request to Catalog Server {}", (Object)e.getMessage());
        }
        return false;
    }

    private boolean isCompanyCached(String company, String endpoint) {
        try {
            URL platformServerURL = new URL(endpoint);
            PostMethod request = new PostMethod(platformServerURL + "lookup-cache" + "?action=isCompanyCached");
            String data = "&rootId=" + URIUtil.encodeQuery((String)company);
            String response = this.executeRequest(request, data);
            if ("true".equals(response)) {
                return true;
            }
        }
        catch (URIException e) {
            this.log.error("failed isCompanyCached - malformed URI {}", (Object)e.getMessage());
        }
        catch (MalformedURLException e) {
            this.log.error("failed isCompanyCached  - malformed URL {}", (Object)e.getMessage());
        }
        return false;
    }

    @Override
    public int getCacheCount(S7damConfigOnPrem s7damConfig) {
        int count = 0;
        if (s7damConfig == null || StringUtils.isEmpty((String)s7damConfig.getCompanyName())) {
            this.log.error("Invalidate config");
            return 0;
        }
        try {
            this.log.info("is On premise company Cached for");
            List catalogServers = s7damConfig.getCatalogServers();
            for (String catalogServer : catalogServers) {
                int nextCount = this.getCacheCount(catalogServer);
                count = count < nextCount ? nextCount : count;
                this.log.debug("s7 dam Catalog cache count = " + nextCount + " for " + catalogServer);
            }
        }
        catch (Exception e) {
            this.log.error("Error getting cache count from platform server catalog cache {}", (Object)e.getMessage());
        }
        return count;
    }

    private int getCacheCount(String endpoint) {
        try {
            URL platformServerURL = new URL(endpoint);
            PostMethod request = new PostMethod(platformServerURL + "lookup-cache" + "?action=getCount");
            String response = this.executeRequest(request, null);
            return Integer.parseInt(response);
        }
        catch (MalformedURLException e) {
            this.log.error("failed getCacheCount - improperly formed URL {}", (Object)e.getMessage());
        }
        catch (NumberFormatException e) {
            this.log.error("failed getCacheCount - parsing error {}", (Object)e.getMessage());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeRequest(PostMethod request, String data) {
        try {
            if (data != null) {
                request.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/x-www-form-urlencoded", "UTF-8"));
            }
            this.getHttpClient().executeMethod((HttpMethod)request);
            String string = request.getResponseBodyAsString();
            return string;
        }
        catch (HttpException e) {
            this.log.error("failed executeRequest protocol violation: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            this.log.error("failed executeRequest transport error: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.log.error("failed executeRequest executing PlatformServer post request for {}", (Object)request.getPath());
        }
        finally {
            request.releaseConnection();
        }
        return "";
    }

    private synchronized void setLastModifiedDate(String path, Calendar date, ResourceResolver resolver) {
        if (resolver == null || date == null || StringUtils.isEmpty((String)path)) {
            return;
        }
        try {
            Resource resource = resolver.getResource(path + "/" + "jcr:content");
            if (resource != null) {
                Node node = (Node)resource.adaptTo(Node.class);
                node.setProperty("dam:lastInvalidateCache", date);
            }
        }
        catch (RepositoryException e) {
            this.log.warn("failed setLastModifiedDate for [{}]", (Object)path);
        }
    }

    private synchronized void saveLastModifiedDate(String path, ResourceResolver resolver) {
        if (resolver == null || StringUtils.isEmpty((String)path)) {
            return;
        }
        try {
            Resource resource = resolver.getResource(path + "/" + "jcr:content");
            if (resource != null) {
                Node node = (Node)resource.adaptTo(Node.class);
                node.getSession().save();
            }
        }
        catch (RepositoryException e) {
            this.log.warn("failed save last Modified date for [{}]", (Object)path);
        }
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        }
        return this.httpClient;
    }
}

