/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=true)
public abstract class AbstractOnPremiseIngestProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOnPremiseIngestProcess.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String[] UPLOAD_MIMETYPES = new String[]{"image/", "video/"};
    protected static final String PN_S7_IMAGE_COPY_PATH = "dam:s7damImageCopyPath";
    @Reference
    protected S7damConfigResolver ccResolver;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        LOG.info("On Premise processing step: execute");
        ResourceResolver rr = this.getResourceResolver(workflowSession.getSession());
        Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
        S7damConfigOnPrem s7damConfig = this.getCloudConfig(workItem.getWorkflow().getWorkflowData().getMetaDataMap());
        if (asset != null && s7damConfig != null && this.isTypeSupported(rr, asset.getPath())) {
            if (DEBUG) {
                LOG.debug("Executing workflow for payload {}", (Object)asset.getPath());
            }
            this.processOnPremise(asset, s7damConfig, rr);
        } else if (asset == null || s7damConfig == null) {
            String message;
            if (asset == null) {
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                message = "execute: failed to process [{" + wfPayload + "}] " + "in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            } else {
                message = "missing cloud configuration in workflow metadata";
            }
            throw new WorkflowException(message);
        }
    }

    protected String getTempFilePath(Asset asset, ResourceResolver rr, boolean forceCreate) {
        String tmpPath;
        block6: {
            Node jcrContent = (Node)rr.getResource(asset.getPath() + "/jcr:content").adaptTo(Node.class);
            tmpPath = null;
            try {
                tmpPath = jcrContent.getProperty(PN_S7_IMAGE_COPY_PATH).getString();
            }
            catch (RepositoryException e) {
                if (forceCreate) break block6;
                LOG.error("getTempFilePath: unable to access temp path property {}", (Throwable)e);
            }
        }
        if (tmpPath == null || forceCreate) {
            try {
                File f = this.writeContentToTempFile(asset);
                if (f != null) {
                    tmpPath = f.getPath();
                }
            }
            catch (IOException e) {
                LOG.error("IOException: unable to write {}", (Object)asset.getPath());
            }
        }
        return tmpPath;
    }

    protected S7damConfigOnPrem getCloudConfig(MetaDataMap workflowMetaDataMap) {
        String[] args = this.buildArguments(workflowMetaDataMap);
        List argsValues = this.getValuesFromArgs(Arguments.PAGE_CC_PATH.argumentName, args);
        S7damConfigOnPrem s7Config = argsValues.size() == 1 ? this.ccResolver.getS7damConfigOnPrem((String)argsValues.get(0)) : this.ccResolver.getS7damConfigOnPrem(null);
        return s7Config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeContentToTempFile(Asset asset) throws IOException {
        InputStream inStream = null;
        FileOutputStream outStream = null;
        File tmpFile = null;
        try {
            int bytesRead;
            inStream = asset.getOriginal().getStream();
            tmpFile = File.createTempFile("scene7", ".tmp");
            outStream = new FileOutputStream(tmpFile);
            byte[] buf = new byte[65536];
            while ((bytesRead = inStream.read(buf)) > 0) {
                outStream.write(buf, 0, bytesRead);
            }
            this.closeStream(inStream);
            this.closeStream(outStream);
        }
        catch (Throwable throwable) {
            this.closeStream(inStream);
            this.closeStream(outStream);
            throw throwable;
        }
        return tmpFile;
    }

    private void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            LOG.error("IOException: closing InputStream");
        }
    }

    private void closeStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            LOG.error("IOException: closing OutputStream");
        }
    }

    protected boolean isTypeSupported(ResourceResolver resolver, String path) {
        try {
            String mimeType = this.getMimeType(resolver, path);
            for (String element : UPLOAD_MIMETYPES) {
                if (!mimeType.startsWith(element)) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            LOG.error("isTypeSupported failed {}", (Throwable)e);
        }
        return false;
    }

    private String getMimeType(ResourceResolver resolver, String path) throws RepositoryException {
        Node original = (Node)resolver.getResource(path + "/jcr:content/renditions/original/jcr:content").adaptTo(Node.class);
        return original.getProperty("jcr:mimeType").getString();
    }

    protected String[] buildArguments(MetaDataMap metaData) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (Arguments argument : Arguments.values()) {
            String argumentValue = (String)metaData.get(argument.argumentName, String.class);
            if (!StringUtils.isNotBlank((String)argumentValue)) continue;
            arguments.add(argument.getArgumentPrefix() + argumentValue);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    abstract void processOnPremise(Asset var1, S7damConfigOnPrem var2, ResourceResolver var3);

    protected void bindCcResolver(S7damConfigResolver s7damConfigResolver) {
        this.ccResolver = s7damConfigResolver;
    }

    protected void unbindCcResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.ccResolver == s7damConfigResolver) {
            this.ccResolver = null;
        }
    }

    protected static enum Arguments {
        PAGE_CC_PATH("dam:s7damCloudConfigPath");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

