/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.s7dam.onprem.process.AbstractOnPremiseIngestProcess;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Automatically creating an image set and adding the image being updated into it for S7 On Premise server"}), @Property(name="process.label", value={"S7Dam On Premise Autoset creation Process"})})
public class S7damAutosetProcess
extends AbstractOnPremiseIngestProcess {
    private static final Logger LOG = LoggerFactory.getLogger(S7damAutosetProcess.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String PN_S7_AUTOSET_INFO = "dam:s7AutosetProcessStatus";

    @Override
    protected void processOnPremise(Asset asset, S7damConfigOnPrem s7damConfig, ResourceResolver rr) {
        long currentTime = System.currentTimeMillis();
        long endTime = currentTime + 5000L;
        while (System.currentTimeMillis() - endTime > 5000L) {
        }
        this.updateStatus("Complete", asset, rr);
    }

    private void updateStatus(String status, Asset asset, ResourceResolver rr) {
        Node jcrContent = (Node)rr.getResource(asset.getPath() + "/jcr:content").adaptTo(Node.class);
        try {
            jcrContent.setProperty(PN_S7_AUTOSET_INFO, status);
            jcrContent.getSession().save();
        }
        catch (RepositoryException e) {
            LOG.error("updateStatus: unable to update Autoset creation status {}", (Throwable)e);
        }
    }
}

