/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.s7dam.onprem.imagetools.ImageInfo;
import com.day.cq.dam.s7dam.onprem.process.AbstractOnPremiseIngestProcess;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Extracts Image Metadata for S7 On Premise server"}), @Property(name="process.label", value={"S7Dam On Premise Image Info Process"})})
public class S7damExtractImageInfoProcess
extends AbstractOnPremiseIngestProcess {
    private static final Logger LOG = LoggerFactory.getLogger(S7damExtractImageInfoProcess.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String PN_S7_EXTRACT_IMAGE_INFO = "dam:s7ImageInfoProcessStatus";

    @Override
    protected void processOnPremise(Asset asset, S7damConfigOnPrem s7damConfig, ResourceResolver rr) {
        ImageInfo imageInfo = new ImageInfo();
        String onPremisePath = this.getTempFilePath(asset, rr, false);
        String status = "failed";
        if (onPremisePath != null) {
            String exePath = s7damConfig.getImageServerTools();
            if ("success".equals(imageInfo.processFile(onPremisePath, exePath))) {
                this.writeImageInfo(imageInfo, asset, rr);
                status = "success";
            } else {
                LOG.error("Failed to extract image info");
            }
        } else {
            LOG.error("Path to temp file is missing");
            this.updateStatus("Failed, no temp file available", asset, rr);
        }
        this.updateStatus(status, asset, rr);
    }

    private void writeImageInfo(ImageInfo imageInfo, Asset asset, ResourceResolver rr) {
        Node jcrContent = (Node)rr.getResource(asset.getPath() + "/" + "jcr:content").adaptTo(Node.class);
        try {
            jcrContent.setProperty("dam:s7damWidth", (long)imageInfo.width());
            jcrContent.setProperty("dam:s7damHeight", (long)imageInfo.height());
            jcrContent.setProperty("dam:s7damAnchorX", (long)(imageInfo.width() / 2));
            jcrContent.setProperty("dam:s7damAnchorY", (long)(imageInfo.height() / 2));
            jcrContent.getSession().save();
        }
        catch (RepositoryException e) {
            LOG.error("writeImageInfo: unable to write out image settings", (Throwable)e);
        }
    }

    private void updateStatus(String status, Asset asset, ResourceResolver rr) {
        Node jcrContent = (Node)rr.getResource(asset.getPath() + "/jcr:content").adaptTo(Node.class);
        try {
            jcrContent.setProperty(PN_S7_EXTRACT_IMAGE_INFO, status);
            jcrContent.getSession().save();
        }
        catch (RepositoryException e) {
            LOG.error("updateStatus: unable to update Image Info extract status {}", (Throwable)e);
        }
    }
}

