/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.s7dam.onprem.process.AbstractOnPremiseIngestProcess;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Copies Dam Image to location accessible to the S7 On Premise server"}), @Property(name="process.label", value={"S7Dam On Premise Image Copy Process"})})
public class S7damImageCopyProcess
extends AbstractOnPremiseIngestProcess {
    private static final Logger LOG = LoggerFactory.getLogger(S7damImageCopyProcess.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();

    @Override
    protected void processOnPremise(Asset asset, S7damConfigOnPrem s7damConfig, ResourceResolver rr) {
        String onPremisePath = this.getTempFilePath(asset, rr, true);
        String status = "failed";
        if (onPremisePath != null) {
            status = onPremisePath;
        } else {
            LOG.error("S7damImageCopyProcess: Failed to create temp image");
            this.updateStatus("UploadFailed", asset, rr);
        }
        this.updateStatus(status, asset, rr);
    }

    private void updateStatus(String status, Asset asset, ResourceResolver rr) {
        Node jcrContent = (Node)rr.getResource(asset.getPath() + "/jcr:content").adaptTo(Node.class);
        try {
            jcrContent.setProperty("dam:s7damImageCopyPath", status);
            jcrContent.getSession().save();
        }
        catch (RepositoryException e) {
            LOG.error("updateStatus: unable to update Image Info extract status {}", (Throwable)e);
        }
    }
}

