/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.s7dam.onprem.imagetools.ImageConvert;
import com.day.cq.dam.s7dam.onprem.platform.PlatformServerService;
import com.day.cq.dam.s7dam.onprem.process.AbstractOnPremiseIngestProcess;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Optimizes image asset for use with Scene7 Image Server On Premise server."}), @Property(name="process.label", value={"S7Dam On Premise Image Optimization"})})
public class S7damPtiffProcess
extends AbstractOnPremiseIngestProcess {
    private static final Logger LOG = LoggerFactory.getLogger(S7damPtiffProcess.class);
    private static final String PN_S7_PTIFF_INFO = "dam:s7PtiffProcessStatus";
    private static final String PV_S7_PTIFF_MIME_TYPE = "image/ptiff";
    @Reference
    private PlatformServerService platformServerService;

    @Override
    protected void processOnPremise(Asset asset, S7damConfigOnPrem s7damConfig, ResourceResolver rr) {
        Node jcrContent = (Node)rr.getResource(asset.getPath() + "/jcr:content").adaptTo(Node.class);
        this.updateStatus("Started", jcrContent);
        String destRelPath = S7damPtiffProcess.getUuidTifPath();
        String fullPtiffPath = s7damConfig.getImageServerMount() + destRelPath;
        if (this.generatePtiff(fullPtiffPath, asset, s7damConfig, rr) == 0) {
            this.generateRendition(fullPtiffPath, asset);
            this.updateStatus("Complete", jcrContent);
            this.setJCRProperty("dam:s7damOnPremisePTiffPath", destRelPath, jcrContent);
            this.setJCRProperty("dam:s7damType", "Image", jcrContent);
        }
        this.platformServerService.invalidateAssetCache(asset.getPath(), rr, s7damConfig);
    }

    private int generatePtiff(String ptiffPath, Asset asset, S7damConfigOnPrem s7damConfig, ResourceResolver rr) {
        ImageConvert imgConvert = new ImageConvert();
        String tempFilePath = this.getTempFilePath(asset, rr, false);
        imgConvert.setSource(tempFilePath);
        imgConvert.setDestination(ptiffPath);
        String exePath = s7damConfig.getImageServerTools();
        return imgConvert.optimize(exePath);
    }

    private void generateRendition(String ptiffPath, Asset asset) {
        try {
            FileInputStream ptiff = new FileInputStream(ptiffPath);
            asset.addRendition("Dynamic Media ptiff", (InputStream)ptiff, PV_S7_PTIFF_MIME_TYPE);
        }
        catch (FileNotFoundException e) {
            LOG.error("error generating ptiff rendition {}", (Object)e.getMessage());
        }
    }

    private static String getUuidTifPath() {
        UUID uuid = UUID.randomUUID();
        String uuidStr = uuid.toString();
        return uuidStr.substring(0, 3) + "/" + uuidStr + ".tif";
    }

    private void setJCRProperty(String jcrPropNm, String jcrPropValue, Node jcrContent) {
        try {
            jcrContent.setProperty(jcrPropNm, jcrPropValue);
            jcrContent.getSession().save();
        }
        catch (RepositoryException e) {
            LOG.error("updateStatus: unable to update Ptiff generation property {}", (Throwable)e);
        }
    }

    private void updateStatus(String status, Node jcrContent) {
        this.setJCRProperty(PN_S7_PTIFF_INFO, status, jcrContent);
    }

    protected void bindPlatformServerService(PlatformServerService platformServerService) {
        this.platformServerService = platformServerService;
    }

    protected void unbindPlatformServerService(PlatformServerService platformServerService) {
        if (this.platformServerService == platformServerService) {
            this.platformServerService = null;
        }
    }
}

