/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.servlets;

import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.onprem.catalog.AssetField;
import com.day.cq.dam.s7dam.onprem.catalog.CatalogAssetRecord;
import com.day.cq.dam.s7dam.onprem.catalog.CatalogResolver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"dam:Asset", "nt:unstructured"}, methods={"GET", "POST"}, extensions={"xml"}, selectors={"s7catalog"})
public class S7damAssetLookupServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(S7damAssetLookupServlet.class);
    @Reference
    private S7damConfigResolver s7configResolver;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/xml");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        String catalogOutput = "";
        String assetType = "IS";
        String lastModified = "";
        try {
            if (request.getResource().getPath() != null) {
                CatalogResolver resolver = new CatalogResolver();
                String[] selectors = request.getRequestPathInfo().getSelectors();
                if (selectors.length > 1) {
                    assetType = selectors[1];
                }
                List<CatalogAssetRecord> records = resolver.getCatalogDataRecords(request.getResource().getPath(), request, this.s7configResolver);
                for (CatalogAssetRecord record : records) {
                    if (record.containsField(AssetField.lastModified)) {
                        lastModified = " lastModified=\"" + record.getField(AssetField.lastModified) + "\"";
                    }
                    catalogOutput = catalogOutput + "<AssetAttributes xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" rootId=\"" + record.getRootId() + "\" id=\"" + record.getIpsId() + "\" type=\"" + assetType + "\"" + lastModified + ">";
                    if (record.containsField(AssetField.Anchor_X) && record.containsField(AssetField.Anchor_Y)) {
                        catalogOutput = catalogOutput + "<Anchor>" + record.getField(AssetField.Anchor_X) + "," + record.getField(AssetField.Anchor_Y) + "</Anchor>";
                    }
                    if (record.containsField(AssetField.ImageSet)) {
                        catalogOutput = catalogOutput + "<" + (Object)((Object)AssetField.ImageSet) + ">" + record.getField(AssetField.ImageSet) + "</" + (Object)((Object)AssetField.ImageSet) + ">";
                    }
                    if (record.containsField(AssetField.Path)) {
                        catalogOutput = catalogOutput + "<" + (Object)((Object)AssetField.Path) + ">" + record.getField(AssetField.Path) + "</" + (Object)((Object)AssetField.Path) + ">";
                    }
                    if (record.containsField(AssetField.Resolution)) {
                        catalogOutput = catalogOutput + "<" + (Object)((Object)AssetField.Resolution) + ">" + record.getField(AssetField.Resolution) + "</" + (Object)((Object)AssetField.Resolution) + ">";
                    }
                    if (record.containsField(AssetField.Width) && record.containsField(AssetField.Height)) {
                        catalogOutput = catalogOutput + "<Size>" + record.getField(AssetField.Width) + "," + record.getField(AssetField.Height) + "</Size>";
                    }
                    catalogOutput = catalogOutput + "</AssetAttributes>";
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Exception at catalog lookup: " + ex.getMessage());
            catalogOutput = catalogOutput + "<AssetAttributes/>";
        }
        out.println(catalogOutput);
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }
}

