/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.servlets;

import com.day.cq.dam.api.s7dam.config.S7damConfigResolver;
import com.day.cq.dam.s7dam.common.presets.S7damImagePresetsService;
import com.day.cq.dam.s7dam.onprem.catalog.CatalogCompanyRecord;
import com.day.cq.dam.s7dam.onprem.catalog.CatalogResolver;
import com.day.cq.dam.s7dam.onprem.catalog.CompanyField;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"dam/components/s7dam/s7damPage"}, methods={"GET", "POST"}, extensions={"xml"}, selectors={"s7catalog"})
public class S7damCompanyLookupServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(S7damCompanyLookupServlet.class);
    @Reference
    private S7damImagePresetsService presetsService;
    @Reference
    private S7damConfigResolver s7configResolver;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String companyOutput;
        PrintWriter out;
        block18: {
            response.setContentType("application/xml");
            response.setCharacterEncoding("utf-8");
            out = response.getWriter();
            companyOutput = "";
            String assetType = "IS";
            try {
                if (request.getResource().getPath() == null) break block18;
                String rootId = request.getResource().getParent().getName();
                String[] selectors = request.getRequestPathInfo().getSelectors();
                if (selectors.length > 1) {
                    assetType = selectors[1];
                }
                CatalogResolver resolver = new CatalogResolver();
                CatalogCompanyRecord record = resolver.getCompanyRecordFromJcrContent(request.getResource().getPath(), request, this.s7configResolver, this.presetsService);
                String lastModified = "";
                if (record.containsField(CompanyField.lastModified)) {
                    lastModified = " lastModified=\"" + record.getField(CompanyField.lastModified) + "\"";
                }
                companyOutput = "<CompanySettings xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" rootId=\"" + rootId + "\"" + lastModified + ">";
                if (record.containsField(CompanyField.AllowDirectAccess)) {
                    companyOutput = companyOutput + "<" + CompanyField.AllowDirectAccess.name() + " exclude=\"" + record.getField(CompanyField.AllowDirectAccess) + "\" types=\"" + assetType + "\"" + "/>";
                }
                if (record.containsField(CompanyField.BkgColor)) {
                    companyOutput = companyOutput + "<" + CompanyField.BkgColor.name() + ">" + record.getField(CompanyField.BkgColor) + "</" + CompanyField.BkgColor.name() + ">";
                }
                if (record.containsField(CompanyField.DefaultPix)) {
                    companyOutput = companyOutput + "<" + CompanyField.DefaultPix.name() + ">" + record.getField(CompanyField.DefaultPix) + "</" + CompanyField.DefaultPix.name() + ">";
                }
                if (record.containsField(CompanyField.DefaultThumbPix)) {
                    companyOutput = companyOutput + "<" + CompanyField.DefaultThumbPix.name() + ">" + record.getField(CompanyField.DefaultThumbPix) + "</" + CompanyField.DefaultThumbPix.name() + ">";
                }
                if (record.containsField(CompanyField.Expiration)) {
                    companyOutput = companyOutput + "<" + CompanyField.Expiration.name() + ">" + record.getField(CompanyField.Expiration) + "</" + CompanyField.Expiration.name() + ">";
                }
                if (record.containsField(CompanyField.JpegQuality)) {
                    companyOutput = companyOutput + "<" + CompanyField.JpegQuality.name() + " compression=\"" + record.getField(CompanyField.JpegQuality) + "\" downsampleChroma=\"" + record.getField(CompanyField.DownSampleChroma) + "\"/>";
                    companyOutput = companyOutput + "<Macros>";
                    if (record.getAllPresets().size() > 0) {
                        try {
                            Iterator<String> itr = record.getAllPresets().keySet().iterator();
                            while (itr.hasNext()) {
                                String name = itr.next().toString();
                                companyOutput = companyOutput + "<Macro ";
                                companyOutput = companyOutput + "name=\"" + name + "\" ";
                                companyOutput = companyOutput + "value=\"" + record.getPreset(name).replaceAll("&", "&amp;") + "\"";
                                companyOutput = companyOutput + "/>";
                            }
                        }
                        catch (Exception ex) {
                            LOG.error("Exception at Company ImageSet generation: " + ex.getMessage());
                        }
                    }
                    companyOutput = companyOutput + "</Macros>";
                }
                if (record.containsField(CompanyField.MaxPix)) {
                    companyOutput = companyOutput + "<" + CompanyField.MaxPix.name() + ">" + record.getField(CompanyField.MaxPix) + "</" + CompanyField.MaxPix.name() + ">";
                }
                if (record.containsField(CompanyField.ResMode)) {
                    companyOutput = companyOutput + "<" + CompanyField.ResMode.name() + ">" + record.getField(CompanyField.ResMode) + "</" + CompanyField.ResMode.name() + ">";
                }
                if (record.containsField(CompanyField.Resolution)) {
                    companyOutput = companyOutput + "<" + CompanyField.Resolution.name() + ">" + record.getField(CompanyField.Resolution) + "</" + CompanyField.Resolution.name() + ">";
                }
                if (record.getRootPath() != null) {
                    companyOutput = companyOutput + "<RootPath>" + record.getRootPath() + "</RootPath>";
                }
                companyOutput = companyOutput + "</CompanySettings>";
            }
            catch (Exception ex) {
                LOG.error("Exception at company setting response: " + ex.getMessage());
                companyOutput = "<CompanySettings/>";
            }
        }
        out.println(companyOutput);
    }

    protected void bindPresetsService(S7damImagePresetsService s7damImagePresetsService) {
        this.presetsService = s7damImagePresetsService;
    }

    protected void unbindPresetsService(S7damImagePresetsService s7damImagePresetsService) {
        if (this.presetsService == s7damImagePresetsService) {
            this.presetsService = null;
        }
    }

    protected void bindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        this.s7configResolver = s7damConfigResolver;
    }

    protected void unbindS7configResolver(S7damConfigResolver s7damConfigResolver) {
        if (this.s7configResolver == s7damConfigResolver) {
            this.s7configResolver = null;
        }
    }
}

