/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.sync.impl;

import com.day.cq.dam.api.s7dam.config.S7damConfig;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.s7dam.common.sync.S7damAssetSyncService;
import com.day.cq.dam.s7dam.hosted.model.S7damAssetUtils;
import com.day.cq.dam.s7dam.hosted.model.S7damFolderAssets;
import com.day.cq.dam.s7dam.onprem.platform.PlatformServerService;
import com.day.cq.dam.s7dam.onprem.util.OptimizedImageState;
import com.day.cq.dam.s7dam.onprem.util.OptimizedImageUtil;
import java.io.IOException;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service(value={S7damAssetSyncService.class})
public class S7damAssetSyncServiceImpl
implements S7damAssetSyncService {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Reference(policy=ReferencePolicy.STATIC)
    private ResourceResolverFactory resolverFactory;
    @Reference
    private PlatformServerService platformServerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String moveFolder(String dstPath, String srcPath, S7damConfig s7Config) {
        String result = "success";
        ResourceResolver resolver = this.getAdminResourceResolver();
        if (s7Config == null || !s7Config.isOnPrem() || resolver == null) {
            this.LOG.warn("Unable to moveFolder, invalid configuration");
            return "failed";
        }
        Node folderNode = (Node)resolver.getResource(dstPath).adaptTo(Node.class);
        List<S7damFolderAssets> folderAssetsList = S7damAssetUtils.getFolderAssetsList(folderNode, true);
        try {
            for (S7damFolderAssets folder : folderAssetsList) {
                for (String dstAssetPath : folder.getAssets()) {
                    String srcAssetpath = dstAssetPath.replaceFirst(dstPath, srcPath);
                    this.moveFile(dstAssetPath, srcAssetpath, s7Config, resolver);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error("Error in moveFolder" + e.getMessage());
            result = "failed";
        }
        finally {
            if (resolver != null && resolver.isLive()) {
                resolver.close();
            }
        }
        return result;
    }

    @Override
    public String deleteFolder(String srcPath, S7damConfig s7Config) {
        this.LOG.warn("invalidate deleted folder  operation not supported On-Premise");
        return "failed";
    }

    @Override
    public String moveFile(String dstPath, String srcPath, S7damConfig s7Config) {
        ResourceResolver resolver = this.getAdminResourceResolver();
        String status = this.moveFile(dstPath, srcPath, s7Config, resolver);
        if (resolver != null && resolver.isLive()) {
            resolver.close();
        }
        return status;
    }

    private String moveFile(String dstPath, String srcPath, S7damConfig s7Config, ResourceResolver resolver) {
        if ("failed".equals(this.invalidateCatalogCache(dstPath, resolver, s7Config))) {
            this.LOG.warn("moveFile - dstPath was not invalidated");
        }
        if ("failed".equals(this.invalidateCatalogCache(srcPath, resolver, s7Config))) {
            this.LOG.warn("moveFile - arcPath was not invalidated");
        }
        return "success";
    }

    @Override
    public String deleteFile(String srcPath, S7damConfig s7Config) {
        return this.invalidateCatalogCache(srcPath, null, s7Config);
    }

    @Override
    public String updateAsset(String path, S7damConfig s7Config) {
        ResourceResolver resolver = this.getAdminResourceResolver();
        String status = this.invalidateCatalogCache(path, resolver, s7Config);
        if (resolver != null && resolver.isLive()) {
            resolver.close();
        }
        return status;
    }

    private String invalidateCatalogCache(String srcPath, ResourceResolver resolver, S7damConfig s7Config) {
        if (StringUtils.isEmpty((String)srcPath)) {
            this.LOG.warn("srcPath is empty)");
        } else if (s7Config == null || !s7Config.isOnPrem()) {
            this.LOG.warn("invalidateCatalogCache - s7dam Cloud not defined");
        } else {
            try {
                this.platformServerService.invalidateAssetCache(srcPath, resolver, (S7damConfigOnPrem)s7Config);
                return "success";
            }
            catch (Exception e) {
                this.LOG.error("Error Invalidating server asset cache for [{}] {}", (Object)srcPath, (Object)e.getMessage());
            }
        }
        return "failed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updatePublishedAsset(String path, S7damConfig s7Config) {
        String status = "success";
        ResourceResolver resolver = this.getAdminResourceResolver();
        if (s7Config == null || !s7Config.isOnPrem() || path == null || resolver == null) {
            this.LOG.error("updatePublishedAsset: malformed arguments");
            return "failed";
        }
        try {
            OptimizedImageState optimizedState = OptimizedImageUtil.getOptimizedImageState((S7damConfigOnPrem)s7Config, resolver, path);
            if (OptimizedImageState.IMAGE_NOT_SAVED == optimizedState) {
                OptimizedImageUtil.writeOptimizedImage((S7damConfigOnPrem)s7Config, resolver, path);
            } else if (OptimizedImageState.NO_IMAGE == optimizedState) {
                this.LOG.warn("updatePublishedAsset: Optimized Ptiff Image was not found");
            } else if (OptimizedImageState.IMAGE_SAVED == optimizedState) {
                this.LOG.debug("Optimized Ptiff Image already exists");
            }
            this.invalidateCatalogCache(path, resolver, s7Config);
        }
        catch (RepositoryException e) {
            this.LOG.error("updatePublishedAsset: Unable to update write published, optimized image");
            status = "failed";
        }
        catch (IOException e) {
            this.LOG.error("updatePublishedAsset: Write Error Optimizing ptiff ");
            status = "failed";
        }
        finally {
            if (resolver != null && resolver.isLive()) {
                resolver.close();
            }
        }
        return status;
    }

    private ResourceResolver getAdminResourceResolver() {
        try {
            return this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            this.LOG.error("Failed to obtain administrative ResourceResolver [{}]", (Object)e.getMessage());
            return null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindPlatformServerService(PlatformServerService platformServerService) {
        this.platformServerService = platformServerService;
    }

    protected void unbindPlatformServerService(PlatformServerService platformServerService) {
        if (this.platformServerService == platformServerService) {
            this.platformServerService = null;
        }
    }
}

