/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.util;

import com.day.cq.dam.s7dam.onprem.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;

public class FileBinary
implements Binary {
    private File file;
    private RandomAccessFile randomAccessFile;

    public FileBinary(File file) {
        this.file = file;
    }

    public InputStream getStream() throws RepositoryException {
        try {
            return FileUtil.getFileInputStream(this.file.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RepositoryException("Could not open stream for '" + this.file.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    public int read(byte[] b, long position) throws IOException, RepositoryException {
        if (this.randomAccessFile == null) {
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
        }
        this.randomAccessFile.seek(position);
        int numBytesRead = 0;
        int totalBytesRead = 0;
        while ((numBytesRead = this.randomAccessFile.read(b, totalBytesRead, b.length - totalBytesRead)) != -1) {
            totalBytesRead += numBytesRead;
        }
        return totalBytesRead;
    }

    public long getSize() throws RepositoryException {
        return this.file.length();
    }

    public void dispose() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

