/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFile(String src, String dest) throws IOException {
        File file;
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(src));
            file = FileUtil.writeStreamToFile(inStream, dest);
        }
        catch (Throwable throwable) {
            FileUtil.closeStream(inStream);
            throw throwable;
        }
        FileUtil.closeStream(inStream);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeStreamToFile(InputStream inStream, String dest) throws IOException {
        BufferedOutputStream outStream = null;
        File fileCopy = null;
        try {
            fileCopy = new File(dest);
            File destDir = fileCopy.getParentFile();
            if (!destDir.isDirectory() && !destDir.mkdirs()) {
                throw new IOException("Failed to create directory '" + fileCopy.getParentFile().getAbsolutePath() + "'.");
            }
            outStream = new BufferedOutputStream(new FileOutputStream(fileCopy));
            FileUtil.copyStream(inStream, outStream);
        }
        catch (Throwable throwable) {
            FileUtil.closeStream(outStream);
            throw throwable;
        }
        FileUtil.closeStream(outStream);
        return fileCopy;
    }

    public static void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        byte[] buf = new byte[65536];
        int bytesRead = 0;
        while ((bytesRead = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, bytesRead);
        }
    }

    public static void closeStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean deleteFile(File file) {
        if (file != null) {
            return file.delete();
        }
        return true;
    }

    public static InputStream getFileInputStream(String file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file));
    }
}

