/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.util;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.s7dam.config.S7damConfigOnPrem;
import com.day.cq.dam.s7dam.onprem.util.FileUtil;
import com.day.cq.dam.s7dam.onprem.util.OptimizedImageState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizedImageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimizedImageUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeOptimizedImage(S7damConfigOnPrem scene7Config, ResourceResolver resolver, String assetPath) throws IOException, RepositoryException {
        Resource damAssetResource = resolver.getResource(assetPath);
        Asset asset = (Asset)damAssetResource.adaptTo(Asset.class);
        Node assetNode = (Node)damAssetResource.adaptTo(Node.class);
        String optimizedPath = OptimizedImageUtil.getOptimizedImagePath(assetNode);
        if (optimizedPath == null) {
            LOGGER.error("writeOptimizedImage: optimized path is not defined");
            return null;
        }
        if (asset == null) {
            LOGGER.error("writeOptimizedImage: asset not defined for [{}]", (Object)assetPath);
            return null;
        }
        Rendition ptiffRendition = asset.getRendition("Dynamic Media ptiff");
        if (ptiffRendition == null) {
            LOGGER.error("writeOptimizedImage: No ptiff rendition defined for [{}]", (Object)assetPath);
            return null;
        }
        File ptiff = new File(scene7Config.getImageServerMount(), optimizedPath);
        boolean savedPtiff = false;
        InputStream ptiffStream = null;
        try {
            ptiffStream = ptiffRendition.getStream();
            FileUtil.writeStreamToFile(ptiffStream, ptiff.getAbsolutePath());
            savedPtiff = true;
            LOGGER.debug("Optimized PTIFF written to [{}] for asset [{}]", (Object)ptiff.getAbsolutePath(), (Object)assetNode.getPath());
        }
        catch (IOException e) {
            LOGGER.debug("Failed to write Optimized PTIFF to for asset [{}]", (Object)assetPath);
        }
        finally {
            FileUtil.closeStream(ptiffStream);
        }
        if (savedPtiff) {
            return ptiff.getAbsolutePath();
        }
        return null;
    }

    public static OptimizedImageState getOptimizedImageState(S7damConfigOnPrem scene7Config, ResourceResolver resolver, String assetPath) throws IOException, RepositoryException {
        Resource damAssetResource = resolver.getResource(assetPath);
        Node assetNode = (Node)damAssetResource.adaptTo(Node.class);
        String optimizedPath = OptimizedImageUtil.getOptimizedImagePath(assetNode);
        if (optimizedPath == null) {
            return OptimizedImageState.NO_IMAGE;
        }
        File ptiff = new File(scene7Config.getImageServerMount(), optimizedPath);
        return ptiff.exists() ? OptimizedImageState.IMAGE_SAVED : OptimizedImageState.IMAGE_NOT_SAVED;
    }

    public static String getOptimizedImagePath(Node assetNode) {
        try {
            Node metaNode = assetNode.getNode("jcr:content");
            if (metaNode == null) {
                return null;
            }
            if (!metaNode.hasProperty("dam:s7damOnPremisePTiffPath")) {
                return null;
            }
            return metaNode.getProperty("dam:s7damOnPremisePTiffPath").getString();
        }
        catch (Exception e) {
            LOGGER.error("Exception getting optimized ptiff image path.", (Throwable)e);
            return null;
        }
    }
}

