/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.s7dam.onprem.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeExec {
    public static final int TIMEOUT = -100;
    public static final int IO_EXCEPTION = -101;
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeExec.class);
    private static final long THREAD_TIMEOUT = 30000L;
    private static final long THREAD_POLL_INTERVAL = 60000L;
    private static Runtime runtime = Runtime.getRuntime();
    private static String version = null;
    private static String versionRegEx = null;
    private static TimerThread timer = new TimerThread();

    public static int execute(String[] command, String[] env, String workdirStr, boolean timeout) {
        return RuntimeExec.execute(command, env, workdirStr, timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int execute(String[] command, String[] env, String workdirStr, boolean timeout, boolean logStandardOutput) {
        Process process = null;
        try {
            LOGGER.debug("RuntimeExec.execute: ");
            for (String element : command) {
                LOGGER.debug("    " + element);
            }
            File workdir = workdirStr != null ? new File(workdirStr) : null;
            process = runtime.exec(command, env, workdir);
            int n = RuntimeExec.wait(process, timeout, logStandardOutput);
            RuntimeExec.destroy(process);
            return n;
        }
        catch (InterruptedException e) {
            RuntimeExec.handleInterrupt(process, command[0]);
            int n = RuntimeExec.interruptedError();
            return n;
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.toString());
            int n = -101;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            RuntimeExec.destroy(process);
        }
    }

    private static void destroy(Process process) {
        if (process != null) {
            process.destroy();
        }
    }

    public static String version(String[] command, String[] env, String workdirStr) {
        return RuntimeExec.version(command, env, workdirStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String version(String[] command, String[] env, String workdirStr, String regEx) {
        String string;
        Process process = null;
        try {
            File workdir = workdirStr != null ? new File(workdirStr) : null;
            process = runtime.exec(command, env, workdir);
            versionRegEx = regEx;
            string = RuntimeExec.getVersion(process);
        }
        catch (InterruptedException e) {
            RuntimeExec.handleInterrupt(process, command[0]);
            String string2 = null;
            RuntimeExec.destroy(process);
            return string2;
        }
        catch (IOException ioe) {
            LOGGER.error(ioe.toString());
            String string3 = null;
            {
                catch (Throwable throwable) {
                    RuntimeExec.destroy(process);
                    throw throwable;
                }
            }
            RuntimeExec.destroy(process);
            return string3;
        }
        RuntimeExec.destroy(process);
        return string;
    }

    private static String getVersion(Process process) throws InterruptedException {
        RuntimeExec.wait(process, true, true, true);
        return version;
    }

    private static int wait(Process process, boolean timeout, boolean logStandardOutput) throws InterruptedException {
        return RuntimeExec.wait(process, timeout, logStandardOutput, false);
    }

    private static int wait(Process process, boolean timeout, boolean logStandardOutput, boolean storeVersion) throws InterruptedException {
        ReportThread inThread = new ReportThread(process, false, logStandardOutput, storeVersion);
        ReportThread errThread = new ReportThread(process, true, true, false);
        inThread.start();
        errThread.start();
        if (storeVersion && versionRegEx != null) {
            inThread.setVersionRegEx(versionRegEx);
        }
        if (timeout) {
            RuntimeExec.timer.trackProcess(process, Thread.currentThread());
        }
        int iRetVal = process.waitFor();
        if (timeout) {
            RuntimeExec.timer.removeProcess(process);
        }
        LOGGER.debug("RuntimeExec.execute: waitFor() returned " + iRetVal);
        if (iRetVal == 0) {
            iRetVal = process.exitValue();
            LOGGER.debug("RuntimeExec.execute: process returned " + iRetVal);
        }
        inThread.join();
        errThread.join();
        if (storeVersion) {
            version = inThread.getVersion();
        }
        return iRetVal;
    }

    private static void handleInterrupt(Process process, String processName) {
        RuntimeExec.destroy(process);
        Thread.interrupted();
        LOGGER.warn("RuntimeExec, process [" + processName + "] timed-out and was destroyed.");
    }

    public static int interruptedError() {
        return -100;
    }

    static {
        timer.start();
    }

    private static class ReportThread
    extends Thread {
        private static final String VERSION_REGEX = "[\\d\\.]+?";
        private final Process process;
        private final boolean errStream;
        private final boolean logMessages;
        private final boolean trackVersion;
        private String version;
        private String versionRegEx;

        private ReportThread(Process p, boolean errStream, boolean logMessages, boolean trackVersion) {
            this.process = p;
            this.errStream = errStream;
            this.logMessages = logMessages;
            this.trackVersion = trackVersion;
            this.version = null;
            this.versionRegEx = VERSION_REGEX;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader stream = this.errStream ? new BufferedReader(new InputStreamReader(this.process.getErrorStream())) : new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            try {
                String line;
                while ((line = stream.readLine()) != null) {
                    if (this.trackVersion) {
                        if (this.errStream || !this.validVersion(line.trim())) continue;
                        this.version = line.trim();
                        continue;
                    }
                    if (!this.logMessages) continue;
                    if (this.errStream) {
                        LOGGER.warn(line);
                        continue;
                    }
                    LOGGER.info(line);
                }
            }
            catch (IOException e) {
                LOGGER.error("RuntimeExec error reading stream", (Throwable)e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }

        public boolean validVersion(String str) {
            if (str == null || str.length() == 0) {
                return false;
            }
            if (this.versionRegEx == null || this.versionRegEx.length() == 0) {
                return false;
            }
            return str.matches(this.versionRegEx);
        }

        public String getVersion() {
            return this.version;
        }

        public String getVersionRegEx() {
            return this.versionRegEx;
        }

        public void setVersionRegEx(String regEx) {
            this.versionRegEx = regEx;
        }
    }

    private static class TimerThread
    extends Thread {
        private final Map<Process, ProcessInfo> ptable = Collections.synchronizedMap(new HashMap());
        private final long timeout;

        private TimerThread() {
            this.timeout = 30000L;
        }

        private void trackProcess(Process p, Thread processThread) {
            long time = System.currentTimeMillis();
            LOGGER.debug("RuntimeExec, tracking process " + p + " at time: " + time);
            this.ptable.put(p, new ProcessInfo(processThread, time));
        }

        private void removeProcess(Process process) {
            this.ptable.remove(process);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            checkInterval = 60000L;
            try {
                block7: while (true) {
                    Thread.sleep(checkInterval);
                    currTime = System.currentTimeMillis();
                    i$ = this.ptable.keySet().iterator();
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        if (!i$.hasNext()) continue block7;
                        process = i$.next();
                        info = this.ptable.get(process);
                        if (currTime - ProcessInfo.access$500(info) < this.timeout) continue;
                        try {
                            process.exitValue();
                        }
                        catch (IllegalThreadStateException ex) {
                            RuntimeExec.access$300().warn("RuntimeExec, process " + process + " timed-out at " + currTime + ", interrupting thread. Process start time: " + ProcessInfo.access$500(info) + ". Timeout limit: " + this.timeout);
                            ProcessInfo.access$600(info).interrupt();
                        }
                        finally {
                            this.ptable.remove(process);
                            continue;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                RuntimeExec.access$300().warn("RuntimeExec polling thread interrupted", (Throwable)e);
                return;
            }
            ** GOTO lbl-1000
        }

        private static class ProcessInfo {
            private final Thread thread;
            private final long startTime;

            private ProcessInfo(Thread th, long time) {
                this.thread = th;
                this.startTime = time;
            }

            static /* synthetic */ long access$500(ProcessInfo x0) {
                return x0.startTime;
            }

            static /* synthetic */ Thread access$600(ProcessInfo x0) {
                return x0.thread;
            }
        }
    }
}

