/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import com.day.cq.dam.scene7.api.Scene7Publisher;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.impl.JobLogNotAvailableException;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingJob
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_POLLING_ATTEMPTS = 120;
    private static final String IMAGE_SERVING_PUBLISH_JOB = "imageServingPublishJob";
    protected S7Config s7Config;
    protected String path;
    protected long timestamp;
    protected long publishStartTimestamp;
    protected String name;
    protected Scene7Publisher publisher;
    protected State state;
    protected Map<String, String> statusPublishQueryMap;
    protected ResourceResolver resolver;
    protected QueryBuilder queryBuilder;
    protected Scene7Service scene7Service;
    protected Scene7EndpointsManager scene7EndpointsManager;
    protected boolean shouldRepublish = false;
    protected String scene7JobName;
    protected int attempts = 0;

    public PublishingJob(Scene7Publisher publisher, S7Config s7Config, String path, Map<String, String> statusPublishQueryMap, ResourceResolver resolver, QueryBuilder queryBuilder, Scene7Service scene7Service, Scene7EndpointsManager scene7EndpointsManager) {
        this.publisher = publisher;
        this.path = path;
        this.timestamp = System.currentTimeMillis();
        this.statusPublishQueryMap = statusPublishQueryMap;
        this.resolver = resolver;
        this.queryBuilder = queryBuilder;
        this.s7Config = s7Config;
        this.scene7Service = scene7Service;
        this.scene7EndpointsManager = scene7EndpointsManager;
        this.name = "scene7 publishing job " + this.s7Config.getEmail() + " " + this.timestamp;
    }

    public void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void run() {
        try {
            if (this.state == State.QUEUED) {
                if (this.publisher.isPublishJobActive(IMAGE_SERVING_PUBLISH_JOB, this.s7Config)) {
                    return;
                }
                this.state = State.PUBLISHING;
                this.shouldRepublish = false;
                this.log.debug("Do image publish for email '" + this.s7Config.getEmail() + "' and company '" + this.s7Config.getCompanyHandle() + "' to '" + this.scene7EndpointsManager.getAPIServer(this.s7Config.getRegion()) + "'");
                this.scene7JobName = this.publisher.startPublishJob(this.path, this.s7Config);
                if (this.scene7JobName == null) {
                    this.log.warn("starting Publish Job failed");
                    this.state = State.FAILED;
                    this.updatePublishStatus(this.statusPublishQueryMap, this.resolver, this.publishStartTimestamp, "UploadFailed");
                    this.publisher.removeJob(this.name);
                } else {
                    this.publishStartTimestamp = System.currentTimeMillis();
                }
            } else if (this.state == State.PUBLISHING && this.scene7JobName != null) {
                ++this.attempts;
                if (!this.scene7Service.isJobActiveByOriginalName(this.scene7JobName, this.s7Config)) {
                    Boolean publishSucceeded = this.publisher.isPublishJobSuccessByOrignalName(this.scene7JobName, this.s7Config);
                    String publishState = publishSucceeded != false ? "PublishComplete" : "UploadFailed";
                    this.updatePublishStatus(this.statusPublishQueryMap, this.resolver, this.publishStartTimestamp, publishState);
                    if (this.shouldRepublish) {
                        this.state = State.QUEUED;
                        this.attempts = 0;
                    } else {
                        this.state = State.PUBLISHED;
                        this.publisher.removeJob(this.name);
                    }
                } else if (this.attempts > 120) {
                    this.log.warn("publish job failed to finish successful for handle " + this.scene7JobName);
                    this.state = State.FAILED;
                    this.publisher.removeJob(this.name);
                }
            }
        }
        catch (JobLogNotAvailableException e) {
            this.log.debug(e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Error while publishing", (Throwable)e);
        }
    }

    protected void updatePublishStatus(Map<String, String> statusPublishQueryMap, ResourceResolver resolver, long publishTime, String state) {
        try {
            if (statusPublishQueryMap.isEmpty() || resolver == null || !"PublishStart".equals(state) && !"PublishComplete".equals(state)) {
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>(statusPublishQueryMap);
            map.put("path", "/content/dam");
            map.put("daterange.property", "dam:scene7UploadTimeStamp");
            map.put("daterange.upperBound", Long.toString(publishTime));
            map.put("3_property", "dam:scene7FileStatus");
            map.put("3_property.value", "PublishQueued");
            Session session = (Session)resolver.adaptTo(Session.class);
            Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
            query.setHitsPerPage(0L);
            query.setStart(0L);
            SearchResult result = query.getResult();
            this.log.debug("asset publish pending matches ", (Object)result.getTotalMatches());
            for (Hit hit : result.getHits()) {
                String path = "";
                try {
                    path = hit.getPath();
                    Node jcrContent = (Node)resolver.getResource(path).adaptTo(Node.class);
                    jcrContent.setProperty("dam:scene7FileStatus", state);
                    jcrContent.getSession().save();
                    this.log.debug("Publish Scene7 file status to " + state + " for path " + path);
                }
                catch (Exception e) {
                    this.log.error("Exception when updating state to " + state + " s7 file status to path " + path, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error("update Publish Status failed ", (Object)e.getMessage());
        }
    }

    public boolean equals(PublishingJob other) {
        return other.s7Config.getCompanyHandle().equals(this.s7Config.getCompanyHandle()) && other.scene7EndpointsManager.getAPIServer(other.s7Config.getRegion()).equals(this.scene7EndpointsManager.getAPIServer(this.s7Config.getRegion()));
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setShouldRepublish(boolean shouldRepublish) {
        this.log.debug("Publish job setShouldRepublish ", (Object)shouldRepublish);
        this.shouldRepublish = shouldRepublish;
    }

    public static enum State {
        QUEUED,
        PUBLISHING,
        PUBLISHED,
        FAILED;

    }
}

