/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.impl.model.S7ConfigImpl;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.InvalidObjectException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
@Properties(value={@Property(name="service.description", value={"Default adapter factory for Scene7 configurations"})})
public class S7ConfigAdapterFactory
implements AdapterFactory {
    private static final Class<Resource> RESOURCE_CLASS = Resource.class;
    private static final Class<S7Config> S7CONFIG_CLASS = S7Config.class;
    @Property(name="adapters")
    static final String[] ADAPTERS = new String[]{S7CONFIG_CLASS.getName()};
    @Property(name="adaptables")
    static final String[] ADAPTABLES = new String[]{RESOURCE_CLASS.getName()};
    @Reference
    private ConfigurationManager configurationManager;
    private static final Logger LOG = LoggerFactory.getLogger(S7ConfigAdapterFactory.class);

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        S7ConfigImpl adapter = null;
        if (adaptable instanceof Resource) {
            Resource resource = (Resource)adaptable;
            if (type == S7Config.class) {
                Configuration configuration = this.configurationManager.getConfiguration(resource.getPath());
                try {
                    adapter = new S7ConfigImpl(configuration);
                }
                catch (InvalidObjectException e) {
                    LOG.error("Cannot create a valid S7Config object", (Throwable)e);
                }
            } else {
                LOG.warn("Cannot handle adapter {}", (Object)type.getName());
            }
        } else {
            LOG.warn("Cannot handle adaptable {}", (Object)adaptable.getClass().getName());
        }
        return (AdapterType)adapter;
    }

    protected void bindConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    protected void unbindConfigurationManager(ConfigurationManager configurationManager) {
        if (this.configurationManager == configurationManager) {
            this.configurationManager = null;
        }
    }
}

