/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.impl.model.S7ConfigImpl;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.scene7.service.name", description="%cq.scene7.service.description")
@Service
public class S7ConfigResolverImpl
implements S7ConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(S7ConfigResolverImpl.class);
    @Reference
    private ConfigurationManager cfgManager;
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public S7Config getS7Config(String email, String password, String userRegion) {
        S7ConfigImpl s7Config = null;
        try {
            if (!this.cryptoSupport.isProtected(password)) {
                password = this.cryptoSupport.protect(password);
            }
            Iterator cfgIterator = this.cfgManager.getConfigurations("/etc/cloudservices/scene7");
            while (cfgIterator.hasNext()) {
                Configuration configuration = (Configuration)cfgIterator.next();
                if (configuration == null) continue;
                InheritanceValueMap configProp = configuration.getProperties();
                String _email = (String)configProp.get("email", String.class);
                String _password = (String)configProp.get("password", String.class);
                String _region = (String)configProp.get("region", String.class);
                if (_email == null || !_email.equals(email) || _password == null || !_password.equals(password) || _region == null || !_region.equals(userRegion)) continue;
                s7Config = new S7ConfigImpl(configuration);
                break;
            }
            if (s7Config == null) {
                s7Config = new S7ConfigImpl(email, password, userRegion);
            }
        }
        catch (InvalidObjectException e) {
            LOG.error("Error obtaining a valid S7Config object", (Throwable)e);
        }
        catch (CryptoException e) {
            LOG.error("Error encrypting password", (Throwable)e);
        }
        return s7Config;
    }

    @Override
    public S7Config getS7Config(String configPath) {
        S7ConfigImpl s7Config = null;
        if (configPath != null) {
            Configuration cfg = this.cfgManager.getConfiguration(configPath);
            if (cfg == null) {
                return null;
            }
            try {
                s7Config = new S7ConfigImpl(cfg);
            }
            catch (InvalidObjectException e) {
                LOG.error("Invalid S7Config object due to invalid constructor parameters", (Throwable)e);
            }
        }
        return s7Config;
    }

    @Override
    public List<S7Config> getS7Configurations(String configRootPath) {
        ArrayList<S7Config> s7Configurations = new ArrayList<S7Config>();
        if (StringUtils.isNotEmpty((String)configRootPath)) {
            Iterator cfgIterator = this.cfgManager.getConfigurations(configRootPath);
            while (cfgIterator.hasNext()) {
                Configuration cfg = (Configuration)cfgIterator.next();
                try {
                    S7ConfigImpl s7Config = new S7ConfigImpl(cfg);
                    s7Configurations.add(s7Config);
                }
                catch (InvalidObjectException e) {
                    LOG.error("Invalid S7Config object due to invalid constructor parameters", (Throwable)e);
                }
            }
        }
        return s7Configurations;
    }

    @Override
    public S7Config getSharedS7Config(S7Config s7Config) {
        try {
            Configuration cfg = this.cfgManager.getConfiguration(s7Config.getCloudConfigPath());
            S7ConfigImpl ret = new S7ConfigImpl(cfg, true);
            return ret;
        }
        catch (Exception e) {
            LOG.error("Invalid S7Config object due to invalid constructor parameters", (Throwable)e);
            return null;
        }
    }

    @Override
    public S7Config getS7ConfigForResource(Resource resource) {
        S7Config s7Config = null;
        if (resource != null) {
            Resource s7ConfigResource;
            String scene7ConfigurationPath = null;
            while (scene7ConfigurationPath == null) {
                ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
                if (properties != null) {
                    scene7ConfigurationPath = (String)properties.get("dam:scene7CloudConfigPath", String.class);
                    if (scene7ConfigurationPath == null && ((scene7ConfigurationPath = this.getConfigFromMetaData(resource)) != null || (resource = resource.getParent()) != null)) continue;
                    break;
                }
                LOG.error("Cannot obtain the ValueMap for resource " + resource.getPath());
                break;
            }
            if (scene7ConfigurationPath != null && (s7ConfigResource = resource.getResourceResolver().getResource(scene7ConfigurationPath)) != null) {
                s7Config = (S7Config)s7ConfigResource.adaptTo(S7Config.class);
            }
        }
        return s7Config;
    }

    private String getConfigFromMetaData(Resource resource) {
        Resource metaData;
        String scene7ConfigurationPath = null;
        Asset asset = (Asset)resource.adaptTo(Asset.class);
        if (asset != null && (metaData = resource.getChild("jcr:content/metadata")) != null) {
            scene7ConfigurationPath = (String)((ValueMap)metaData.adaptTo(ValueMap.class)).get("dam:scene7CloudConfigPath", String.class);
        }
        return scene7ConfigurationPath;
    }

    protected void bindCfgManager(ConfigurationManager configurationManager) {
        this.cfgManager = configurationManager;
    }

    protected void unbindCfgManager(ConfigurationManager configurationManager) {
        if (this.cfgManager == configurationManager) {
            this.cfgManager = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

