/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.api.model.Scene7AssetImpl;
import com.day.cq.dam.scene7.impl.utils.DOMUtils;
import com.day.cq.dam.scene7.impl.utils.Scene7AssetUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Scene7AssetFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scene7AssetFactory.class);
    private static final String TRASH_STATE = "InTrash";

    public List<Scene7Asset> parseAssets(Document document) {
        ArrayList<Scene7Asset> assetList = new ArrayList<Scene7Asset>();
        LOGGER.debug("Creating Scene7Asset List from Document object...");
        if (document != null) {
            NodeList assetItems = document.getElementsByTagName("items");
            LOGGER.debug("Found {} assets!", (Object)assetItems.getLength());
            for (int i = 0; i < assetItems.getLength(); ++i) {
                Scene7Asset asset;
                Element itemAssetElement = (Element)assetItems.item(i);
                String assetHandle = DOMUtils.getNodeValue(itemAssetElement, "assetHandle");
                if (StringUtils.isEmpty((String)assetHandle) || (asset = this.parseAsset(itemAssetElement)) == null) continue;
                assetList.add(asset);
            }
            LOGGER.debug("Successfully parsed {} Scene7Assets.", (Object)assetList.size());
        }
        return assetList;
    }

    public Scene7Asset parseAsset(Element element) {
        Scene7Asset newScene7Asset = null;
        String trashState = DOMUtils.getNodeValue(element, "trashState");
        if (!TRASH_STATE.equalsIgnoreCase(trashState)) {
            String assetTypeString = DOMUtils.getNodeValue(element, "type");
            String subType = DOMUtils.getNodeValue(element, "subType");
            if (StringUtils.isNotEmpty((String)subType)) {
                assetTypeString = subType;
            }
            LOGGER.debug("Found {} asset type!", (Object)assetTypeString);
            Scene7AssetType assetType = Scene7AssetType.toScene7AssetType(assetTypeString);
            newScene7Asset = this.createAsset(element, assetType, assetTypeString);
            if (newScene7Asset == null) {
                LOGGER.error("Could not parse a Scene7Asset from Item node content: {}", (Object)element.getTextContent());
            }
        }
        return newScene7Asset;
    }

    private Scene7Asset createAsset(Element element, Scene7AssetType assetType, String assetTypeString) {
        HashMap<Object, Object> scene7AssetPropertyMap = new HashMap<Object, Object>();
        Map<String, String> assetProperties = this.retrieveMetadataInformation(element);
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.SCENE7_ASSET_TYPE, (Object)assetType);
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.ASSET_TYPE_STRING, assetTypeString);
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.NAME, DOMUtils.getNodeValue(element, "name"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.ASSET_HANDLE, DOMUtils.getNodeValue(element, "assetHandle"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.FILE_NAME, DOMUtils.getNodeValue(element, "fileName"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.FOLDER, DOMUtils.getNodeValue(element, "folder"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.FOLDER_HANDLE, DOMUtils.getNodeValue(element, "folderHandle"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.CREATED_BY, DOMUtils.getNodeValue(element, "createUser"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.MODIFIED_BY, DOMUtils.getNodeValue(element, "lastModifyUser"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.CREATED_DATE, DOMUtils.getDateNodeValue(element, "created", "yyyy-MM-dd'T'HH:mm:ss.SSS"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.MODIFIED_DATE, DOMUtils.getDateNodeValue(element, "lastModified", "yyyy-MM-dd'T'HH:mm:ss.SSS"));
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.READY_TO_PUBLISH, DOMUtils.getNodeValue(element, "readyForPublish"));
        Scene7AssetImpl asset = null;
        switch (assetType) {
            case FLASH: {
                LOGGER.debug("Found a Flash Scene7 Asset");
                assetProperties.putAll(this.retrieveAssetInfo(element, "flashInfo"));
                break;
            }
            case TEMPLATE: {
                LOGGER.debug("Found a Template Scene7 Asset");
                assetProperties.putAll(this.retrieveAssetInfo(element, "templateInfo"));
                break;
            }
            case IMAGE: {
                LOGGER.debug("Found an Image Scene7 Asset");
                Map<String, String> imageAssetInfo = this.retrieveAssetInfo(element, "imageInfo");
                assetProperties.putAll(imageAssetInfo);
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.WIDTH, Scene7AssetUtils.parseLong(assetProperties.get("width")));
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.HEIGHT, Scene7AssetUtils.parseLong(assetProperties.get("height")));
                break;
            }
            case VIEWER_PRESET: {
                LOGGER.debug("Found Viewer Preset Scene7 Asset");
                assetProperties.putAll(this.retrieveAssetInfo(element, "viewerPresetInfo"));
                Map<String, String> viewerPresetConfigurationSettings = this.retrieveViewerPresetInformation(element);
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.VIEWER_PRESET_CONFIGURATION_SETTINGS, viewerPresetConfigurationSettings);
                break;
            }
            case VIDEO: {
                LOGGER.debug("Found a Video Scene7 Asset");
                Map<String, String> videoAssetInfo = this.retrieveAssetInfo(element, "videoInfo");
                assetProperties.putAll(videoAssetInfo);
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.WIDTH, Scene7AssetUtils.parseLong(assetProperties.get("Video Width")));
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.HEIGHT, Scene7AssetUtils.parseLong(assetProperties.get("Video Height")));
                Map<String, String> attributeInfoMap = this.retrieveAttributeInformation((Element)element.getParentNode());
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.VIDEO_ENCODING_PRESET_ID, attributeInfoMap.get("encoding.preset.id"));
                break;
            }
            case MASTER_VIDEO: {
                LOGGER.debug("Found a Master Video Scene7 Asset");
                Map<String, String> masterVideoAssetInfo = this.retrieveAssetInfo(element, "masterVideoInfo");
                assetProperties.putAll(masterVideoAssetInfo);
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.WIDTH, Scene7AssetUtils.parseLong(assetProperties.get("Video Width")));
                scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.HEIGHT, Scene7AssetUtils.parseLong(assetProperties.get("Video Height")));
                break;
            }
        }
        scene7AssetPropertyMap.put((Object)Scene7AssetImpl.Scene7AssetProperty.ASSET_PROPERTIES, assetProperties);
        LOGGER.debug("Creating a Scene7 Asset [assetTypeString={}]", (Object)assetTypeString);
        asset = new Scene7AssetImpl(scene7AssetPropertyMap);
        return asset;
    }

    public Scene7Asset parseSubAssets(Scene7Asset asset, Document associatedAssetsDocument) {
        NodeList getAssociatedAssetsRootNodes;
        Element associatedAssetsRootElement = null;
        if (associatedAssetsDocument != null && (getAssociatedAssetsRootNodes = associatedAssetsDocument.getElementsByTagName("getAssociatedAssetsReturn")).getLength() > 0) {
            associatedAssetsRootElement = (Element)getAssociatedAssetsRootNodes.item(0);
        }
        if (asset != null && associatedAssetsRootElement != null) {
            NodeList memberArrayNodes = DOMUtils.getChildNodes(associatedAssetsRootElement, "memberArray/items");
            NodeList generatedArrayNodes = DOMUtils.getChildNodes(associatedAssetsRootElement, "generatedArray/items/generated");
            List<Scene7Asset> subAssets = this.parseAssetsFromNodes(memberArrayNodes);
            subAssets.addAll(this.parseAssetsFromNodes(generatedArrayNodes));
            for (Scene7Asset subAsset : subAssets) {
                asset.addSubAsset(subAsset);
            }
            NodeList originatorNodes = associatedAssetsDocument.getElementsByTagName("originator");
            if (originatorNodes.getLength() > 0) {
                Element originatorElement = (Element)originatorNodes.item(0);
                Scene7Asset originatorAsset = this.parseAsset(originatorElement);
                asset.updateOriginatorAsset(originatorAsset);
            }
            LOGGER.debug("Sub-asset parsing report: found total {} sub-assets and generator[assetHandle={}] for assetHandle={}!", new Object[]{asset.getSubAssets().size(), asset.getOriginatorAsset() != null ? asset.getOriginatorAsset().getAssetHandle() : "none", asset.getAssetHandle()});
        }
        return asset;
    }

    private List<Scene7Asset> parseAssetsFromNodes(NodeList nodes) {
        ArrayList<Scene7Asset> assets = new ArrayList<Scene7Asset>();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element nodeElement = (Element)nodes.item(i);
                Scene7Asset parsedAsset = this.parseAsset(nodeElement);
                if (parsedAsset == null) continue;
                assets.add(parsedAsset);
            }
        }
        return assets;
    }

    private Map<String, String> retrieveViewerPresetInformation(Element element) {
        HashMap<String, String> configurationSettings = new HashMap<String, String>();
        if (element != null) {
            Element configSettingArray = (Element)element.getElementsByTagName("configSettingArray").item(0);
            configurationSettings.putAll(this.parseNameValueItems(configSettingArray));
        }
        return configurationSettings;
    }

    private Map<String, String> retrieveMetadataInformation(Element element) {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        if (element != null) {
            Element metadataInformation = (Element)element.getElementsByTagName("metadataArray").item(0);
            metadataMap.putAll(this.parseNameValueItems(metadataInformation));
        }
        return metadataMap;
    }

    private Map<String, String> retrieveAttributeInformation(Element element) {
        HashMap<String, String> attributeArrayMap = new HashMap<String, String>();
        if (element != null) {
            Element metadataInformation = (Element)element.getElementsByTagName("attributeArray").item(0);
            attributeArrayMap.putAll(this.parseNameValueItems(metadataInformation));
        }
        return attributeArrayMap;
    }

    private Map<String, String> parseNameValueItems(Element nameValueItemsRoot) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (nameValueItemsRoot != null) {
            NodeList configSettingsItems = nameValueItemsRoot.getElementsByTagName("items");
            for (int i = 0; i < configSettingsItems.getLength(); ++i) {
                Element configSettingElement = (Element)configSettingsItems.item(i);
                String name = DOMUtils.getNodeValue(configSettingElement, "name");
                String value = DOMUtils.getNodeValue(configSettingElement, "value");
                if (StringUtils.isEmpty((String)value)) {
                    value = DOMUtils.getNodeValue(configSettingElement, "handle");
                }
                valuesMap.put(name, value);
            }
        }
        return valuesMap;
    }

    private Map<String, String> retrieveAssetInfo(Element element, String assetInfoTag) {
        Element assetInfoRoot;
        HashMap<String, String> assetInfo = new HashMap<String, String>();
        if (element != null && StringUtils.isNotEmpty((String)assetInfoTag) && (assetInfoRoot = (Element)element.getElementsByTagName(assetInfoTag).item(0)) != null) {
            NodeList infoList = assetInfoRoot.getChildNodes();
            for (int i = 0; i < infoList.getLength(); ++i) {
                Node infoNode = infoList.item(i);
                if (infoNode.getNodeType() == 3) continue;
                Element infoElement = (Element)infoNode;
                String key = infoElement.getTagName();
                String value = DOMUtils.getNodeValue(assetInfoRoot, key);
                assetInfo.put(key, value);
            }
        }
        return assetInfo;
    }
}

