/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.Scene7AssetMimetypeService;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import java.util.Dictionary;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.dam.scene7.assetmimetypeservice.name", description="%cq.dam.scene7.assetmimetypeservice.description")
@Service
@Properties(value={@Property(name="cq.dam.scene7.assetmimetypeservice.mapping", value={"Generic=image/s7asset", "Template=image/s7template", "Flash=image/s7flashtemplate", "Image=image/jpeg", "Video=video/*", "Video.mp4=video/mp4", "Video.f4v=video/mp4", "Video.flv=video/x-flv"}, label="%cq.dam.scene7.assetmimetypeservice.mapping.label", description="%cq.dam.scene7.assetmimetypeservice.mapping.description", unbounded=PropertyUnbounded.ARRAY)})
public class Scene7AssetMimeTypeServiceImpl
implements Scene7AssetMimetypeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scene7AssetMimeTypeServiceImpl.class);
    private String[] mappingArray;
    private HashMap<String, String> mappings;

    @Override
    public String getMimeTypeForAsset(Asset asset) {
        String assetTypeString;
        String mimeType = null;
        if (asset != null && StringUtils.isNotEmpty((String)(assetTypeString = asset.getMetadataValue("dam:scene7Type")))) {
            Scene7AssetType assetType = Scene7AssetType.toScene7AssetType(assetTypeString);
            String extension = FilenameUtils.getExtension((String)asset.getPath());
            mimeType = this.getMimeTypeForAssetType(assetType, extension);
        }
        return mimeType;
    }

    @Override
    public String getMimeTypeForAssetType(Scene7AssetType assetType, String extension) {
        String mimeType = null;
        if (assetType != null) {
            String key = assetType.getValue();
            if (StringUtils.isNotEmpty((String)extension)) {
                mimeType = this.mappings.get(key + "." + extension);
            }
            if (mimeType == null) {
                mimeType = this.mappings.get(key);
            }
        }
        return mimeType;
    }

    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.mappingArray = OsgiUtil.toStringArray(properties.get("cq.dam.scene7.assetmimetypeservice.mapping"), (String[])SCR_PROP_DEFAULT_ASSET_MIMETYPES);
        this.mappings = new HashMap(this.mappingArray.length);
        for (int i = 0; i < this.mappingArray.length; ++i) {
            String[] keyValue = this.mappingArray[i].split("=");
            try {
                String key = keyValue[0];
                String value = keyValue[1];
                this.mappings.put(key, value);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.error("Invalid format for asset - MIME type mapping: " + this.mappingArray[i]);
            }
        }
    }
}

