/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7PresetsService;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.impl.importer.ImportJobUtils;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.JobUtil;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scene7ConfigurationEventHandler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ConfigurationEventHandler.class);
    private String path;
    private ResourceResolverFactory rrf;
    private S7ConfigResolver s7ConfigResolver;
    private Scene7Service scene7Service;
    private Scene7PresetsService scene7PresetService;
    private JobManager slingJobManager;

    public Scene7ConfigurationEventHandler(String path, ResourceResolverFactory rrf, S7ConfigResolver s7ConfigResolver, Scene7Service scene7Service, Scene7PresetsService scene7PresetService, JobManager slingJobManager) {
        this.path = path;
        this.rrf = rrf;
        this.s7ConfigResolver = s7ConfigResolver;
        this.scene7Service = scene7Service;
        this.scene7PresetService = scene7PresetService;
        this.slingJobManager = slingJobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            ResourceResolver rr = null;
            try {
                String s7ConfigPath;
                S7Config s7Config;
                PersistableValueMap properties;
                rr = this.rrf.getAdministrativeResourceResolver(null);
                Resource configResourceJcrContent = rr.getResource(this.path);
                if (configResourceJcrContent == null || (properties = (PersistableValueMap)configResourceJcrContent.adaptTo(PersistableValueMap.class)) == null || properties.get((Object)"companyHandle") == null || (s7Config = this.s7ConfigResolver.getS7Config(s7ConfigPath = ResourceUtil.getParent((String)this.path))) == null) break block9;
                this.createTargetFolder(rr, s7ConfigPath, s7Config);
                this.cacheServersURLs(properties, s7ConfigPath, s7Config);
                String topicHash = Text.md5((String)s7Config.getTargetPath());
                boolean createConfig = this.generateImportQueueHandleIfNotExists(properties, s7ConfigPath, topicHash);
                try {
                    properties.save();
                    LOG.info("Detected Scene7 configuration changes. Caching settings.");
                }
                catch (PersistenceException e) {
                    LOG.error("Unable to persist configuration changes", (Throwable)e);
                }
                if (createConfig) {
                    this.createImportQueueConfig(rr, s7Config, topicHash);
                }
                this.updateImportQueueState(rr, s7Config);
                this.scene7PresetService.updateEncodingPresets(configResourceJcrContent);
                this.scene7PresetService.updateViewerPresets(configResourceJcrContent);
            }
            catch (LoginException e) {
                LOG.error("Unable to retrieve a resource resolver", (Throwable)e);
            }
            finally {
                if (rr != null) {
                    rr.close();
                }
            }
        }
    }

    private void cacheServersURLs(PersistableValueMap properties, String s7ConfigPath, S7Config s7Config) {
        String publishServer = this.scene7Service.getPublishServer(s7Config);
        String flashTemplatesServer = this.scene7Service.getFlashTemplatesServer(s7Config);
        String fxgServer = this.scene7Service.getFxgServer(s7Config);
        if (publishServer != null && !publishServer.equals(properties.get("publishServer", String.class))) {
            properties.put((Object)"publishServer", (Object)publishServer);
            LOG.debug("Caching publish server URL {} for the Scene7 configuration from {}", (Object)publishServer, (Object)s7ConfigPath);
        }
        if (flashTemplatesServer != null && !flashTemplatesServer.equals(properties.get("flashTemplatesServer", String.class))) {
            properties.put((Object)"flashTemplatesServer", (Object)flashTemplatesServer);
            LOG.debug("Caching flash templates server URL {} for the Scene7 configuration from {}", (Object)flashTemplatesServer, (Object)s7ConfigPath);
        }
        if (fxgServer != null && !fxgServer.equals(properties.get("fxgServer", String.class))) {
            properties.put((Object)"fxgServer", (Object)fxgServer);
            LOG.debug("Caching FXG server URL {} for the Scene7 configuration from {}", (Object)fxgServer, (Object)s7ConfigPath);
        }
    }

    private boolean generateImportQueueHandleIfNotExists(PersistableValueMap properties, String s7ConfigPath, String topicHash) {
        String importQueueName = (String)properties.get("importQueueName", String.class);
        if (importQueueName == null) {
            importQueueName = "Scene7 Import Queue-" + ResourceUtil.getName((String)s7ConfigPath);
            properties.put((Object)"importQueueName", (Object)importQueueName);
            String importQueueTopic = "com/dam/cq/scene7/importer/" + topicHash;
            properties.put((Object)"importQueueTopic", (Object)importQueueTopic);
            LOG.debug("Generating new import queue {} for Scene7 configuration {}", (Object)importQueueName, (Object)s7ConfigPath);
            return true;
        }
        return false;
    }

    private void createTargetFolder(ResourceResolver rr, String s7ConfigPath, S7Config s7Config) {
        String targetPath = s7Config.getTargetPath();
        if (targetPath != null) {
            Session session = (Session)rr.adaptTo(Session.class);
            try {
                if (targetPath.endsWith("/")) {
                    targetPath = targetPath.substring(0, targetPath.length() - 1);
                }
                Node s7AssetsFolder = JcrResourceUtil.createPath((String)targetPath, (String)"sling:OrderedFolder", (String)"sling:OrderedFolder", (Session)session, (boolean)true);
                s7AssetsFolder.setProperty("dam:scene7CloudConfigPath", s7ConfigPath);
                session.save();
            }
            catch (RepositoryException e) {
                LOG.error("Unable to create folder " + targetPath + " for target path", (Throwable)e);
            }
        }
    }

    private void updateImportQueueState(ResourceResolver rr, S7Config s7Config) {
        if (s7Config != null) {
            Resource pollingImporterResource = rr.getResource(s7Config.getCloudConfigPath() + "/" + "jcr:content" + "/" + "pollConfig");
            if (pollingImporterResource != null) {
                ValueMap pollingImporterProperties = (ValueMap)pollingImporterResource.adaptTo(ValueMap.class);
                Boolean cancelImporter = (Boolean)pollingImporterProperties.get("cancelImporter", (Object)Boolean.FALSE);
                Boolean importerEnabled = (Boolean)pollingImporterProperties.get("enabled", (Object)Boolean.FALSE);
                Queue importQueue = ImportJobUtils.getImportJobQueue(s7Config, this.slingJobManager);
                if (importQueue != null) {
                    if (importerEnabled.booleanValue()) {
                        importQueue.resume();
                    } else if (cancelImporter.booleanValue()) {
                        LOG.info("Canceling running Scene7 import job for config {}", (Object)s7Config.getCloudConfigPath());
                        LOG.debug("Found the {} property set to true, suspending the S7 import queue!", (Object)"cancelImporter");
                        importQueue.suspend();
                    }
                }
            } else {
                LOG.warn("Could not find the polling importer configuration for S7 config {}", (Object)s7Config.getCloudConfigPath());
            }
        } else {
            LOG.warn("Null Scene7 Configuration!");
        }
    }

    private void createImportQueueConfig(ResourceResolver rr, S7Config s7Config, String topicHash) {
        String queueConfigName = "org.apache.sling.event.jobs.QueueConfiguration-" + topicHash;
        String importQueueNodePath = "/apps/dam/config/" + queueConfigName;
        Session session = (Session)rr.adaptTo(Session.class);
        Node importQueueNode = null;
        try {
            importQueueNode = JcrResourceUtil.createPath((String)importQueueNodePath, (String)"nt:folder", (String)"sling:OsgiConfig", (Session)session, (boolean)true);
            importQueueNode.setProperty("queue.maxparallel", 5L);
            importQueueNode.setProperty("queue.name", "Scene7 Import Queue-" + ResourceUtil.getName((String)s7Config.getCloudConfigPath()));
            importQueueNode.setProperty("queue.priority", JobUtil.JobPriority.NORM.toString());
            importQueueNode.setProperty("queue.topics", "com/dam/cq/scene7/importer/" + topicHash);
            importQueueNode.setProperty("queue.type", QueueConfiguration.Type.TOPIC_ROUND_ROBIN.toString());
            importQueueNode.setProperty("queue.retries", 0L);
            session.save();
        }
        catch (Exception e) {
            LOG.error("Could not update queue configuration node " + importQueueNodePath, (Throwable)e);
        }
    }
}

