/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7PresetsService;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.impl.Scene7ConfigurationEventHandler;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="%cq.dam.scene7.configurationeventlistener.name", description="%cq.dam.scene7.configurationeventlistener.description")
@Properties(value={@Property(name="cq.dam.scene7.configurationeventlistener.enabled", boolValue={false}, label="%cq.dam.scene7.configurationeventlistener.enabled.label", description="%cq.dam.scene7.configurationeventlistener.enabled.description")})
public class Scene7ConfigurationEventListener
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ConfigurationEventListener.class);
    private static final String S7_CONFIG_PATH = "/etc/cloudservices/scene7/*";
    private static final String S7_CONFIG_RESOURCE_TYPE = "dam/components/scene7/scene7page";
    private static final String[] TOPICS = new String[]{"org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/CHANGED"};
    static final String SCR_PROP_NAME_ENABLED = "cq.dam.scene7.configurationeventlistener.enabled";
    static final boolean SCR_PROP_DEFAULT_ENABLED = false;
    private ServiceRegistration eventHandlerRegistration;
    private ThreadPool threadPool;
    private boolean enabled;
    @Reference
    private ThreadPoolManager threadPoolManager;
    @Reference
    private ResourceResolverFactory rrf;
    @Reference
    private S7ConfigResolver s7ConfigResolver;
    @Reference
    private Scene7Service scene7Service;
    @Reference
    private Scene7PresetsService scene7PresetService;
    @Reference
    private JobManager slingJobManager;

    public void handleEvent(Event event) {
        if (this.enabled && !this.isVersioningRelatedChangeEvent(event)) {
            String path = (String)event.getProperty("path");
            this.threadPool.execute((Runnable)new Scene7ConfigurationEventHandler(path, this.rrf, this.s7ConfigResolver, this.scene7Service, this.scene7PresetService, this.slingJobManager));
        }
    }

    private boolean isVersioningRelatedChangeEvent(Event event) {
        String[] resourcesAdded = (String[])event.getProperty("resourceAddedAttributes");
        if (resourcesAdded != null) {
            for (String resource : resourcesAdded) {
                if (!"jcr:versionHistory".equals(resource)) continue;
                return true;
            }
        }
        return false;
    }

    protected void activate(ComponentContext componentContext) {
        this.enabled = OsgiUtil.toBoolean(componentContext.getProperties().get(SCR_PROP_NAME_ENABLED), (boolean)false);
        Hashtable<String, Object> listenEventsDictionary = new Hashtable<String, Object>();
        ((Dictionary)listenEventsDictionary).put("event.topics", TOPICS);
        String filter = "(&(path=/etc/cloudservices/scene7/*)(resourceType=dam/components/scene7/scene7page))";
        ((Dictionary)listenEventsDictionary).put("event.filter", "(&(path=/etc/cloudservices/scene7/*)(resourceType=dam/components/scene7/scene7page))");
        this.eventHandlerRegistration = componentContext.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, listenEventsDictionary);
        LOG.info("Registered for OSGi events: topics={}, filter={}", (Object)TOPICS, (Object)"(&(path=/etc/cloudservices/scene7/*)(resourceType=dam/components/scene7/scene7page))");
        this.threadPool = this.threadPoolManager.get("Scene7ConfigurationEventListener");
    }

    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        if (this.threadPool != null) {
            this.threadPoolManager.release(this.threadPool);
        }
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7ConfigResolver = s7ConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7ConfigResolver == s7ConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }

    protected void bindScene7PresetService(Scene7PresetsService scene7PresetsService) {
        this.scene7PresetService = scene7PresetsService;
    }

    protected void unbindScene7PresetService(Scene7PresetsService scene7PresetsService) {
        if (this.scene7PresetService == scene7PresetsService) {
            this.scene7PresetService = null;
        }
    }

    protected void bindSlingJobManager(JobManager jobManager) {
        this.slingJobManager = jobManager;
    }

    protected void unbindSlingJobManager(JobManager jobManager) {
        if (this.slingJobManager == jobManager) {
            this.slingJobManager = null;
        }
    }
}

