/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7DAMService;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.impl.utils.RequestUtils;
import java.net.URISyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class Scene7DAMServiceImpl
implements Scene7DAMService {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7DAMServiceImpl.class);
    @Reference
    private S7ConfigResolver s7ConfigResolver;

    @Override
    public String getS7FileReference(Asset asset) {
        return this.getS7FileReference(asset, null);
    }

    @Override
    public String getS7FileReference(Asset asset, String configPath) {
        String fileReference = null;
        if (asset != null) {
            Resource assetResource = (Resource)asset.adaptTo(Resource.class);
            Resource metadataResource = assetResource.getChild("jcr:content/metadata");
            ValueMap metadata = (ValueMap)metadataResource.adaptTo(ValueMap.class);
            S7Config s7Config = configPath != null ? this.s7ConfigResolver.getS7Config(configPath) : this.s7ConfigResolver.getS7ConfigForResource(assetResource);
            String assetType = (String)metadata.get("dam:scene7Type", String.class);
            if (s7Config != null && assetType != null) {
                String originalPath = (String)metadata.get("dam:scene7OriginalPath", String.class);
                String originalFile = (String)metadata.get("dam:scene7OriginalFile", String.class);
                String name = ResourceUtil.getName((String)asset.getPath());
                try {
                    StringBuilder frSB = new StringBuilder();
                    if (Scene7AssetType.VIDEO.getValue().equals(assetType) || Scene7AssetType.MASTER_VIDEO.getValue().equals(assetType)) {
                        String scene7File = (String)metadata.get("dam:scene7File", (Object)"");
                        String extension = FilenameUtils.getExtension((String)originalFile);
                        scene7File = scene7File + "." + extension;
                        frSB.append(s7Config.getPublishServer()).append("e2/");
                        fileReference = RequestUtils.buildURL(frSB.toString(), scene7File, null);
                    } else if (Scene7AssetType.FLASH.getValue().equals(assetType)) {
                        frSB.append(s7Config.getFlashTemplatesServer());
                        fileReference = RequestUtils.buildURL(frSB.toString(), originalPath + originalFile, null);
                    } else {
                        frSB.append(s7Config.getPublishServer()).append("is/image/").append(s7Config.getBasePath());
                        fileReference = RequestUtils.buildURL(frSB.toString(), FilenameUtils.removeExtension((String)name), null);
                    }
                }
                catch (URISyntaxException e) {
                    LOG.error("Unable to obtain Scene7 file reference for " + asset.getPath(), (Throwable)e);
                }
            }
        }
        return fileReference;
    }

    protected void bindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7ConfigResolver = s7ConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7ConfigResolver == s7ConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }
}

