/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.Scene7UploadService;
import com.day.cq.dam.scene7.impl.utils.FolderAssetsUtils;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="%cq.dam.scene7.damchangeeventlistener.name", description="%cq.dam.scene7.damchangeeventlistener.description")
@Properties(value={@Property(name="cq.dam.scene7.damchangeeventlistener.enabled", boolValue={false}, label="%cq.dam.scene7.damchangeeventlistener.enabled.label", description="%cq.dam.scene7.damchangeeventlistener.enabled.description"), @Property(unbounded=PropertyUnbounded.ARRAY, name="cq.dam.scene7.damchangeeventlistener.observed.paths", value={"/content/dam"})})
public class Scene7DamChangeEventListener
implements EventListener {
    protected static final String SCR_PROP_NAME_PATHS = "cq.dam.scene7.damchangeeventlistener.observed.paths";
    private static final String[] SCR_PROP_DEFAULT_PATHS = new String[]{"/content/dam"};
    static final String SCR_PROP_NAME_ENABLED = "cq.dam.scene7.damchangeeventlistener.enabled";
    static final boolean SCR_PROP_DEFAULT_ENABLED = false;
    private static final Logger log = LoggerFactory.getLogger(Scene7DamChangeEventListener.class);
    @Reference
    private SlingRepository repository = null;
    @Reference(policy=ReferencePolicy.STATIC)
    private JcrResourceResolverFactory resolverFactory;
    @Reference
    private Scene7UploadService scene7UploadService;
    private String[] paths;
    private Session session;
    private ResourceResolver resolver;
    private boolean enabled;

    public void onEvent(EventIterator eventIterator) {
        while (eventIterator.hasNext()) {
            try {
                Event event = eventIterator.nextEvent();
                String eventPath = event.getPath();
                int eventType = event.getType();
                if (this.acceptPath(eventPath)) {
                    log.trace("processing event with path [{}].", (Object)eventPath);
                    String assetPath = StringUtils.substringBefore((String)eventPath, (String)"/jcr:content");
                    if (!this.acceptAssetPath(assetPath)) {
                        log.trace("ignoring asset path [{}].", (Object)assetPath);
                        continue;
                    }
                    if (!eventPath.equals(assetPath)) continue;
                    if (32 == eventType) {
                        String dstPath = (String)event.getInfo().get("destAbsPath");
                        String srcPath = (String)event.getInfo().get("srcAbsPath");
                        if (this.isAsset(dstPath)) {
                            this.handleMoveAsset(dstPath);
                            continue;
                        }
                        this.handleMoveFolder(dstPath, srcPath);
                        continue;
                    }
                    if (2 != eventType) continue;
                    log.trace("asset [{}] removed.", (Object)assetPath);
                    continue;
                }
                log.trace("event path [{}] doesn't match any configured of [{}], skipping.", (Object)eventPath, (Object)StringUtils.join((Object[])this.paths));
            }
            catch (RepositoryException e) {
                log.error("error processing event: ", (Throwable)e);
            }
        }
    }

    private void handleMoveAsset(String dstPath) {
        this.scene7UploadService.moveFile(dstPath, this.resolver);
    }

    private void handleMoveFolder(String dstPath, String srcPath) {
        this.scene7UploadService.moveFolder(dstPath, srcPath, this.resolver);
    }

    private boolean acceptPath(String path) {
        for (String p : this.paths) {
            if (!StringUtils.startsWith((String)path, (String)p)) continue;
            return true;
        }
        return false;
    }

    private boolean acceptAssetPath(String assetPath) {
        return !Text.getName((String)assetPath).startsWith("._");
    }

    @Activate
    private void setup(ComponentContext context) throws RepositoryException {
        this.enabled = OsgiUtil.toBoolean(context.getProperties().get(SCR_PROP_NAME_ENABLED), (boolean)false);
        if (!this.enabled) {
            return;
        }
        String[] configPaths = OsgiUtil.toStringArray(context.getProperties().get(SCR_PROP_NAME_PATHS), (String[])SCR_PROP_DEFAULT_PATHS);
        this.paths = new String[configPaths.length];
        for (int i = 0; i < configPaths.length; ++i) {
            String path = configPaths[i];
            this.paths[i] = StringUtils.endsWith((String)path, (String)"/") ? path : path + "/";
        }
        this.session = this.repository.loginAdministrative(null);
        this.resolver = this.resolverFactory.getResourceResolver(this.session);
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 34, "/", true, null, null, true);
    }

    @Deactivate
    private void cleanup() {
        if (null != this.session) {
            try {
                this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                log.warn("error while unregistering observation: ", (Throwable)e);
            }
            this.session.logout();
        }
    }

    private boolean isAsset(String assetPath) {
        try {
            Node node = (Node)this.resolver.getResource(assetPath).adaptTo(Node.class);
            return FolderAssetsUtils.isAssetNode(node);
        }
        catch (Exception e) {
            log.error("checking - isAsset", (Object)e.getMessage());
            return false;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindScene7UploadService(Scene7UploadService scene7UploadService) {
        this.scene7UploadService = scene7UploadService;
    }

    protected void unbindScene7UploadService(Scene7UploadService scene7UploadService) {
        if (this.scene7UploadService == scene7UploadService) {
            this.scene7UploadService = null;
        }
    }
}

