/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.Scene7Endpoint;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import com.day.cq.wcm.api.PageEvent;
import com.day.cq.wcm.api.PageModification;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={Scene7EndpointsManager.class})
public class Scene7EndpointsManagerImpl
implements Scene7EndpointsManager,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7EndpointsManagerImpl.class);
    @Reference
    private ResourceResolverFactory rrf;
    @Reference
    private ThreadPoolManager threadPoolManager;
    private ResourceResolver rr;
    private ServiceRegistration eventHandlerRegistration;
    private ConcurrentHashMap<String, Scene7Endpoint> endpoints;
    private ThreadPool threadPool;

    @Override
    public URL getAPIServer(String region) {
        Scene7Endpoint endpoint = this.endpoints.get(region);
        return endpoint == null ? null : endpoint.getApiURL();
    }

    @Override
    public URL getIPSServer(String region) {
        Scene7Endpoint endpoint = this.endpoints.get(region);
        return endpoint == null ? null : endpoint.getIpsURL();
    }

    @Override
    public URL getSPSServer(String region) {
        Scene7Endpoint endpoint = this.endpoints.get(region);
        return endpoint == null ? null : endpoint.getSpsURL();
    }

    @Override
    public URL getViewerSdkServer(String region) {
        Scene7Endpoint endpoint = this.endpoints.get(region);
        return endpoint == null ? null : endpoint.getViewerSdkURL();
    }

    @Override
    public String getAPIVersion(String region) {
        Scene7Endpoint endpoint = this.endpoints.get(region);
        return endpoint == null ? null : endpoint.getApiVersion();
    }

    public void handleEvent(Event event) {
        this.processEvent(event);
    }

    @Override
    public List<Scene7Endpoint> getScene7Endpoints() {
        ArrayList<Scene7Endpoint> endpointsList = new ArrayList<Scene7Endpoint>(this.endpoints.values());
        Collections.sort(endpointsList);
        return endpointsList;
    }

    private void processEvent(Event event) {
        final PageEvent pageEvent = PageEvent.fromEvent((Event)event);
        if (pageEvent != null) {
            Runnable eventTask = new Runnable(){

                @Override
                public void run() {
                    Iterator pageModifications = pageEvent.getModifications();
                    while (pageModifications.hasNext()) {
                        PageModification modification = (PageModification)pageModifications.next();
                        String path = modification.getPath();
                        if (!path.startsWith("/etc/cloudservices/scene7/endpoints")) continue;
                        if (modification.getType().equals((Object)PageModification.ModificationType.CREATED) || modification.getType().equals((Object)PageModification.ModificationType.MODIFIED)) {
                            Resource endpointResource = Scene7EndpointsManagerImpl.this.rr.getResource(path + "/" + "jcr:content");
                            if (endpointResource == null) continue;
                            Scene7EndpointsManagerImpl.this.extractEndpointFromResource(endpointResource);
                            continue;
                        }
                        if (!modification.getType().equals((Object)PageModification.ModificationType.DELETED)) continue;
                        Scene7EndpointsManagerImpl.this.endpoints.remove(ResourceUtil.getName((String)path));
                        LOG.info("Removed Scene7 endpoint from {}", (Object)path);
                    }
                }
            };
            this.threadPool.execute(eventTask);
        }
    }

    private void extractEndpointFromResource(Resource endpointResource) {
        String region = endpointResource.getParent().getName();
        ValueMap endpointProperties = (ValueMap)endpointResource.adaptTo(ValueMap.class);
        URL viewersdkURL = null;
        if (endpointProperties != null) {
            String apiVersion;
            URL spsURL;
            URL ipsURL;
            URL apiURL;
            String apiURLValue = (String)endpointProperties.get("apiURL", String.class);
            try {
                apiURL = new URL(apiURLValue);
            }
            catch (MalformedURLException e) {
                LOG.warn("Scene7 endpoint {}'s API URL (={}) is malformed; skipping", (Object)endpointResource.getParent().getPath(), (Object)apiURLValue);
                return;
            }
            String ipsURLValue = (String)endpointProperties.get("ipsURL", String.class);
            try {
                ipsURL = new URL(ipsURLValue);
            }
            catch (MalformedURLException e) {
                LOG.warn("Scene7 endpoint {}'s IPS URL (={}) is malformed; skipping", (Object)endpointResource.getParent().getPath(), (Object)ipsURLValue);
                return;
            }
            String spsURLValue = (String)endpointProperties.get("spsURL", String.class);
            try {
                spsURL = new URL(spsURLValue);
            }
            catch (MalformedURLException e) {
                LOG.warn("Scene7 endpoint {}'s SPS URL (={}) is malformed; skipping", (Object)endpointResource.getParent().getPath(), (Object)spsURLValue);
                return;
            }
            String viewersdkURLValue = (String)endpointProperties.get("viewersdkURL", String.class);
            if (viewersdkURLValue != null) {
                try {
                    viewersdkURL = new URL(viewersdkURLValue);
                }
                catch (MalformedURLException e) {
                    LOG.warn("Scene7 endpoint {}'s Viewer SDK URL (={}) is malformed; skipping", (Object)endpointResource.getParent().getPath(), (Object)viewersdkURLValue);
                    return;
                }
            }
            if ((apiVersion = (String)endpointProperties.get("apiVersion", String.class)) == null) {
                LOG.warn("Scene7 endpoint {}'s API version is missing; skipping", (Object)endpointResource.getParent().getPath());
                return;
            }
            String description = (String)endpointProperties.get("jcr:title", String.class);
            Scene7Endpoint endpoint = new Scene7Endpoint(apiURL, ipsURL, spsURL, viewersdkURL, apiVersion, region, description);
            this.endpoints.put(region, endpoint);
            LOG.info("Found Scene7 endpoint for region {}: {}", (Object)region, (Object)endpoint.toString());
        }
    }

    protected void activate(ComponentContext context) {
        Hashtable<String, String> listenEventsDictionary = new Hashtable<String, String>();
        ((Dictionary)listenEventsDictionary).put("event.topics", "com/day/cq/wcm/core/page");
        this.eventHandlerRegistration = context.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, listenEventsDictionary);
        LOG.info("Registered for OSGi events: topics={}", (Object)"com/day/cq/wcm/core/page");
        this.endpoints = new ConcurrentHashMap();
        try {
            this.rr = this.rrf.getAdministrativeResourceResolver(null);
            Resource endpointsRoot = this.rr.getResource("/etc/cloudservices/scene7/endpoints");
            if (endpointsRoot != null) {
                Iterator iterator = endpointsRoot.listChildren();
                while (iterator.hasNext()) {
                    Resource jcrContent;
                    Resource endpointResource = (Resource)iterator.next();
                    if (!endpointResource.getResourceType().equals("cq:Page") || (jcrContent = endpointResource.getChild("jcr:content")) == null) continue;
                    this.extractEndpointFromResource(jcrContent);
                }
                this.threadPool = this.threadPoolManager.get("Event processing pool");
            }
        }
        catch (LoginException e) {
            LOG.error("Unable to obtain a resource resolver", (Throwable)e);
        }
    }

    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        if (this.rr != null) {
            this.rr.close();
        }
        if (this.threadPool != null) {
            this.threadPoolManager.release(this.threadPool);
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        this.threadPoolManager = threadPoolManager;
    }

    protected void unbindThreadPoolManager(ThreadPoolManager threadPoolManager) {
        if (this.threadPoolManager == threadPoolManager) {
            this.threadPoolManager = null;
        }
    }
}

