/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import com.day.cq.dam.scene7.api.Scene7FileMetadataService;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import javax.jcr.Node;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

@Component
@Service
public class Scene7FileMetadataServiceImpl
implements Scene7FileMetadataService {
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;

    @Override
    public void setAssetMetadataProperty(Asset asset, String propertyName, Object propertyValue) throws Exception {
        Resource resource = (Resource)asset.adaptTo(Resource.class);
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            Node metadata = node.getNode("jcr:content/metadata");
            JcrUtil.setProperty((Node)metadata, (String)propertyName, (Object)propertyValue);
        }
    }

    @Override
    public void setAssetMetadataOnSync(Asset asset, Scene7Asset scene7Asset, S7Config s7Config, String status) throws Exception {
        this.setAssetMetadataProperty(asset, "dam:scene7ID", scene7Asset.getAssetHandle());
        String publishedServer = s7Config.getPublishServer();
        if (!publishedServer.endsWith("/")) {
            publishedServer = publishedServer + "/";
        }
        this.setAssetMetadataProperty(asset, "dam:scene7Name", scene7Asset.getName());
        this.setAssetMetadataProperty(asset, "dam:scene7Type", scene7Asset.getAssetType().getValue());
        this.setAssetMetadataProperty(asset, "dam:scene7File", scene7Asset.getRootFolder() + scene7Asset.getName());
        this.setAssetMetadataProperty(asset, "dam:scene7CompanyID", s7Config.getCompanyHandle());
        this.setAssetMetadataProperty(asset, "dam:scene7Domain", publishedServer);
        this.setAssetMetadataProperty(asset, "dam:scene7APIServer", this.scene7EndpointsManager.getAPIServer(s7Config.getRegion()).toString());
        this.setAssetMetadataProperty(asset, "dam:scene7CloudConfigPath", s7Config.getCloudConfigPath());
        this.setAssetMetadataProperty(asset, "dam:scene7FileStatus", status);
        Long s7LastModifiedTimestamp = scene7Asset.getModifiedDate().getTime();
        this.setAssetMetadataProperty(asset, "dam:scene7LastModified", s7LastModifiedTimestamp);
        this.setAssetMetadataProperty(asset, "dam:scene7Folder", scene7Asset.getFolder());
    }

    @Override
    public void removeAssetMetadataProperty(Asset asset, String propertyName) throws Exception {
        Resource resource = (Resource)asset.adaptTo(Resource.class);
        Resource metadataResource = resource.getChild("jcr:content/metadata");
        Node metadataNode = (Node)metadataResource.adaptTo(Node.class);
        metadataNode.getProperty(propertyName).remove();
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }
}

