/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.Scene7FlashTemplatesService;
import com.day.cq.dam.scene7.api.constants.FlashTemplateAssetConstants;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Iterator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.xml.XML;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.dam.scene7.flashtemplatesservice.name", description="%cq.dam.scene7.flashtemplatesservice.description")
@Service
@Properties(value={@Property(name="scene7FlashTemplates.rti", value={"rti"}, label="%cq.dam.scene7.flashtemplateservice.rti.label", description="%cq.dam.scene7.flashtemplateservice.rti.description"), @Property(name="scene7FlashTemplates.rsi", value={"rsi"}, label="%cq.dam.scene7.flashtemplateservice.rsi.label", description="%cq.dam.scene7.flashtemplateservice.rsi.description"), @Property(name="scene7FlashTemplates.rb", value={"rb"}, label="%cq.dam.scene7.flashtemplateservice.rb.label", description="%cq.dam.scene7.flashtemplateservice.rb.description"), @Property(name="scene7FlashTemplates.rurl", value={"rurl"}, label="%cq.dam.scene7.flashtemplateservice.rurl.label", description="%cq.dam.scene7.flashtemplateservice.rurl.description"), @Property(name="scene7FlashTemplate.urlFormatParameter", value={"fmt"}, label="%cq.dam.scene7.flashtemplateservice.urlFormatParameter.label", description="%cq.dam.scene7.flashtemplateservice.urlFormatParameter.description")})
public class Scene7FlashTemplatesServiceImpl
implements Scene7FlashTemplatesService {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7FlashTemplatesServiceImpl.class);
    private String rti;
    private String rsi;
    private String rb;
    private String rurl;
    private String formatParameter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject getFlashTemplateAssets(Resource resource, FlashTemplateAssetConstants assetType) {
        JSONObject json = new JSONObject();
        ResourceResolver rr = null;
        if (resource != null) {
            try {
                rr = resource.getResourceResolver();
                ValueMap resourceProperties = (ValueMap)resource.adaptTo(ValueMap.class);
                if (resourceProperties != null) {
                    String fileReference = (String)resourceProperties.get("fileReference", String.class);
                    if (fileReference != null) {
                        StringBuffer sb = new StringBuffer(fileReference);
                        sb.append("?req=").append(FlashTemplateAssetConstants.CONTENTS.getAssetType());
                        HttpClient httpClient = new HttpClient();
                        if (assetType != null && !assetType.equals(FlashTemplateAssetConstants.CONTENTS.getAssetType())) {
                            sb.append(",").append(assetType.getAssetType()).toString();
                        }
                        GetMethod request = new GetMethod(sb.toString());
                        httpClient.executeMethod((HttpMethod)request);
                        InputStream is = request.getResponseBodyAsStream();
                        if (is != null) {
                            String responseBody = IOUtils.toString((InputStream)is);
                            json = XML.toJSONObject((String)responseBody);
                        }
                    } else {
                        LOG.error("Could not find the {} property on the resource located at {}", (Object)"fileReference", (Object)resource.getPath());
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error encountered while parsing XML to JSON", (Throwable)e);
            }
            finally {
                if (rr != null) {
                    rr.close();
                }
            }
        }
        return json;
    }

    @Override
    public String getFlashTemplateModifyURL(Resource resource) {
        String url;
        StringBuilder sb = new StringBuilder();
        if (resource != null) {
            ValueMap resourceProperties = (ValueMap)resource.adaptTo(ValueMap.class);
            String fileReference = (String)resourceProperties.get("fileReference", String.class);
            String manualModifiers = (String)resourceProperties.get("manualModifiers", String.class);
            String outputType = (String)resourceProperties.get("outputType", String.class);
            if (fileReference != null) {
                sb.append(fileReference);
                Resource modifiers = resource.getChild("modifiers");
                if (modifiers != null) {
                    sb.append("?");
                    Iterator childrenIterator = modifiers.listChildren();
                    while (childrenIterator.hasNext()) {
                        Resource modifierNode = (Resource)childrenIterator.next();
                        Iterator modifiersIterator = modifierNode.listChildren();
                        while (modifiersIterator.hasNext()) {
                            Resource modifier = (Resource)modifiersIterator.next();
                            ValueMap modifierProperties = (ValueMap)modifier.adaptTo(ValueMap.class);
                            String key = (String)modifierProperties.get((Object)"key");
                            if (key == null) {
                                LOG.warn("Could not find a \"key\" property for the {} modifier for resource at {}", (Object)modifier.getPath(), (Object)resource.getPath());
                                continue;
                            }
                            String[] replace = (String[])modifierProperties.get("replace", String[].class);
                            if (replace == null) {
                                LOG.warn("Could not find a \"replace\" property for the {} modifier for resource at {}", (Object)modifier.getPath(), (Object)resource.getPath());
                                continue;
                            }
                            if (modifierNode.getName().equals("text")) {
                                if ("_all_".equals(key)) {
                                    sb.append(this.rti).append("(").append(replace[0]).append(")&");
                                    continue;
                                }
                                if (replace.length == 1) {
                                    String replaceValue = replace[0];
                                    String[] split = replaceValue.split("=");
                                    if (split.length == 1) {
                                        sb.append(this.rti).append(".").append(key).append("=").append(split[0]).append("&");
                                        continue;
                                    }
                                    if (split.length != 2) continue;
                                    sb.append(this.rti).append(".").append(key).append("(").append(replace[0]).append(")").append("&");
                                    continue;
                                }
                                sb.append(this.rti).append(".").append(key).append("(");
                                for (int i = 0; i < replace.length; ++i) {
                                    sb.append(replace[i]);
                                    if (replace.length <= 1 || i >= replace.length - 1) continue;
                                    sb.append(";");
                                }
                                sb.append(")&");
                                continue;
                            }
                            if (modifierNode.getName().equals("symbols")) {
                                sb.append(this.rsi).append("(").append(key).append("=").append(replace[0]).append(")&");
                                continue;
                            }
                            if (modifierNode.getName().equals("bitmaps")) {
                                sb.append(this.rb).append(".").append(key).append("=").append(replace[0]).append("&");
                                continue;
                            }
                            if (!modifierNode.getName().equals("urls")) continue;
                            sb.append(this.rurl).append("(").append(key).append("=").append(replace[0]).append(")&");
                        }
                    }
                }
                if (StringUtils.isNotEmpty((String)manualModifiers)) {
                    if (sb.indexOf("?") == -1) {
                        sb.append("?");
                    }
                    if (sb.lastIndexOf("&") > 0 && sb.lastIndexOf("&") < sb.length() - 1) {
                        sb.append("&");
                    }
                    sb.append(manualModifiers);
                }
                if (sb.indexOf("?") == -1) {
                    sb.append("?");
                }
                if (sb.lastIndexOf("&") > 0 && sb.lastIndexOf("&") < sb.length() - 1) {
                    sb.append("&");
                }
                sb.append(this.formatParameter).append("=");
                if (StringUtils.isNotEmpty((String)outputType)) {
                    sb.append(outputType);
                } else {
                    sb.append("swf");
                }
            }
        }
        if ((url = sb.toString()).endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    @Override
    public boolean renderAsHTML(Resource resource) {
        ValueMap resourceProperties;
        String outputType;
        boolean renderAsHTML = false;
        if (resource != null && StringUtils.isNotBlank((String)(outputType = (String)(resourceProperties = (ValueMap)resource.adaptTo(ValueMap.class)).get("outputType", String.class))) && !"swf".equals(outputType)) {
            renderAsHTML = true;
        }
        return renderAsHTML;
    }

    @Activate
    @Modified
    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.rti = OsgiUtil.toString(properties.get("scene7FlashTemplates.rti"), (String)"rti");
        this.rsi = OsgiUtil.toString(properties.get("scene7FlashTemplates.rsi"), (String)"rsi");
        this.rb = OsgiUtil.toString(properties.get("scene7FlashTemplates.rb"), (String)"rb");
        this.rurl = OsgiUtil.toString(properties.get("scene7FlashTemplates.rurl"), (String)"rurl");
        this.formatParameter = OsgiUtil.toString(properties.get("scene7FlashTemplate.urlFormatParameter"), (String)"fmt");
    }
}

