/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.model.Scene7Folder;
import com.day.cq.dam.scene7.impl.model.Scene7FolderImpl;
import com.day.cq.dam.scene7.impl.utils.DOMUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Scene7FolderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scene7FolderFactory.class);

    public Scene7Folder parseScene7Folders(Document document) {
        Scene7Folder s7RootFolder = null;
        if (document != null) {
            NodeList list = document.getElementsByTagName("folders");
            if (list.getLength() > 0) {
                Node rootFoldersNode = list.item(0);
                s7RootFolder = this.parseScene7FolderStructure((Element)rootFoldersNode);
            }
        } else {
            LOGGER.error("Unexpected data format while parsing the Scene7 folders!");
        }
        return s7RootFolder;
    }

    private Scene7Folder parseScene7FolderStructure(Element rootElement) {
        String folderHandle = DOMUtils.getNodeValue(rootElement, "folderHandle");
        String path = DOMUtils.getNodeValue(rootElement, "path");
        Date lastModifiedDate = DOMUtils.getDateNodeValue(rootElement, "childLastModified", "yyyy-MM-dd'T'HH:mm:ss.SSS");
        Scene7FolderImpl s7Folder = new Scene7FolderImpl(folderHandle, path, lastModifiedDate);
        NodeList subFolders = DOMUtils.getChildNodes(rootElement, "subfolderArray/items");
        if (subFolders != null) {
            for (int i = 0; i < subFolders.getLength(); ++i) {
                Element subFolderElement = (Element)subFolders.item(i);
                Scene7Folder subFolder = this.parseScene7FolderStructure(subFolderElement);
                s7Folder.addSubFolder(subFolder);
            }
        }
        return s7Folder;
    }
}

