/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class Scene7ImportQueueRemover
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ImportQueueRemover.class);
    private static final String[] TOPICS = new String[]{"org/apache/sling/api/resource/Resource/REMOVED"};
    private ServiceRegistration eventHandlerRegistration;
    private ResourceResolver rr;
    @Reference
    private ResourceResolverFactory rrf;
    @Reference
    private S7ConfigResolver s7ConfigResolver;
    @Reference
    private JobManager jobManager;

    public void handleEvent(Event event) {
        final String path = (String)event.getProperty("path");
        String parent = ResourceUtil.getParent((String)path);
        if ("/etc/cloudservices/scene7".equalsIgnoreCase(parent)) {
            Runnable queueRemover = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Scene7ImportQueueRemover.this.rr = Scene7ImportQueueRemover.this.rrf.getAdministrativeResourceResolver(null);
                        Session session = (Session)Scene7ImportQueueRemover.this.rr.adaptTo(Session.class);
                        List<S7Config> s7Configs = Scene7ImportQueueRemover.this.s7ConfigResolver.getS7Configurations("/etc/cloudservices/scene7");
                        ArrayList<String> validQueues = new ArrayList<String>();
                        for (S7Config s7Config : s7Configs) {
                            validQueues.add(s7Config.getImportQueueName());
                        }
                        Resource rootQueueConfigResource = Scene7ImportQueueRemover.this.rr.getResource("/apps/dam/config");
                        if (rootQueueConfigResource != null) {
                            Iterator s7ImportQueueConfigs = rootQueueConfigResource.listChildren();
                            while (s7ImportQueueConfigs.hasNext()) {
                                Resource s7QueueConfig = (Resource)s7ImportQueueConfigs.next();
                                ValueMap queueProperties = (ValueMap)s7QueueConfig.adaptTo(ValueMap.class);
                                String queueName = (String)queueProperties.get("queue.name", String.class);
                                if (validQueues.contains(queueName)) continue;
                                LOG.debug("Found stale queue {}, deleting!", (Object)queueName);
                                Queue invalidQueue = Scene7ImportQueueRemover.this.jobManager.getQueue(queueName);
                                if (invalidQueue != null) {
                                    invalidQueue.removeAll();
                                }
                                Node configNode = (Node)s7QueueConfig.adaptTo(Node.class);
                                configNode.remove();
                            }
                        } else {
                            LOG.warn("S7 Import queue config folder {} does not exist!", (Object)"/apps/dam/config");
                        }
                        session.save();
                    }
                    catch (Exception e) {
                        LOG.error("Could not delete the associated S7 import queue for config {}!", (Object)e, (Object)new Object[]{path});
                    }
                    finally {
                        if (Scene7ImportQueueRemover.this.rr != null) {
                            Scene7ImportQueueRemover.this.rr.close();
                        }
                    }
                }
            };
            new Thread(queueRemover).start();
        }
    }

    protected void activate(ComponentContext componentContext) {
        Hashtable<String, Object> listenEventsDictionary = new Hashtable<String, Object>();
        ((Dictionary)listenEventsDictionary).put("event.topics", TOPICS);
        String filter = "(&(path=/etc/cloudservices/scene7/*))";
        ((Dictionary)listenEventsDictionary).put("event.filter", "(&(path=/etc/cloudservices/scene7/*))");
        this.eventHandlerRegistration = componentContext.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, listenEventsDictionary);
        LOG.info("Registered for OSGi events: topics={}, filter={}", (Object)TOPICS, (Object)"(&(path=/etc/cloudservices/scene7/*))");
        try {
            this.rr = this.rrf.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            LOG.error("Unable to retrieve a resource resolver", (Throwable)e);
        }
    }

    protected void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
        if (this.rr != null) {
            this.rr.close();
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7ConfigResolver = s7ConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7ConfigResolver == s7ConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }
}

