/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.commons.ListInfoProvider;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.Scene7AssetMimetypeService;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, immediate=true)
@Service
public class Scene7ListInfoProvider
implements ListInfoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ListInfoProvider.class);
    static final String SCENE7_FILE_STATUS_JSON_KEY = "scene7Status";
    static final String SCENE7_TEMPLATE_PARAMS_JSON_KEY = "templateParams";
    static final String SCENE7_WIDTH_JSON_KEY = "imageWidth";
    static final String SCENE7_HEIGHT_JSON_KEY = "imageHeight";
    static final String MIMETYPE_JSON_KEY = "mimeType";
    @Reference
    private Scene7AssetMimetypeService scene7AssetMimetypeService;

    public void updateListGlobalInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
    }

    public void updateListItemInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
        Asset asset = (Asset)resource.adaptTo(Asset.class);
        if (asset != null) {
            ResourceResolver rr = resource.getResourceResolver();
            String path = resource.getPath();
            String mimeType = null;
            String scene7FileStatus = null;
            String templateParams = null;
            Long width = null;
            Long height = null;
            Resource metadataResource = null;
            metadataResource = path.endsWith("jcr:content") ? rr.getResource(path + "/" + "metadata") : rr.getResource(path + "/" + "jcr:content" + "/" + "metadata");
            if (metadataResource != null) {
                ValueMap valueMap = (ValueMap)metadataResource.adaptTo(ValueMap.class);
                scene7FileStatus = (String)valueMap.get("dam:scene7FileStatus", String.class);
                templateParams = (String)valueMap.get("dam:scene7TemplateParameters", String.class);
                width = (Long)valueMap.get("dam:scene7Width", Long.class);
                height = (Long)valueMap.get("dam:scene7Height", Long.class);
                mimeType = this.scene7AssetMimetypeService.getMimeTypeForAsset(asset);
            }
            LOG.debug("Resource {} has {}={}", new Object[]{path, SCENE7_FILE_STATUS_JSON_KEY, scene7FileStatus});
            if (scene7FileStatus != null) {
                JSONArray ddGroups;
                info.put(SCENE7_FILE_STATUS_JSON_KEY, (Object)scene7FileStatus);
                if ("contentfinder.assets".equals(request.getRequestPathInfo().getSelectorString()) && (ddGroups = info.getJSONArray("ddGroups")) != null) {
                    ddGroups.put((Object)"s7media");
                }
            }
            info.put(SCENE7_TEMPLATE_PARAMS_JSON_KEY, templateParams == null ? JSONObject.NULL : templateParams);
            info.put(SCENE7_WIDTH_JSON_KEY, width == null ? JSONObject.NULL : width);
            info.put(SCENE7_HEIGHT_JSON_KEY, height == null ? JSONObject.NULL : height);
            if (mimeType != null) {
                info.put(MIMETYPE_JSON_KEY, (Object)mimeType);
            }
        }
    }

    protected void bindScene7AssetMimetypeService(Scene7AssetMimetypeService scene7AssetMimetypeService) {
        this.scene7AssetMimetypeService = scene7AssetMimetypeService;
    }

    protected void unbindScene7AssetMimetypeService(Scene7AssetMimetypeService scene7AssetMimetypeService) {
        if (this.scene7AssetMimetypeService == scene7AssetMimetypeService) {
            this.scene7AssetMimetypeService = null;
        }
    }
}

