/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7PresetsService;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.api.model.Scene7PropertySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="%cq.dam.scene7.presetsservice.name", description="%cq.dam.scene7.presetsservice.description")
@Service
public class Scene7PresetsServiceImpl
implements Scene7PresetsService {
    @Reference
    private S7ConfigResolver s7configResolver;
    @Reference
    private Scene7Service scene7Service;
    private static final Comparator<Resource> ENCODING_PRESET_COMPARATOR = new Comparator<Resource>(){

        @Override
        public int compare(Resource r1, Resource r2) {
            String name1 = (String)((ValueMap)r1.adaptTo(ValueMap.class)).get((Object)"name");
            String name2 = (String)((ValueMap)r2.adaptTo(ValueMap.class)).get((Object)"name");
            if (name1 == null && name2 == null) {
                return 0;
            }
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(Scene7PresetsServiceImpl.class);

    @Override
    public Iterator<Resource> getEncodingPresets(Resource configResource) {
        List<Resource> presets = this.getPresets(configResource, "presets/encoding");
        return Scene7PresetsServiceImpl.sortEncodingPresets(presets).iterator();
    }

    private static List<Resource> sortEncodingPresets(List<Resource> presets) {
        Collections.sort(presets, ENCODING_PRESET_COMPARATOR);
        return presets;
    }

    @Override
    public Iterator<Resource> getViewerPresets(Resource configResource) {
        return this.getPresets(configResource, "presets/viewer").iterator();
    }

    @Override
    public boolean updateEncodingPresets(Resource configResource) {
        try {
            S7Config s7Config = this.s7configResolver.getS7Config(configResource.getParent().getPath());
            S7Config sharedConfig = this.s7configResolver.getSharedS7Config(s7Config);
            String typeHandle = this.scene7Service.getVideoEncoderPresetTypeHandle(s7Config);
            this.updateEncodingPresets(configResource, s7Config, typeHandle);
            Resource shared = configResource.getParent().getParent();
            this.updateEncodingPresets(shared, sharedConfig, typeHandle);
            Session session = (Session)configResource.getResourceResolver().adaptTo(Session.class);
            session.save();
            return true;
        }
        catch (RepositoryException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateViewerPresets(Resource configResource) {
        try {
            S7Config s7Config = this.s7configResolver.getS7Config(configResource.getParent().getPath());
            S7Config sharedConfig = this.s7configResolver.getSharedS7Config(s7Config);
            this.updateViewerPresets(configResource, s7Config);
            Resource shared = configResource.getParent().getParent();
            this.updateViewerPresets(shared, sharedConfig);
            Session session = (Session)configResource.getResourceResolver().adaptTo(Session.class);
            session.save();
            return true;
        }
        catch (RepositoryException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private List<Resource> getPresets(Resource configResource, String relPresetPath) {
        Resource sharedResource;
        Resource sharedPresetsResource;
        ArrayList<Resource> presets = new ArrayList<Resource>();
        Resource presetsResource = configResource.getChild(relPresetPath);
        if (presetsResource != null) {
            presets.addAll(this.toList(presetsResource.listChildren()));
        }
        if ((sharedPresetsResource = (sharedResource = configResource.getParent().getParent()).getChild(relPresetPath)) != null) {
            presets.addAll(this.toList(sharedPresetsResource.listChildren()));
        }
        return presets;
    }

    private List<Resource> toList(Iterator<Resource> resources) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        if (resources != null) {
            while (resources.hasNext()) {
                resourceList.add(resources.next());
            }
        }
        return resourceList;
    }

    private void updateEncodingPresets(Resource configResource, S7Config s7Config, String typeHandle) throws RepositoryException {
        List<Scene7PropertySet> propertySets = this.scene7Service.getPropertySets(typeHandle, s7Config);
        String path = configResource.getPath() + "/" + "presets/encoding";
        Node node = this.prepNode(configResource.getResourceResolver(), path);
        boolean i = false;
        for (Scene7PropertySet propertySet : propertySets) {
            String handle = propertySet.getSetHandle();
            String nodeName = this.getNodeName(handle);
            if (!StringUtils.isNotBlank((String)nodeName)) continue;
            Node presetNode = node.addNode(nodeName);
            presetNode.setProperty("handle", handle);
            Map<String, String> properties = propertySet.getProperties();
            for (String key : properties.keySet()) {
                String value = properties.get(key);
                key = StringUtils.uncapitalize((String)key);
                presetNode.setProperty(key, value);
            }
        }
    }

    private void updateViewerPresets(Resource configResource, S7Config s7Config) throws RepositoryException {
        List<Scene7Asset> assets = this.scene7Service.searchAssets(s7Config.getBasePath(), Boolean.TRUE, Boolean.TRUE, new String[]{"ViewerPreset"}, null, new String[]{"assetArray/items/assetHandle", "assetArray/items/type", "assetArray/items/name", "assetArray/items/viewerPresetInfo"}, null, s7Config);
        if (assets.size() > 0) {
            String path = configResource.getPath() + "/" + "presets/viewer";
            Node node = this.prepNode(configResource.getResourceResolver(), path);
            int i = 0;
            for (Scene7Asset asset : assets) {
                String name = asset.getName();
                String type = asset.getViewerPresetType();
                Node presetNode = node.addNode("preset" + i);
                presetNode.setProperty("name", name);
                presetNode.setProperty("type", type != null ? type : "");
                presetNode.setProperty("config", s7Config.getBasePath() + name);
                Map<String, String> viewerPresetConfigurationSettings = asset.getViewerPresetConfigurationSettings();
                if (viewerPresetConfigurationSettings != null && !viewerPresetConfigurationSettings.isEmpty()) {
                    presetNode = presetNode.addNode("settings");
                    for (Map.Entry<String, String> entry : viewerPresetConfigurationSettings.entrySet()) {
                        String settingName = entry.getKey();
                        String value = entry.getValue();
                        if (settingName == null || value == null) continue;
                        presetNode.setProperty(settingName, value);
                    }
                }
                ++i;
            }
        }
    }

    private Node prepNode(ResourceResolver resolver, String path) throws RepositoryException {
        Session session = (Session)resolver.adaptTo(Session.class);
        Node targetNode = JcrResourceUtil.createPath((String)path, (String)"nt:unstructured", (String)"nt:unstructured", (Session)session, (boolean)false);
        Node parent = targetNode.getParent();
        String nodeName = targetNode.getName();
        targetNode.remove();
        return parent.addNode(nodeName);
    }

    private String getNodeName(String presetHandle) {
        return presetHandle.replace("|", "-");
    }

    protected void bindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7configResolver = s7ConfigResolver;
    }

    protected void unbindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7configResolver == s7ConfigResolver) {
            this.s7configResolver = null;
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }
}

