/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.Scene7Publisher;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7APIClient;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.constants.Scene7JobType;
import com.day.cq.dam.scene7.impl.JobLogNotAvailableException;
import com.day.cq.dam.scene7.impl.PublishingJob;
import com.day.cq.search.QueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component(label="%cq.dam.scene7.publisher.name", description="%cq.dam.scene7.publisher.description")
@Service
public class Scene7PublisherServiceImpl
implements com.day.cq.dam.scene7.api.Scene7Publisher,
Scene7Publisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int JOB_PERIOD = 20;
    List<PublishingJob> jobQueue = new ArrayList<PublishingJob>();
    private EventListenerList listeners = new EventListenerList();
    @Reference
    private Scheduler scheduler;
    @Reference(policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference(policy=ReferencePolicy.STATIC)
    private JcrResourceResolverFactory resolverFactory;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private Scene7Service scene7Service;
    @Reference
    private Scene7APIClient scene7APIClient;
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;
    private ResourceResolver resolver;
    private Session adminSession;

    @Activate
    protected void activate(ComponentContext context) throws Exception {
        this.adminSession = this.repository.loginAdministrative(null);
        this.resolver = this.resolverFactory.getResourceResolver(this.adminSession);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) throws Exception {
        this.resolver = null;
        this.adminSession.logout();
    }

    @Override
    public void addJob(S7Config s7Config, String path, Map<String, String> statusPublishQueryMap) {
        PublishingJob job = new PublishingJob(this, s7Config, path, statusPublishQueryMap, this.resolver, this.queryBuilder, this.scene7Service, this.scene7EndpointsManager);
        boolean shouldAdd = true;
        for (PublishingJob tmp : this.jobQueue) {
            if (!job.equals(tmp)) continue;
            if (tmp.getState() == PublishingJob.State.PUBLISHING) {
                tmp.setShouldRepublish(true);
            }
            shouldAdd = false;
            tmp.updateTimestamp();
            this.log.debug("existing job updated for " + s7Config.getEmail());
            return;
        }
        if (shouldAdd) {
            this.log.debug("new job added for email '" + s7Config.getEmail() + "', company '" + s7Config.getCompanyHandle() + "' to '" + this.scene7EndpointsManager.getAPIServer(s7Config.getRegion().toString()) + "'");
            this.jobQueue.add(job);
            job.setState(PublishingJob.State.QUEUED);
            HashMap config = new HashMap();
            try {
                this.scheduler.addPeriodicJob(job.getName(), (Object)job, config, 20L, true);
            }
            catch (Exception e) {
                this.log.error("Error while adding scene7 publishing job", (Throwable)e);
            }
        }
    }

    @Override
    public void removeJob(String name) {
        this.scheduler.removeJob(name);
        PublishingJob job = null;
        for (PublishingJob tmp : this.jobQueue) {
            if (!tmp.getName().equals(name)) continue;
            job = tmp;
            break;
        }
        this.jobQueue.remove(job);
        this.fireEvent(new ChangeEvent(job));
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    @Override
    public boolean isPublishJobActive(String publishJobType, S7Config s7Config) {
        Document document = this.scene7APIClient.getActiveJobs(null, null, s7Config);
        if (document != null) {
            NodeList activeJobNodeslist = document.getElementsByTagName("items");
            for (int i = 0; i < activeJobNodeslist.getLength(); ++i) {
                NodeList nodes = ((Element)activeJobNodeslist.item(i)).getElementsByTagName(publishJobType);
                if (nodes.getLength() <= 0 || nodes.item(0).getFirstChild() == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String startPublishJob(String path, S7Config s7Config) {
        try {
            NodeList list;
            Document document;
            String jobName = "CQ5_publish_job_" + System.currentTimeMillis();
            if (path != null) {
                String basePubName = path.replaceAll("^/content/dam/", "").split("/")[0];
                jobName = "CQ5_publish_job_" + basePubName + "_" + System.currentTimeMillis();
            }
            if ((document = this.scene7APIClient.submitJob(jobName, Scene7JobType.IMAGE_SERVING_PUBLISH_JOB, s7Config)) != null && (list = document.getElementsByTagName("jobHandle")).getLength() > 0 && list.item(0).getFirstChild() != null) {
                return jobName;
            }
        }
        catch (Exception e) {
            this.log.error("startPublishJob failed: " + e.getMessage());
        }
        return null;
    }

    @Override
    public boolean isPublishJobSuccessByOrignalName(String originalName, S7Config s7Config) {
        Boolean jobSuccess = false;
        Document document = this.scene7APIClient.getJobLogDetails(null, originalName, s7Config);
        if (document != null) {
            NodeList jobDetailsNodeslist = document.getElementsByTagName("items");
            if (jobDetailsNodeslist == null) {
                throw new JobLogNotAvailableException();
            }
            Element listElement = (Element)jobDetailsNodeslist.item(0);
            if (listElement == null) {
                throw new JobLogNotAvailableException();
            }
            NodeList nodes = listElement.getElementsByTagName("fatalError");
            if (nodes.getLength() > 0 && nodes.item(0).getFirstChild().getNodeValue() != null) {
                jobSuccess = "false".equals(nodes.item(0).getFirstChild().getNodeValue());
            }
        }
        return jobSuccess;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    private void fireEvent(ChangeEvent event) {
        ChangeListener[] arr = (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
        for (int i = 0; i < arr.length; ++i) {
            arr[i].stateChanged(event);
        }
    }

    @Override
    public void addJob(String email, String password, String companyHandle, String path, String datacenterUrl, Map<String, String> publishStatusQueryMap) {
        throw new UnsupportedOperationException("Deprecated method. Please use the [addJob(S7Config s7Config, String path, Map<String, String> statusPublishQueryMap)] method");
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }

    protected void bindScene7APIClient(Scene7APIClient scene7APIClient) {
        this.scene7APIClient = scene7APIClient;
    }

    protected void unbindScene7APIClient(Scene7APIClient scene7APIClient) {
        if (this.scene7APIClient == scene7APIClient) {
            this.scene7APIClient = null;
        }
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }
}

