/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.day.cq.dam.scene7.Scene7Service;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7APIClient;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.api.model.Scene7Folder;
import com.day.cq.dam.scene7.api.model.Scene7PropertySet;
import com.day.cq.dam.scene7.api.model.UploadJobDetail;
import com.day.cq.dam.scene7.impl.MetadataCondition;
import com.day.cq.dam.scene7.impl.Scene7AssetFactory;
import com.day.cq.dam.scene7.impl.Scene7FolderFactory;
import com.day.cq.dam.scene7.impl.model.Scene7PropertySetImpl;
import com.day.cq.dam.scene7.impl.model.UploadJobDetailImpl;
import com.day.cq.dam.scene7.impl.utils.DOMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
@Service
public class Scene7ServiceImpl
implements com.day.cq.dam.scene7.api.Scene7Service,
Scene7Service {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ServiceImpl.class);
    @Reference
    private Scene7APIClient scene7APIClient;

    @Override
    public String getApplicationPropertyHandle(S7Config s7Config) {
        return this.getPropertyByNodeNameAndTagName(this.scene7APIClient.getPropertySetTypes(s7Config), "Adobe.SPS.ApplicationSetting", "typeHandle");
    }

    @Override
    public String getVideoEncoderPresetTypeHandle(S7Config s7Config) {
        return this.getPropertyByNodeNameAndTagName(this.scene7APIClient.getPropertySetTypes(s7Config), "Adobe.IPS.VideoEncoderPreset", "typeHandle");
    }

    @Override
    public List<Scene7PropertySet> getPropertySets(String handle, S7Config s7Config) {
        ArrayList<Scene7PropertySet> propertySets = new ArrayList<Scene7PropertySet>();
        try {
            Document document = this.scene7APIClient.getPropertySets(handle, s7Config);
            if (document != null) {
                NodeList setArray = document.getElementsByTagName("setArray");
                if (setArray != null) {
                    Element setArrayElement = (Element)setArray.item(0);
                    NodeList setArrayItems = setArrayElement.getElementsByTagName("items");
                    if (setArrayItems != null) {
                        for (int i = 0; i < setArrayItems.getLength(); ++i) {
                            Element propertySet = (Element)setArrayItems.item(i);
                            String setHandle = DOMUtils.getNodeValue(propertySet, "setHandle");
                            if (StringUtils.isEmpty((String)setHandle)) continue;
                            String typeHandle = DOMUtils.getNodeValue(propertySet, "typeHandle");
                            NodeList propertyArray = propertySet.getElementsByTagName("propertyArray");
                            if (propertyArray != null) {
                                Element propertyArrayElement = (Element)propertyArray.item(0);
                                NodeList propertyArrayItems = propertyArrayElement.getElementsByTagName("items");
                                if (propertyArrayItems != null) {
                                    HashMap<String, String> properties = new HashMap<String, String>();
                                    for (int j = 0; j < propertyArrayItems.getLength(); ++j) {
                                        Element property = (Element)propertyArrayItems.item(j);
                                        String propertyName = DOMUtils.getNodeValue(property, "name");
                                        String propertyValue = DOMUtils.getNodeValue(property, "value");
                                        properties.put(propertyName, propertyValue);
                                    }
                                    Scene7PropertySetImpl scene7PropertySet = new Scene7PropertySetImpl(setHandle, typeHandle, properties);
                                    propertySets.add(scene7PropertySet);
                                    continue;
                                }
                                LOG.error("Cannot find any items in the propertyArray tag");
                                continue;
                            }
                            LOG.error("Cannot find a propertyArray in the response");
                        }
                    } else {
                        LOG.error("Cannot find any items in the setArray tag");
                    }
                } else {
                    LOG.error("Cannot find a settArray in the response");
                }
            } else {
                LOG.error("Received a null document");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve property sets", (Throwable)e);
        }
        return propertySets;
    }

    @Override
    public String getUserHandle(String email, String password, String region) {
        try {
            Document document = this.scene7APIClient.getUserInfo(email, password, region);
            if (document != null) {
                NodeList list = document.getElementsByTagName("userHandle");
                if (list.getLength() > 0 && list.item(0).getFirstChild() != null) {
                    return list.item(0).getFirstChild().getNodeValue();
                }
            } else {
                LOG.error("getUserHandle, unexpected data format");
            }
        }
        catch (Exception e) {
            LOG.error("getUserHandle failed: ", (Throwable)e);
        }
        return null;
    }

    @Override
    public String getCompanyMembership(String userHandle, String email, String password, String region) {
        try {
            Document document = this.scene7APIClient.getCompanyMembership(userHandle, email, password, region);
            if (document != null) {
                NodeList list = document.getElementsByTagName("items");
                JSONArray companies = new JSONArray();
                for (int i = 0; i < list.getLength(); ++i) {
                    try {
                        JSONObject company = new JSONObject();
                        NodeList nodes = ((Element)list.item(i)).getElementsByTagName("companyHandle");
                        if (nodes.getLength() > 0 && nodes.item(0).getFirstChild() != null) {
                            company.put("handle", (Object)nodes.item(0).getFirstChild().getNodeValue());
                        }
                        if ((nodes = ((Element)list.item(i)).getElementsByTagName("name")).getLength() > 0 && nodes.item(0).getFirstChild() != null) {
                            company.put("name", (Object)nodes.item(0).getFirstChild().getNodeValue());
                        }
                        if ((nodes = ((Element)list.item(i)).getElementsByTagName("rootPath")).getLength() > 0 && nodes.item(0).getFirstChild() != null) {
                            company.put("rootPath", (Object)nodes.item(0).getFirstChild().getNodeValue());
                        }
                        companies.put((Object)company);
                        continue;
                    }
                    catch (JSONException e) {
                        LOG.error("error parsing company item", (Throwable)e);
                    }
                }
                return companies.toString();
            }
            LOG.error("getCompanyMembership, unexpected data format");
        }
        catch (Exception e) {
            LOG.error("getCompanyMembership failed: " + e.getMessage());
        }
        return "failed";
    }

    @Override
    public Scene7Folder getFolderTree(String folderPath, int depth, String[] responseFields, String[] excludeFields, S7Config s7Config) {
        Scene7Folder s7RootFolder = null;
        try {
            Document document = this.scene7APIClient.getFolderTree(folderPath, depth, responseFields, excludeFields, s7Config);
            Scene7FolderFactory folderFactory = new Scene7FolderFactory();
            s7RootFolder = folderFactory.parseScene7Folders(document);
        }
        catch (Exception e) {
            LOG.error("failed to get scene7 folder tree: " + e.getMessage());
        }
        return s7RootFolder;
    }

    @Override
    public String getFolderHandle(String cqFolderPath, S7Config s7Config) {
        NodeList nodes;
        String ipsUploadFilePath = s7Config.getRootPath() + cqFolderPath.replaceAll("^/content/dam/", "");
        Document document = this.scene7APIClient.getFolderTree(ipsUploadFilePath, 0, null, null, s7Config);
        if (document != null && (nodes = document.getElementsByTagName("folderHandle")).getLength() > 0) {
            return nodes.item(0).getFirstChild().getNodeValue();
        }
        return null;
    }

    @Override
    public String deleteFolder(String folderHandle, S7Config s7Config) {
        try {
            this.scene7APIClient.deleteFolder(folderHandle, s7Config);
            return "success";
        }
        catch (Exception e) {
            LOG.error("deleteFolder, failed to delete scene7 folder: " + e.getMessage());
            return "failure";
        }
    }

    @Override
    public List<Scene7Asset> getAssets(String[] assetHandles, String[] responseFields, String[] excludeFields, S7Config s7Config) {
        ArrayList<Scene7Asset> assets = new ArrayList<Scene7Asset>();
        try {
            Document document = this.scene7APIClient.getAssets(assetHandles, responseFields, excludeFields, s7Config);
            if (document != null) {
                Scene7AssetFactory assetFactory = new Scene7AssetFactory();
                assets.addAll(assetFactory.parseAssets(document));
            } else {
                LOG.error("getAssets, unexpected data format");
            }
        }
        catch (Exception e) {
            LOG.error("getAssets, failed to get scene7 assets: " + e.getMessage());
        }
        return assets;
    }

    @Override
    public String deleteAsset(String assetHandle, S7Config s7Config) {
        try {
            this.scene7APIClient.deleteAsset(assetHandle, s7Config);
            return "success";
        }
        catch (Exception e) {
            LOG.error("deleteAssets, failed to delete scene7 asset: " + e.getMessage());
            return "failue";
        }
    }

    @Override
    public List<Scene7Asset> searchAssets(String folder, Boolean includeSubfolders, Boolean published, String[] assetTypes, String[] assetSubTypes, String[] responseFields, String[] excludeFields, S7Config s7Config) {
        ArrayList<Scene7Asset> assets = new ArrayList<Scene7Asset>();
        Scene7AssetFactory assetFactory = new Scene7AssetFactory();
        int resultsPage = 1;
        int recordsPerPage = 1000;
        if (assetTypes != null || assetSubTypes != null || responseFields != null) {
            recordsPerPage = 10000;
        }
        Document document = this.scene7APIClient.searchAssets(folder, includeSubfolders, published, assetTypes, assetSubTypes, responseFields, excludeFields, recordsPerPage, resultsPage, s7Config);
        ++resultsPage;
        assets.addAll(assetFactory.parseAssets(document));
        String totalRowsString = null;
        try {
            totalRowsString = ((Element)document.getElementsByTagName("totalRows").item(0)).getFirstChild().getNodeValue();
        }
        catch (NullPointerException e) {
            totalRowsString = Integer.toString(recordsPerPage);
        }
        Integer totalRows = recordsPerPage;
        try {
            totalRows = new Integer(totalRowsString);
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse totalRows node ({}) to int; using a predetermined value of {}", (Object)totalRowsString, (Object)totalRows);
            totalRows = recordsPerPage;
        }
        int pages = totalRows / recordsPerPage;
        if (totalRows % recordsPerPage > 0) {
            ++pages;
        }
        while (resultsPage <= pages) {
            document = this.scene7APIClient.searchAssets(folder, includeSubfolders, published, assetTypes, assetSubTypes, responseFields, excludeFields, recordsPerPage, resultsPage, s7Config);
            assets.addAll(assetFactory.parseAssets(document));
            ++resultsPage;
        }
        return assets;
    }

    @Override
    public List<Scene7Asset> searchAssetsByMetadata(String folder, Boolean includeSubfolders, String[] assetTypes, String[] assetSubTypes, Boolean published, MetadataCondition[] conditions, S7Config s7Config) {
        Document document = this.scene7APIClient.searchAssetsByMetadata(folder, includeSubfolders, assetTypes, assetSubTypes, published, conditions, s7Config);
        List<Scene7Asset> scene7Assets = new ArrayList<Scene7Asset>();
        if (document != null) {
            Scene7AssetFactory s7af = new Scene7AssetFactory();
            scene7Assets = s7af.parseAssets(document);
        } else {
            LOG.error("searchAssets, unexpected data format");
        }
        return scene7Assets;
    }

    @Override
    public boolean isJobActiveByJobHandle(String jobHandle, S7Config s7Config) {
        Document document = this.getActiveJobs(jobHandle, null, s7Config);
        return this.internalIsJobActive(document);
    }

    @Override
    public boolean isJobActiveByOriginalName(String originalName, S7Config s7Config) {
        Document document = this.getActiveJobs(null, originalName, s7Config);
        return this.internalIsJobActive(document);
    }

    protected Document getActiveJobs(String jobHandle, String originalName, S7Config s7Config) {
        try {
            Document document = this.scene7APIClient.getActiveJobs(jobHandle, originalName, s7Config);
            return document;
        }
        catch (Exception e) {
            LOG.error("getActiveJobs, failed: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getJobLogDetails(String jobHandle, S7Config s7Config) {
        ArrayList<String> assetHandles = new ArrayList<String>();
        Document document = this.scene7APIClient.getJobLogDetails(jobHandle, null, s7Config);
        if (document != null) {
            NodeList list = document.getElementsByTagName("assetHandle");
            for (int i = 0; i < list.getLength(); ++i) {
                Node assetHandleNode = list.item(i);
                assetHandles.add(assetHandleNode.getFirstChild().getNodeValue());
            }
        } else {
            LOG.error("getJobLogDetails, unexpected data format");
        }
        return assetHandles;
    }

    @Override
    public ArrayList<UploadJobDetail> getMultiFileJobLogDetails(String jobHandle, S7Config s7Config) {
        ArrayList<UploadJobDetail> jobDetailList = new ArrayList<UploadJobDetail>();
        Document document = this.scene7APIClient.getJobLogDetails(jobHandle, null, s7Config);
        NodeList detailArrayNode = document.getElementsByTagName("detailArray");
        if (detailArrayNode.getLength() > 0 && detailArrayNode.item(0).getFirstChild() != null) {
            NodeList nodeLst = ((Element)detailArrayNode.item(0)).getElementsByTagName("items");
            if (nodeLst.getLength() > 0) {
                LOG.debug("items length " + nodeLst.getLength());
            }
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1 || !this.isSuccessElement((Element)fstNode) || !this.hasAssetHandleElement((Element)fstNode)) continue;
                jobDetailList.add(new UploadJobDetailImpl((Element)fstNode));
            }
        } else {
            LOG.error("getJobLogDetailsItemElements, unexpected data format");
        }
        return jobDetailList;
    }

    @Override
    public String getPublishServer(S7Config s7Config) {
        String appSettingsTypeHandle = this.getApplicationPropertyHandle(s7Config);
        if (appSettingsTypeHandle == null) {
            return null;
        }
        return this.getPropertyByNodeNameAndTagName(this.scene7APIClient.getPropertySets(appSettingsTypeHandle, s7Config), "application_server_prefix_published", "value");
    }

    private boolean isSuccessElement(Element el) {
        NodeList nodes = el.getElementsByTagName("logType");
        if (nodes.getLength() > 0 && nodes.item(0).getFirstChild() != null) {
            String logTypeValue = nodes.item(0).getFirstChild().getNodeValue();
            LOG.debug("logType: " + logTypeValue);
            if ("FileUpdated".equals(logTypeValue) || "UploadSuccess".equals(logTypeValue) || "UploadWarning".equals(logTypeValue)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasAssetHandleElement(Element el) {
        NodeList nodes = el.getElementsByTagName("assetHandle");
        return nodes.getLength() > 0;
    }

    private boolean internalIsJobActive(Document document) {
        return document != null && document.getElementsByTagName("items").getLength() > 0;
    }

    @Override
    public String uploadFile(String path, String email, String password, String region, String userHandle, String companyHandle, String rootPath, ResourceResolver resolver) {
        throw new UnsupportedOperationException("Deprecated method. Please use the [uploadFile] method from the [Scene7UploadService].");
    }

    @Override
    public String getFlashTemplatesServer(S7Config s7Config) {
        String appSettingsTypeHandle = this.getApplicationPropertyHandle(s7Config);
        if (appSettingsTypeHandle == null) {
            return null;
        }
        return this.getPropertyByNodeNameAndTagName(this.scene7APIClient.getPropertySets(appSettingsTypeHandle, s7Config), "application_server_xfl", "value");
    }

    @Override
    public Scene7Asset getAssociatedAssets(Scene7Asset asset, S7Config s7Config) {
        Document document;
        Scene7AssetFactory assetFactory = new Scene7AssetFactory();
        if (asset != null && (document = this.scene7APIClient.getAssociatedAssets(asset.getAssetHandle(), null, null, s7Config)) != null) {
            asset = assetFactory.parseSubAssets(asset, document);
        }
        return asset;
    }

    @Override
    public String getFxgServer(S7Config s7Config) {
        String fxgServer = null;
        Document document = this.scene7APIClient.getSystemProperties(s7Config);
        if (document != null) {
            NodeList systemProperties = document.getElementsByTagName("systemProperty");
            for (int i = 0; i < systemProperties.getLength(); ++i) {
                Node systemProperty = systemProperties.item(i);
                String propertyName = DOMUtils.getNodeValue((Element)systemProperty, "name");
                if (!"FxgRenderRootUrl".equals(propertyName)) continue;
                fxgServer = DOMUtils.getNodeValue((Element)systemProperty, "value");
            }
        }
        return fxgServer;
    }

    private String getPropertyByNodeNameAndTagName(Document document, String nodeName, String tagName) {
        if (document != null) {
            NodeList list = document.getElementsByTagName("items");
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList valueNodes;
                NodeList namesNodes = ((Element)list.item(i)).getElementsByTagName("name");
                if (namesNodes.getLength() <= 0 || !nodeName.equals(namesNodes.item(0).getFirstChild().getNodeValue()) || (valueNodes = ((Element)list.item(i)).getElementsByTagName(tagName)).getLength() <= 0 || valueNodes.item(0).getFirstChild() == null) continue;
                return valueNodes.item(0).getFirstChild().getNodeValue();
            }
        } else {
            LOG.error(nodeName + ", unexpected data format");
        }
        return null;
    }

    protected void bindScene7APIClient(Scene7APIClient scene7APIClient) {
        this.scene7APIClient = scene7APIClient;
    }

    protected void unbindScene7APIClient(Scene7APIClient scene7APIClient) {
        if (this.scene7APIClient == scene7APIClient) {
            this.scene7APIClient = null;
        }
    }
}

