/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl;

import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import com.day.cq.dam.scene7.api.Scene7FileMetadataService;
import com.day.cq.dam.scene7.api.Scene7Publisher;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.Scene7UploadService;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.api.model.UploadJobDetail;
import com.day.cq.dam.scene7.impl.DAMAssetPartSource;
import com.day.cq.dam.scene7.impl.PublishingJob;
import com.day.cq.dam.scene7.impl.model.FolderAssets;
import com.day.cq.dam.scene7.impl.utils.FolderAssetsUtils;
import com.day.cq.dam.scene7.impl.utils.RequestUtils;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Component
@Service
public class Scene7UploadServiceImpl
implements Scene7UploadService,
ChangeListener {
    private static final int ACTIVE_JOB_TIMEOUT = 0x200B20;
    private static final long ACTIVE_JOB_WAITING_INTERVAL = 10000L;
    private static final int NODE_CHECKED_IN_WAIT = 10000;
    private static final long NODE_CHECKED_IN_WAIT_INTERVAL = 1000L;
    private static final String[] UPLOAD_MIMETYPES = new String[]{"image/", "video/"};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private Scene7Publisher scene7Publisher;
    @Reference
    private Scene7Service scene7Service;
    @Reference
    private S7ConfigResolver s7configResolver;
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;
    @Reference
    private Scene7FileMetadataService scene7FileMetadataService;
    @Reference
    CryptoSupport cryptoSupport;

    protected void activate(ComponentContext context) {
        this.scene7Publisher.addChangeListener(this);
    }

    protected void deactivate(ComponentContext context) {
        this.scene7Publisher.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        PublishingJob job = (PublishingJob)e.getSource();
        if (job.getState() == PublishingJob.State.PUBLISHED) {
            try {
                String mimeType = this.getMimeType(job.resolver, job.path);
                if (mimeType.startsWith("video/")) {
                    this.generateVideoThumb(job.resolver, job.path);
                }
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage());
            }
        }
    }

    @Override
    public String uploadFolder(String path, String cloudServiceConfigPath, ResourceResolver resolver) {
        try {
            S7Config s7Config = this.s7configResolver.getS7Config(cloudServiceConfigPath);
            Node folderNode = (Node)resolver.getResource(path).adaptTo(Node.class);
            Boolean uploadSubFolders = FolderAssetsUtils.isFolderNodeDeepScene7Managed(folderNode);
            int assetsTotal = 0;
            ArrayList<FolderAssets> folderAssetsList = FolderAssetsUtils.getFolderAssetsList(folderNode, uploadSubFolders);
            for (FolderAssets folderAssets : folderAssetsList) {
                Iterator<String> pathIter = folderAssets.getAssets().iterator();
                this.log.debug("folder path " + folderAssets.getFolderNode().getPath());
                while (pathIter.hasNext()) {
                    this.log.debug(" uploadFolder paths " + pathIter.next());
                    ++assetsTotal;
                }
            }
            this.log.debug(" total Assets to upload =  " + assetsTotal);
            if (assetsTotal > 0) {
                String result = this.internalUploadFolder(folderAssetsList, s7Config, resolver);
                if (result.equals("success")) {
                    Map<String, String> s7PublishStatusQueryMap = this.getAssetStatusQueryMap(s7Config.getCompanyHandle(), this.scene7EndpointsManager.getAPIServer(s7Config.getRegion()).toString());
                    this.scene7Publisher.addJob(s7Config, null, s7PublishStatusQueryMap);
                }
                return result;
            }
            this.log.debug("uploadFolder no files found to upload for " + path);
            return "success";
        }
        catch (Exception e) {
            this.log.error("storing scene7 upload metadata to asset (" + path + ") failed", (Object)e.getMessage());
            return "failed";
        }
    }

    private String internalUploadFolder(ArrayList<FolderAssets> folderAssetsList, S7Config s7Config, ResourceResolver resolver) {
        HttpClient client = new HttpClient();
        String result = "failed";
        ArrayList<String> uploadedPaths = new ArrayList<String>();
        String publishedServer = s7Config.getPublishServer();
        if (publishedServer == null) {
            this.log.error("upload failed, unable  to retrieve publishedServer");
            return "failed";
        }
        try {
            Node jcrContent;
            SimpleDateFormat ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss-SSSS");
            String now = ISO8601Local.format(new Date());
            String uploadJobname = "CQ5_folder_upload_" + now;
            String jobHandle = this.startUploadJob(client, uploadJobname, s7Config);
            if (jobHandle.startsWith("failed")) {
                this.log.error("upload failed, unable  to start upload job");
                return jobHandle;
            }
            HashMap<String, String> filePathUploadNameMap = new HashMap<String, String>();
            for (FolderAssets folder : folderAssetsList) {
                for (String path : folder.getAssets()) {
                    String ipsUploadFilePath = s7Config.getRootPath() + path.replaceAll(s7Config.getTargetPath(), "");
                    filePathUploadNameMap.put(path, ipsUploadFilePath);
                    String ipsRootPath = ipsUploadFilePath.substring(0, ipsUploadFilePath.lastIndexOf("/") + 1);
                    String uploadFilename = ipsUploadFilePath.substring(ipsUploadFilePath.lastIndexOf("/") + 1);
                    jcrContent = (Node)resolver.getResource(path + "/jcr:content/metadata").adaptTo(Node.class);
                    this.setS7FileStatusProp("UploadStart", jcrContent);
                    String uploadResult = this.doUploadJob(client, jobHandle, path, ipsRootPath, resolver, true, uploadFilename, uploadJobname, s7Config);
                    uploadedPaths.add(path);
                    this.log.debug("uploadFolderFiles path " + path + " " + uploadResult);
                }
            }
            result = this.finishUploadJob(client, jobHandle, uploadJobname, s7Config);
            if (result.equals("success")) {
                ArrayList<UploadJobDetail> jobDetailsList = this.scene7Service.getMultiFileJobLogDetails(jobHandle, s7Config);
                for (String path : uploadedPaths) {
                    String assetHandle = this.getAssetHandle(jobDetailsList, (String)filePathUploadNameMap.get(path));
                    Resource damAssetResource = resolver.getResource(path);
                    Asset damAsset = (Asset)damAssetResource.adaptTo(Asset.class);
                    jcrContent = this.getOrAddMetadataNode(path, resolver);
                    if (!assetHandle.startsWith("failed")) {
                        Scene7Asset asset = this.getScene7Asset(assetHandle, s7Config);
                        this.setAssetMetadataOnSync(jcrContent, damAsset, asset, s7Config, "PublishQueued");
                        continue;
                    }
                    this.setS7FileStatusProp("UploadFailed", jcrContent);
                }
            } else {
                this.log.debug("uploadFolderFiles job completion failed");
                result = "failed";
                this.batchSetS7StatusProps(folderAssetsList, "UploadFailed", resolver);
            }
        }
        catch (Exception e) {
            this.log.error("uploadFolderFiles failed", (Object)e.getMessage());
            result = "failed";
            this.batchSetS7StatusProps(folderAssetsList, "UploadFailed", resolver);
        }
        return result;
    }

    @Override
    public String uploadFile(String path, String cloudServiceConfigPath, ResourceResolver resolver) {
        S7Config s7Config = this.s7configResolver.getS7Config(cloudServiceConfigPath);
        HttpClient client = new HttpClient();
        this.log.debug("Cloud Service Config Path = " + cloudServiceConfigPath);
        String publishedServer = s7Config.getPublishServer();
        if (publishedServer == null) {
            this.log.error("upload failed, unable  to retrieve publishedServer");
            return "failed";
        }
        if (path.indexOf("renditions/") != -1) {
            path = path.substring(0, path.indexOf("/jcr:content"));
        }
        Resource damAssetResource = resolver.getResource(path);
        Asset damAsset = (Asset)damAssetResource.adaptTo(Asset.class);
        Node jcrContent = (Node)resolver.getResource(path + "/jcr:content/metadata").adaptTo(Node.class);
        String result = "failed";
        try {
            String mimeType = this.getMimeType(resolver, path);
            if (!this.isTypeSupported(mimeType)) {
                this.setS7FileStatusProp("NotSupported", jcrContent);
                this.log.error("upload failed, type not supported: " + mimeType);
                return "failed";
            }
            String uploadFilename = path.substring(path.lastIndexOf("/") + 1);
            String uploadJobname = "CQ5_upload-" + uploadFilename;
            String ipsRootPath = null;
            S7Config resourceConfig = this.s7configResolver.getS7ConfigForResource(damAssetResource);
            if (resourceConfig != null && path.startsWith(resourceConfig.getTargetPath())) {
                String ipsUploadFilePath = path.replaceAll(s7Config.getTargetPath(), "");
                ipsRootPath = s7Config.getRootPath() + ipsUploadFilePath.substring(0, ipsUploadFilePath.lastIndexOf("/") + 1);
            } else {
                String ipsUploadFilePath = uploadFilename;
                ipsRootPath = s7Config.getAdhocFolder();
            }
            String jobHandle = this.startUploadJob(client, uploadJobname, s7Config);
            if (jobHandle.startsWith("failed")) {
                this.log.error("upload failed, unable  to start upload job");
                return jobHandle;
            }
            this.setS7FileStatusProp("UploadStart", jcrContent);
            this.doUploadJob(client, jobHandle, path, ipsRootPath, resolver, true, uploadFilename, uploadJobname, s7Config);
            result = this.finishUploadJob(client, jobHandle, uploadJobname, s7Config);
            if (result.equals("success")) {
                String assetHandle = this.getAssetHandle(jobHandle, s7Config);
                if (StringUtils.isNotBlank((String)assetHandle)) {
                    Scene7Asset asset = this.getScene7Asset(assetHandle, s7Config);
                    this.setAssetMetadataOnSync(jcrContent, damAsset, asset, s7Config, "PublishQueued");
                    Map<String, String> s7PublishStatusQueryMap = this.getAssetStatusQueryMap(s7Config.getCompanyHandle(), this.scene7EndpointsManager.getAPIServer(s7Config.getRegion()).toString());
                    this.scene7Publisher.addJob(s7Config, path, s7PublishStatusQueryMap);
                } else {
                    this.setS7FileStatusProp("UploadFailed", jcrContent);
                }
            }
        }
        catch (Exception e) {
            this.log.error("scene7 upload asset (" + path + ") failed", (Object)e.getMessage());
            this.clearS7NodeProps(jcrContent);
        }
        return result;
    }

    @Override
    public String moveFolder(String dstPath, String srcPath, ResourceResolver resolver) {
        try {
            Node dstNode = (Node)resolver.getResource(dstPath).adaptTo(Node.class);
            if (dstPath == null || srcPath == null) {
                return "failed";
            }
            this.deleteSrcFolderPath(dstPath, srcPath, true, resolver);
            if (FolderAssetsUtils.folderNodeHasSetForDeepPublish(dstNode)) {
                String cloudServiceConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(dstNode);
                if (this.isScene7CloudConfigSyncEnabled(cloudServiceConfigPath)) {
                    this.uploadFolder(dstPath, cloudServiceConfigPath, resolver);
                }
            } else if (FolderAssetsUtils.isFolderNodeDeepScene7Managed(dstNode)) {
                String cloudServiceConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(dstNode);
                if (this.isScene7CloudConfigSyncEnabled(cloudServiceConfigPath)) {
                    FolderAssetsUtils.setFolderNodeForDeepPublish(dstNode, "true", resolver);
                    this.uploadFolder(dstPath, cloudServiceConfigPath, resolver);
                    FolderAssetsUtils.setFolderNodeForDeepPublish(dstNode, null, resolver);
                }
            } else {
                String srcParentPath = StringUtils.substringBeforeLast((String)srcPath, (String)"/");
                Node srcParentNode = (Node)resolver.getResource(srcParentPath).adaptTo(Node.class);
                if (FolderAssetsUtils.isFolderNodeDeepScene7Managed(srcParentNode)) {
                    String cloudServiceConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(srcParentNode);
                    if (this.isScene7CloudConfigSyncEnabled(cloudServiceConfigPath)) {
                        FolderAssetsUtils.setFolderNodeForDeepPublish(dstNode, "true", resolver);
                        this.uploadFolder(dstPath, cloudServiceConfigPath, resolver);
                    }
                } else {
                    long timestamp = System.currentTimeMillis();
                    ArrayList<FolderAssets> folderAssetsList = FolderAssetsUtils.getFolderAssetsList(dstNode, true);
                    for (FolderAssets folderAssets : folderAssetsList) {
                        String cloudServiceConfigPath;
                        Node folderNode = folderAssets.getFolderNode();
                        if (!FolderAssetsUtils.nodeHasScene7CloudConfig(folderNode) || !this.isScene7CloudConfigSyncEnabled(cloudServiceConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(folderNode))) continue;
                        this.uploadFolder(folderNode.getPath(), cloudServiceConfigPath, resolver);
                    }
                    this.batchSyncFilesByDate(dstPath, timestamp, resolver);
                }
            }
        }
        catch (Exception e) {
            this.log.error("synchronizeFolder failed for (" + dstPath + ") failed ", (Throwable)e);
        }
        return "failed";
    }

    private void deleteSrcFolderPath(String dstPath, String srcPath, boolean checkCloudConfigEnabled, ResourceResolver resolver) {
        try {
            String folderHandle;
            Node dstNode = (Node)resolver.getResource(dstPath).adaptTo(Node.class);
            String srcParentPath = StringUtils.substringBeforeLast((String)srcPath, (String)"/");
            Node srcParentNode = (Node)resolver.getResource(srcParentPath).adaptTo(Node.class);
            String cloudConfigPath = null;
            if (FolderAssetsUtils.nodeHasScene7CloudConfig(dstNode)) {
                cloudConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(dstNode);
            } else if (FolderAssetsUtils.isFolderNodeDeepScene7Managed(srcParentNode)) {
                cloudConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(srcParentNode);
            }
            if (cloudConfigPath != null && (!checkCloudConfigEnabled || checkCloudConfigEnabled && this.isScene7CloudConfigSyncEnabled(cloudConfigPath)) && (folderHandle = this.scene7Service.getFolderHandle(srcPath, this.s7configResolver.getS7Config(cloudConfigPath))) != null) {
                this.scene7Service.deleteFolder(folderHandle, this.s7configResolver.getS7Config(cloudConfigPath));
            }
        }
        catch (Exception e) {
            this.log.error("error processing deleteSrcPath: ", (Throwable)e);
        }
    }

    @Override
    public String moveFile(String dstPath, ResourceResolver resolver) {
        String assetHandle = null;
        Node node = (Node)resolver.getResource(dstPath).adaptTo(Node.class);
        Node jcrContent = (Node)resolver.getResource(dstPath + "/jcr:content/metadata").adaptTo(Node.class);
        try {
            if (jcrContent.hasProperty("dam:scene7ID")) {
                assetHandle = jcrContent.getProperty("dam:scene7ID").getString();
            }
            if (assetHandle != null) {
                String cloudConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(node);
                if (cloudConfigPath != null && this.isScene7CloudConfigSyncEnabled(cloudConfigPath)) {
                    this.scene7Service.deleteAsset(assetHandle, this.s7configResolver.getS7Config(cloudConfigPath));
                }
                return this.synchronizeFile(dstPath, resolver);
            }
        }
        catch (Exception e) {
            this.log.error("Error accessing S7 ref to metadata Scene7 Asset ID", (Object)e.getMessage());
        }
        return "failed";
    }

    @Override
    public String synchronizeFile(String path, ResourceResolver resolver) {
        try {
            String cloudServiceConfigPath;
            Node node = (Node)resolver.getResource(path).adaptTo(Node.class);
            if (FolderAssetsUtils.isAssetNodeScene7Managed(node) && this.isScene7CloudConfigSyncEnabled(cloudServiceConfigPath = FolderAssetsUtils.getScene7CloudConfigPath(node))) {
                return this.uploadFile(path, cloudServiceConfigPath, resolver);
            }
        }
        catch (Exception e) {
            this.log.error("retrieving cloud config path for (" + path + ") failed ", (Throwable)e);
        }
        return "failed";
    }

    private boolean isScene7CloudConfigSyncEnabled(String cloudConfigPath) {
        try {
            S7Config s7Config = this.s7configResolver.getS7Config(cloudConfigPath);
            return "on".equals(s7Config.isSyncEnabled());
        }
        catch (Exception e) {
            this.log.error("isNodeScene7Managed failed with ", (Object)e.getMessage());
            return false;
        }
    }

    private Node getOrAddMetadataNode(String path, ResourceResolver resolver) throws RepositoryException {
        Node node = (Node)resolver.getResource(path).adaptTo(Node.class);
        return FolderAssetsUtils.getOrAddNode(node, "jcr:content/metadata", "nt:unstructured");
    }

    private void batchSyncFilesByDate(String searchPath, long publishTime, ResourceResolver resolver) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", searchPath);
            map.put("daterange.property", "dam:scene7UploadTimeStamp");
            map.put("daterange.upperBound", Long.toString(publishTime));
            map.put("3_property", "dam:scene7FileStatus");
            map.put("3_property.value", "PublishComplete");
            Session session = (Session)resolver.adaptTo(Session.class);
            Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
            query.setHitsPerPage(0L);
            query.setStart(0L);
            SearchResult result = query.getResult();
            this.log.debug("batchSyncFilesByDate - pending matches ", (Object)result.getTotalMatches());
            for (Hit hit : result.getHits()) {
                String path = "";
                try {
                    path = hit.getPath();
                    String assetPath = StringUtils.substringBefore((String)path, (String)"/jcr:content");
                    this.synchronizeFile(assetPath, resolver);
                }
                catch (Exception e) {
                    this.log.error("Exception when during batch synchronization of s7 files " + path, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error("s7 batch synchronization of s7 files failed ", (Object)e.getMessage());
        }
    }

    private Scene7Asset getScene7Asset(String assetHandle, S7Config s7Config) {
        try {
            List<Scene7Asset> assets = this.scene7Service.getAssets(new String[]{assetHandle}, null, null, s7Config);
            if (assets.size() > 0) {
                Scene7Asset scene7Asset = assets.get(0);
                if (scene7Asset.isPublished()) {
                    this.log.debug("image is available at /is/" + scene7Asset.getAssetTypeStr().toLowerCase() + "/" + scene7Asset.getName());
                    return scene7Asset;
                }
                this.log.debug("image is not yet published");
            }
        }
        catch (Exception e) {
            this.log.error("getAssetPublishPath, failed to get scene7 assets: " + e.getMessage());
        }
        return null;
    }

    private void batchSetS7StatusProps(ArrayList<FolderAssets> folderAssetsList, String status, ResourceResolver resolver) {
        Iterator<FolderAssets> folderIter = folderAssetsList.iterator();
        while (folderIter.hasNext()) {
            try {
                FolderAssets folder = folderIter.next();
                Iterator<String> pathIter = folder.getAssets().iterator();
                while (pathIter.hasNext()) {
                    Node jcrContent = (Node)resolver.getResource(pathIter.next() + "/jcr:content/metadata").adaptTo(Node.class);
                    try {
                        this.setS7FileStatusProp(status, jcrContent);
                    }
                    catch (Exception e) {
                        this.log.error("clearing asset properties failed.", (Object)e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.log.error("clearing asset properties failed.", (Object)e.getMessage());
            }
        }
    }

    private void clearS7NodeProps(Node jcrContent) {
        try {
            this.waitOnNodeAvailability(jcrContent);
            if (jcrContent.hasProperty("dam:scene7Name")) {
                jcrContent.setProperty("dam:scene7Name", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7Type")) {
                jcrContent.setProperty("dam:scene7Type", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7ID")) {
                jcrContent.setProperty("dam:scene7ID", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7FileStatus")) {
                jcrContent.setProperty("dam:scene7FileStatus", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7CompanyID")) {
                jcrContent.setProperty("dam:scene7CompanyID", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7Folder")) {
                jcrContent.setProperty("dam:scene7Folder", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7Domain")) {
                jcrContent.setProperty("dam:scene7Domain", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7UploadTimeStamp")) {
                jcrContent.setProperty("dam:scene7UploadTimeStamp", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7LastModified")) {
                jcrContent.setProperty("dam:scene7LastModified", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7APIServer")) {
                jcrContent.setProperty("dam:scene7APIServer", (String)null);
            }
            if (jcrContent.hasProperty("dam:scene7CloudConfigPath")) {
                jcrContent.setProperty("dam:scene7CloudConfigPath", (String)null);
            }
            jcrContent.getSession().save();
        }
        catch (Exception e) {
            this.log.error("clearing asset properties failure Ignored", (Object)e.getMessage());
        }
    }

    private void setS7FileStatusProp(String status, Node jcrContent) throws Exception {
        try {
            this.waitOnNodeAvailability(jcrContent);
            jcrContent.setProperty("dam:scene7FileStatus", status);
            jcrContent.getSession().save();
        }
        catch (VersionException e) {
            this.log.error("setS7FileStatusProps failure (ignored) to write out PN_S7_FILE_STATUS " + status + " for " + jcrContent.getPath() + " " + e.getMessage());
        }
    }

    private void setAssetMetadataOnSync(Node jcrContent, Asset damAsset, Scene7Asset asset, S7Config s7Config, String status) throws Exception {
        try {
            this.waitOnNodeAvailability(jcrContent);
            jcrContent.setProperty("dam:scene7UploadTimeStamp", Calendar.getInstance());
            this.scene7FileMetadataService.setAssetMetadataOnSync(damAsset, asset, s7Config, status);
            this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7ImportProcessed", String.valueOf(true));
            jcrContent.getSession().save();
        }
        catch (VersionException e) {
            this.log.error("setS7FileUploadTimestampProp  (ignored) failed to write out PN_S7_UPLOAD_TIMESTAMP for " + jcrContent.getPath() + " " + e.getMessage());
        }
    }

    private Map<String, String> getAssetStatusQueryMap(String companyHandle, String apiServer) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1_property", "dam:scene7CompanyID");
        map.put("1_property.value", companyHandle);
        map.put("2_property", "dam:scene7APIServer");
        map.put("2_property.value", apiServer);
        return map;
    }

    /*
     * Exception decompiling
     */
    private synchronized Boolean waitOnNodeAvailability(Node jcrNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized String waitOnUploadJobComplete(String jobHandle, S7Config s7Config) {
        long start = System.currentTimeMillis();
        while (this.scene7Service.isJobActiveByJobHandle(jobHandle, s7Config)) {
            try {
                if (System.currentTimeMillis() - start > 0x200B20L) {
                    this.log.warn("Timed out waiting for active Scene7 upload job complete");
                    return "failed";
                }
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                this.log.error("error waiting for Scene7 upload job to complete", (Throwable)e);
                return "failed";
            }
        }
        this.log.debug("Scene7 upload job completed");
        return "success";
    }

    protected String startUploadJob(HttpClient client, String uploadJobname, S7Config s7Config) {
        try {
            URL ipsServerURL = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion());
            int ipsServerPort = ipsServerURL.getPort() == -1 ? 80 : ipsServerURL.getPort();
            PostMethod request = new PostMethod(ipsServerURL + "/scene7/IPSAccessServlet" + "?threadClass=com.scene7.upload.UploadThread" + "&companyHandle=" + URIUtil.encodeQuery((String)s7Config.getCompanyHandle()));
            client.getParams().setAuthenticationPreemptive(true);
            String password = this.cryptoSupport.unprotect(s7Config.getPassword());
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(s7Config.getEmail(), password);
            client.getState().setCredentials(new AuthScope(ipsServerURL.getHost(), ipsServerPort, AuthScope.ANY_REALM), (Credentials)creds);
            String data = "uploadStarted=true&email=" + URIUtil.encodeQuery((String)s7Config.getEmail()) + "&job=" + uploadJobname + "&userHandle=" + URIUtil.encodeQuery((String)s7Config.getUserHandle());
            request.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/x-www-form-urlencoded", "UTF-8"));
            client.executeMethod((HttpMethod)request);
            String responseBody = IOUtils.toString((InputStream)request.getResponseBodyAsStream());
            this.log.debug(responseBody);
            Document document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody));
            if (document != null) {
                NodeList jobs = document.getElementsByTagName("job");
                if (jobs.getLength() > 0) {
                    Element job = (Element)jobs.item(0);
                    return job.getAttribute("handle");
                }
                NodeList exceptions = document.getElementsByTagName("exception");
                if (exceptions.getLength() > 0) {
                    this.log.error("error while starting scene7 job: " + ((Element)exceptions.item(0)).getAttribute("value"));
                    return "failed: " + ((Element)exceptions.item(0)).getAttribute("value");
                }
            }
        }
        catch (Exception e) {
            this.log.error("error while processing scene7 start job", (Throwable)e);
            return "failed: " + e.getMessage();
        }
        return "failed";
    }

    protected String doUploadJob(HttpClient client, String jobHandle, String path, String rootPath, ResourceResolver resolver, boolean doPublish, String uploadFilename, String uploadJobname, S7Config s7Config) {
        try {
            String[] propNames;
            URL ipsServerURL = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion());
            int ipsServerPort = ipsServerURL.getPort() == -1 ? 80 : ipsServerURL.getPort();
            PostMethod request = new PostMethod(ipsServerURL + "/scene7/IPSAccessServlet" + "?threadClass=com.scene7.upload.UploadThread" + "&companyHandle=" + URIUtil.encodeQuery((String)s7Config.getCompanyHandle()));
            client.getParams().setAuthenticationPreemptive(true);
            String password = this.cryptoSupport.unprotect(s7Config.getPassword());
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(s7Config.getEmail(), password);
            client.getState().setCredentials(new AuthScope(ipsServerURL.getHost(), ipsServerPort, AuthScope.ANY_REALM), (Credentials)creds);
            this.log.debug("doUploadJob for path = " + path);
            Asset asset = (Asset)resolver.getResource(path).adaptTo(Asset.class);
            String encodingPresets = "";
            String encValue = null;
            for (String propName : propNames = new String[]{"adaptiveVideoEncodingPresets", "desktopVideoEncodingPresets", "mobileVideoEncodingPresets", "tabletVideoEncodingPresets"}) {
                encValue = s7Config.get(propName);
                if (encValue == null || encValue.length() <= 0) continue;
                encodingPresets = encodingPresets + (encodingPresets != "" ? "," : "") + encValue;
            }
            Properties props = new Properties(this.getDefaultOptions());
            if (encodingPresets.length() > 0) {
                props.put("videoEncodingPresets", encodingPresets);
            }
            ArrayList<Object> parts = new ArrayList<Object>();
            parts.add(new StringPart("email", URIUtil.encodeQuery((String)s7Config.getEmail())));
            parts.add(new StringPart("userHandle", URIUtil.encodeQuery((String)s7Config.getUserHandle())));
            parts.add(new StringPart("job", URIUtil.encodeQuery((String)uploadJobname)));
            parts.add(new StringPart("jobHandle", URIUtil.encodeQuery((String)jobHandle)));
            parts.add(new StringPart("strPath", URIUtil.encodeQuery((String)rootPath)));
            parts.add(new StringPart("filename", URIUtil.encodeQuery((String)uploadFilename)));
            parts.add(new StringPart("publish", Boolean.toString(doPublish)));
            Set<String> names = props.stringPropertyNames();
            for (String key : names) {
                String value = props.getProperty(key);
                if (value == null) continue;
                parts.add(new StringPart(key, value));
            }
            parts.add(new FilePart("file", (PartSource)new DAMAssetPartSource(asset)));
            Part[] partsArr = new Part[parts.size()];
            parts.toArray(partsArr);
            request.setRequestEntity((RequestEntity)new MultipartRequestEntity(partsArr, request.getParams()));
            request.setContentChunked(Boolean.TRUE.booleanValue());
            client.executeMethod((HttpMethod)request);
            String responseBody = IOUtils.toString((InputStream)request.getResponseBodyAsStream());
            this.log.debug(responseBody);
            Document document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody));
            if (document != null) {
                NodeList exceptions = document.getElementsByTagName("exception");
                if (exceptions.getLength() > 0) {
                    this.log.error("error while doing scene7 job: " + ((Element)exceptions.item(0)).getAttribute("value"));
                    return "failed: " + ((Element)exceptions.item(0)).getAttribute("value");
                }
                return "success";
            }
        }
        catch (Exception e) {
            this.log.error("error while processing scene7 do upload job", (Throwable)e);
            return "failed" + e.getMessage();
        }
        return "failed";
    }

    private Properties getDefaultOptions() {
        Properties props = new Properties();
        props.setProperty("overwrite", "true");
        props.setProperty("maintainLayers", "true");
        props.setProperty("layerNaming", "layerName");
        return props;
    }

    protected String finishUploadJob(HttpClient client, String jobHandle, String uploadJobname, S7Config s7Config) {
        try {
            URL ipsServerURL = this.scene7EndpointsManager.getIPSServer(s7Config.getRegion());
            int ipsServerPort = ipsServerURL.getPort() == -1 ? 80 : ipsServerURL.getPort();
            PostMethod request = new PostMethod(ipsServerURL + "/scene7/IPSAccessServlet" + "?threadClass=com.scene7.upload.UploadThread" + "&companyHandle=" + URIUtil.encodeQuery((String)s7Config.getCompanyHandle()));
            client.getParams().setAuthenticationPreemptive(true);
            String password = this.cryptoSupport.unprotect(s7Config.getPassword());
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(s7Config.getEmail(), password);
            client.getState().setCredentials(new AuthScope(ipsServerURL.getHost(), ipsServerPort, AuthScope.ANY_REALM), (Credentials)creds);
            String data = "uploadFinished=true&email=" + URIUtil.encodeQuery((String)s7Config.getEmail()) + "&job=" + uploadJobname + "&userHandle=" + URIUtil.encodeQuery((String)s7Config.getUserHandle()) + "&jobHandle=" + URIUtil.encodeQuery((String)jobHandle);
            request.setRequestEntity((RequestEntity)new StringRequestEntity(data, "application/x-www-form-urlencoded", "UTF-8"));
            client.executeMethod((HttpMethod)request);
            String responseBody = IOUtils.toString((InputStream)request.getResponseBodyAsStream());
            this.log.debug(responseBody);
            Document document = RequestUtils.getResponseDOM(IOUtils.toInputStream((String)responseBody));
            if (document != null) {
                NodeList exceptions = document.getElementsByTagName("exception");
                if (exceptions.getLength() > 0) {
                    this.log.error("error while finishing scene7 job: " + ((Element)exceptions.item(0)).getAttribute("value"));
                    return "failed: " + ((Element)exceptions.item(0)).getAttribute("value");
                }
                return this.waitOnUploadJobComplete(jobHandle, s7Config);
            }
        }
        catch (Exception e) {
            this.log.error("error while processing scene7 finish job", (Throwable)e);
            return "failed: " + e.getMessage();
        }
        return "success";
    }

    private String getAssetHandle(String jobHandle, S7Config s7Config) {
        String assetHandle = "";
        List<String> assetHandles = this.scene7Service.getJobLogDetails(jobHandle, s7Config);
        if (assetHandles.size() > 0) {
            assetHandle = assetHandles.get(0);
            return assetHandle;
        }
        return assetHandle;
    }

    private String getAssetHandle(ArrayList<UploadJobDetail> jobDetailsList, String fileName) {
        if (jobDetailsList.size() > 0) {
            for (int i = jobDetailsList.size() - 1; i >= 0; --i) {
                UploadJobDetail detail = jobDetailsList.get(i);
                if (!StringUtils.containsIgnoreCase((String)detail.getLogMessage(), (String)fileName)) continue;
                return detail.getAssetHandle();
            }
        }
        return "failed";
    }

    private String getMimeType(ResourceResolver resolver, String path) throws RepositoryException {
        Node original = (Node)resolver.getResource(path + "/jcr:content/renditions/original/jcr:content").adaptTo(Node.class);
        String mimeType = original.getProperty("jcr:mimeType").getString();
        return mimeType;
    }

    private boolean isTypeSupported(String mimeType) {
        for (String element : UPLOAD_MIMETYPES) {
            if (!mimeType.startsWith(element)) continue;
            return true;
        }
        return false;
    }

    private void generateVideoThumb(ResourceResolver resolver, String path) {
        Node metaNode = (Node)resolver.getResource(path + "/" + "jcr:content" + "/" + "metadata").adaptTo(Node.class);
        Node renditionsNode = (Node)resolver.getResource(path + "/" + "jcr:content" + "/" + "renditions").adaptTo(Node.class);
        try {
            Session session = (Session)resolver.adaptTo(Session.class);
            String[] sizes = new String[]{"48", "48", "319", "319", "140", "100"};
            String fmtStr = "png";
            for (int i = 0; i < sizes.length; i += 2) {
                String widStr = sizes[i];
                String heiStr = sizes[i + 1];
                URL url = new URL(metaNode.getProperty("dam:scene7Domain").getString() + "is/image/" + metaNode.getProperty("dam:scene7File").getString() + "?wid=" + widStr + "&hei=" + heiStr + "&fmt=" + "png");
                InputStream in = url.openStream();
                Binary bin = session.getValueFactory().createBinary(in);
                String nodeName = "cq5dam.thumbnail." + widStr + "." + heiStr + "." + "png";
                Node thumbNode = null;
                thumbNode = renditionsNode.hasNode(nodeName) ? renditionsNode.getNode(nodeName) : renditionsNode.addNode(nodeName, "nt:file");
                Node contentNode = null;
                contentNode = thumbNode.hasNode("jcr:content") ? thumbNode.getNode("jcr:content") : thumbNode.addNode("jcr:content", "nt:resource");
                contentNode.setProperty("jcr:mimeType", "image/png");
                contentNode.setProperty("jcr:data", bin);
                in.close();
            }
            session.save();
        }
        catch (Exception e) {
            this.log.error("generateVideoThumb: " + e.getMessage());
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindScene7Publisher(Scene7Publisher scene7Publisher) {
        this.scene7Publisher = scene7Publisher;
    }

    protected void unbindScene7Publisher(Scene7Publisher scene7Publisher) {
        if (this.scene7Publisher == scene7Publisher) {
            this.scene7Publisher = null;
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }

    protected void bindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7configResolver = s7ConfigResolver;
    }

    protected void unbindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7configResolver == s7ConfigResolver) {
            this.s7configResolver = null;
        }
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }

    protected void bindScene7FileMetadataService(Scene7FileMetadataService scene7FileMetadataService) {
        this.scene7FileMetadataService = scene7FileMetadataService;
    }

    protected void unbindScene7FileMetadataService(Scene7FileMetadataService scene7FileMetadataService) {
        if (this.scene7FileMetadataService == scene7FileMetadataService) {
            this.scene7FileMetadataService = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }
}

