/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.scene7.api.S7Config;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportJobUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ImportJobUtils.class);

    public static Queue getImportJobQueue(S7Config s7Config, JobManager jobManager) {
        String queueName;
        Queue importQueue = null;
        if (s7Config != null && jobManager != null && StringUtils.isNotEmpty((String)(queueName = s7Config.getImportQueueName()))) {
            importQueue = jobManager.getQueue(queueName);
        }
        if (importQueue == null) {
            LOG.warn("Could not get a handle to the job import queue for config {}!", (Object)s7Config.getCloudConfigPath());
        }
        return importQueue;
    }

    public static boolean isImportQueueSuspended(S7Config s7Config, JobManager jobManager) {
        boolean isSuspended = false;
        Queue importQueue = ImportJobUtils.getImportJobQueue(s7Config, jobManager);
        if (importQueue != null && importQueue.isSuspended()) {
            isSuspended = true;
        }
        return isSuspended;
    }
}

