/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.scene7.api.importer.LockAssetUtils;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.dam.scene7.lockassetutils.name", description="%cq.dam.scene7.lockassetutils.description")
@Service
@Properties(value={@Property(name="cq.dam.scene7.import.locktimeout", intValue={180}, label="%cq.dam.scene7.import.locktimeout.label", description="%cq.dam.scene7.import.locktimeout.description")})
public class LockAssetUtilsImpl
implements LockAssetUtils {
    private static final HashMap<String, Lock> assets = new HashMap();
    private static final Logger LOG = LoggerFactory.getLogger(LockAssetUtilsImpl.class);
    static final String SCR_PROP_NAME_LOCK_TIMEOUT = "cq.dam.scene7.import.locktimeout";
    static final int SCR_PROP_DEFAULT_LOCK_TIMEOUT = 180;
    private int timeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockAsset(String assetPath) throws Exception {
        Lock lock = null;
        HashMap<String, Lock> hashMap = assets;
        synchronized (hashMap) {
            lock = assets.get(assetPath);
            if (lock == null) {
                lock = new ReentrantLock();
                assets.put(assetPath, lock);
            }
        }
        if (!lock.tryLock(this.timeout, TimeUnit.SECONDS)) {
            throw new Exception("Unable to obtain lock on " + assetPath + " after a timeout of " + this.timeout + " seconds");
        }
        assets.put(assetPath, lock);
        LOG.debug("Obtained lock for " + assetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAsset(String assetPath) {
        HashMap<String, Lock> hashMap = assets;
        synchronized (hashMap) {
            Lock lock = assets.get(assetPath);
            if (lock != null) {
                assets.remove(assetPath);
                lock.unlock();
                LOG.debug("Removed lock for " + assetPath);
            }
        }
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.timeout = OsgiUtil.toInteger(properties.get(SCR_PROP_NAME_LOCK_TIMEOUT), (int)180);
        if (this.timeout < 0) {
            this.timeout = 180;
        }
    }
}

