/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.thumbnail.ThumbnailConfigImpl;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7APIClient;
import com.day.cq.dam.scene7.api.Scene7FileMetadataService;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.importer.LockAssetUtils;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandler;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandlerLookupService;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.impl.utils.Scene7AssetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class Scene7AbstractImportHandler
implements Scene7ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7AbstractImportHandler.class);
    private static final String SLING_ORDERED_FOLDER = "sling:OrderedFolder";
    @Reference
    protected MimeTypeService mimeTypeService;
    @Reference
    protected Scene7APIClient scene7APIClient;
    @Reference
    protected Scene7ImportHandlerLookupService handlerLookupService;
    @Reference
    protected Scene7FileMetadataService scene7FileMetadataService;
    @Reference
    protected ResourceResolverFactory rrf;
    @Reference(policy=ReferencePolicy.STATIC)
    private AssetStore store;
    @Reference
    protected LockAssetUtils lockAssetUtils;
    private static final Collection<ThumbnailConfig> thumbnailConfigs;

    @Override
    public Asset importSubAsset(Asset asset, Scene7Asset subasset, S7Config s7Config) throws Exception {
        if (asset == null) {
            throw new NullPointerException("Null asset");
        }
        if (s7Config == null) {
            throw new NullPointerException("Null Scene7 configuration");
        }
        InputStream is = this.getAssetFileStream(subasset, s7Config);
        String mimeType = this.mimeTypeService.getMimeType(subasset.getFileName());
        Asset damSubasset = asset.addSubAsset(subasset.getFileName(), mimeType, is);
        if (damSubasset != null) {
            LOG.debug("Successfully imported sub-asset {}", (Object)damSubasset.getPath());
        } else {
            LOG.error("Unable to import sub-asset {} under {}", (Object)subasset.getFileName(), (Object)asset.getPath());
        }
        return damSubasset;
    }

    protected void createThumbnail(Asset asset) {
        AssetHandler handler = this.store.getAssetHandler("image/jpeg");
        try {
            Rendition rendition = asset.getRendition("s7thumbnail.jpeg");
            if (rendition != null) {
                handler.createThumbnails(asset, rendition, thumbnailConfigs);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to create thumbnails for asset " + asset.getPath(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAssetImportFolder(Scene7Asset asset, S7Config s7Config) throws Exception {
        if (asset == null) {
            throw new NullPointerException("Null asset");
        }
        if (s7Config == null) {
            throw new NullPointerException("Null Scene7 configuration");
        }
        String damImportPath = Scene7AssetUtils.getAbsoluteTargetPath(s7Config.getRootPath(), s7Config.getTargetPath(), asset.getFolder());
        ResourceResolver rr = null;
        if (damImportPath != null) {
            if (damImportPath.endsWith("/") && damImportPath.length() > 1) {
                damImportPath = damImportPath.substring(0, damImportPath.length() - 1);
            }
            try {
                rr = this.rrf.getAdministrativeResourceResolver(null);
                Session session = (Session)rr.adaptTo(Session.class);
                JcrUtil.createPath((String)damImportPath, (String)SLING_ORDERED_FOLDER, (String)SLING_ORDERED_FOLDER, (Session)session, (boolean)true);
            }
            finally {
                if (rr != null) {
                    rr.close();
                }
            }
        }
    }

    private boolean newRenditionsAreAvailable(Scene7Asset scene7Asset, Asset damAsset) {
        boolean newRenditionsAreAvailable = false;
        int importedRenditions = 0;
        if (scene7Asset != null && damAsset != null) {
            for (Rendition r : damAsset.getRenditions()) {
                if (!r.getName().startsWith("cq5dam.video.s7")) continue;
                ++importedRenditions;
            }
            if (importedRenditions < scene7Asset.getSubAssets().size()) {
                newRenditionsAreAvailable = true;
            }
        }
        return newRenditionsAreAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Asset createOrUpdateAsset(ResourceResolver rr, S7Config s7Config, Scene7Asset scene7Asset, long s7AssetModifiedTime) throws Exception {
        String targetPath = null;
        Asset damAsset = null;
        targetPath = Scene7AssetUtils.getAbsoluteTargetPath(s7Config.getRootPath(), s7Config.getTargetPath(), this.getImportAsset(scene7Asset).getFolder() + this.getImportAssetFileName(this.getImportAsset(scene7Asset)));
        try {
            this.lockAssetUtils.lockAsset(targetPath);
            AssetManager assetManager = (AssetManager)rr.adaptTo(AssetManager.class);
            if (assetManager != null) {
                Resource damAssetResource = rr.getResource(targetPath);
                if (damAssetResource != null) {
                    damAsset = (Asset)damAssetResource.adaptTo(Asset.class);
                }
                long damAssetScene7LastModifedMetadata = 0L;
                if (damAsset != null) {
                    try {
                        Resource metadataResource = damAssetResource.getChild("jcr:content/metadata");
                        if (metadataResource != null) {
                            ValueMap properties = (ValueMap)metadataResource.adaptTo(ValueMap.class);
                            damAssetScene7LastModifedMetadata = (Long)properties.get("dam:scene7LastModified", Long.class);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Could not determine the last modified date in Scene7 for Asset {}", (Object)damAsset.getPath());
                    }
                }
                boolean isOlderVersion = damAsset != null && damAssetScene7LastModifedMetadata < s7AssetModifiedTime;
                LOG.debug("Asset {} DAM older imported version exists={}", (Object)targetPath, (Object)isOlderVersion);
                if (damAsset == null || isOlderVersion) {
                    InputStream is = this.getAssetFileStream(scene7Asset, s7Config);
                    if (is != null) {
                        String mimeType = this.getAssetMimeType(this.getImportAsset(scene7Asset));
                        damAsset = assetManager.createAsset(targetPath, is, mimeType, false);
                        if (damAsset != null) {
                            String originalPath;
                            damAsset.setBatchMode(true);
                            this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:MIMEtype", mimeType);
                            Long wid = this.getImportMetadataAsset(scene7Asset).getWidth();
                            Long hei = this.getImportMetadataAsset(scene7Asset).getHeight();
                            this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7Width", wid != null ? wid : 250L);
                            this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7Height", hei != null ? hei : 250L);
                            this.scene7FileMetadataService.setAssetMetadataOnSync(damAsset, this.getImportMetadataAsset(scene7Asset), s7Config, "PublishComplete");
                            String originalFile = this.getImportMetadataAsset(scene7Asset).getOriginalFile();
                            if (originalFile != null) {
                                this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7OriginalFile", originalFile);
                            }
                            if ((originalPath = this.getImportMetadataAsset(scene7Asset).getOriginalPath()) != null) {
                                this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7OriginalPath", originalPath);
                            }
                            for (Map.Entry<String, String> entry : scene7Asset.getAssetProperties().entrySet()) {
                                String key = StringUtils.uncapitalize((String)entry.getKey().replaceAll(" ", ""));
                                String value = entry.getValue();
                                this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, key, value);
                            }
                            is = this.scene7APIClient.getThumbnailForAsset(this.getImportMetadataAsset(scene7Asset), s7Config);
                            if (is != null) {
                                damAsset.addRendition("s7thumbnail.jpeg", is, "image/jpeg");
                                this.createThumbnail(damAsset);
                            } else {
                                LOG.error("Unable to create thumnbail for asset " + targetPath);
                            }
                            this.updateAssetMetadata(damAsset, scene7Asset, s7Config);
                        } else {
                            LOG.error("Unable to create asset at " + targetPath);
                        }
                    } else {
                        LOG.error("Received a null input stream from the Scene7 server for asset {} with asset handle {}", (Object)scene7Asset.getName(), (Object)scene7Asset.getAssetHandle());
                    }
                } else if (this.newRenditionsAreAvailable(scene7Asset, damAsset)) {
                    damAsset.setBatchMode(true);
                    this.updateAssetMetadata(damAsset, scene7Asset, s7Config);
                }
                if (damAsset != null) {
                    this.markAsProcessed(damAsset);
                }
            } else {
                LOG.error("Unable to obtain an AssetManager");
            }
            ((Session)rr.adaptTo(Session.class)).save();
        }
        finally {
            try {
                this.lockAssetUtils.unlockAsset(targetPath);
            }
            catch (Exception e) {
                LOG.error("Unable to unlock S7 asset lock for " + targetPath, (Throwable)e);
            }
        }
        return damAsset;
    }

    protected void markAsProcessed(Asset damAsset) {
        if (damAsset != null) {
            try {
                this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7ImportProcessed", String.valueOf(true));
            }
            catch (Exception e) {
                LOG.error("Could not mark DAM asset " + damAsset.getPath() + " as processed!", (Throwable)e);
            }
        }
    }

    protected void updateAssetMetadata(Asset damAsset, Scene7Asset scene7Asset, S7Config s7Config) {
        if (damAsset != null && scene7Asset != null) {
            try {
                this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7PollingImporterMarker", "");
            }
            catch (Exception e) {
                LOG.error("Unable to mark asset " + damAsset.getPath() + " as touched by the Scene7 Polling Importer", (Throwable)e);
            }
        }
    }

    protected Scene7Asset getImportAsset(Scene7Asset scene7Asset) {
        return scene7Asset;
    }

    protected Scene7Asset getImportMetadataAsset(Scene7Asset scene7Asset) {
        return scene7Asset;
    }

    protected String getAssetMimeType(Scene7Asset scene7Asset) {
        return this.mimeTypeService.getMimeType(this.getImportAssetFileName(scene7Asset));
    }

    protected InputStream getAssetFileStream(Scene7Asset scene7Asset, S7Config s7Config) {
        if (Scene7AssetType.IMAGE.equals((Object)scene7Asset.getAssetType())) {
            return this.scene7APIClient.getIPSFile(this.getImportAsset(scene7Asset), s7Config);
        }
        return this.scene7APIClient.getOriginalFile(this.getImportAsset(scene7Asset).getAssetHandle(), s7Config);
    }

    protected String getImportAssetFileName(Scene7Asset scene7Asset) {
        String damFileName = "";
        damFileName = StringUtils.isNotEmpty((String)scene7Asset.getFileName()) ? scene7Asset.getFileName() : scene7Asset.getName();
        return damFileName;
    }

    static {
        ThumbnailConfigImpl config1 = new ThumbnailConfigImpl(140, 100, false);
        ThumbnailConfigImpl config2 = new ThumbnailConfigImpl(48, 48, false);
        ThumbnailConfigImpl config3 = new ThumbnailConfigImpl(319, 319, false);
        thumbnailConfigs = Arrays.asList(config1, config2, config3);
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindScene7APIClient(Scene7APIClient scene7APIClient) {
        this.scene7APIClient = scene7APIClient;
    }

    protected void unbindScene7APIClient(Scene7APIClient scene7APIClient) {
        if (this.scene7APIClient == scene7APIClient) {
            this.scene7APIClient = null;
        }
    }

    protected void bindHandlerLookupService(Scene7ImportHandlerLookupService scene7ImportHandlerLookupService) {
        this.handlerLookupService = scene7ImportHandlerLookupService;
    }

    protected void unbindHandlerLookupService(Scene7ImportHandlerLookupService scene7ImportHandlerLookupService) {
        if (this.handlerLookupService == scene7ImportHandlerLookupService) {
            this.handlerLookupService = null;
        }
    }

    protected void bindScene7FileMetadataService(Scene7FileMetadataService scene7FileMetadataService) {
        this.scene7FileMetadataService = scene7FileMetadataService;
    }

    protected void unbindScene7FileMetadataService(Scene7FileMetadataService scene7FileMetadataService) {
        if (this.scene7FileMetadataService == scene7FileMetadataService) {
            this.scene7FileMetadataService = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindStore(AssetStore assetStore) {
        this.store = assetStore;
    }

    protected void unbindStore(AssetStore assetStore) {
        if (this.store == assetStore) {
            this.store = null;
        }
    }

    protected void bindLockAssetUtils(LockAssetUtils lockAssetUtils) {
        this.lockAssetUtils = lockAssetUtils;
    }

    protected void unbindLockAssetUtils(LockAssetUtils lockAssetUtils) {
        if (this.lockAssetUtils == lockAssetUtils) {
            this.lockAssetUtils = null;
        }
    }
}

