/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandler;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandlerLookupService;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.event.jobs.JobProcessor;
import org.apache.sling.event.jobs.JobUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class Scene7ImportEventHandler
implements EventHandler,
JobProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ImportEventHandler.class);
    public static final String TOPIC = "com/dam/cq/scene7/importer/*";
    private ServiceRegistration eventHandlerRegistration;
    @Reference
    private S7ConfigResolver s7ConfigResolver;
    @Reference
    private Scene7ImportHandlerLookupService handlerLookupService;

    public void handleEvent(Event event) {
        JobUtil.processJob((Event)event, (JobProcessor)this);
    }

    public boolean process(Event job) {
        String s7ConfigPath = (String)job.getProperty("scene7Config");
        S7Config s7Config = this.s7ConfigResolver.getS7Config(s7ConfigPath);
        Scene7Asset scene7Asset = (Scene7Asset)job.getProperty("scene7Asset");
        if (s7Config == null || scene7Asset == null) {
            LOG.error("Received null S7Config or Scene7Asset. Skipping job.");
        } else {
            Scene7ImportHandler importHandler = this.handlerLookupService.getImportHandler(scene7Asset);
            if (importHandler != null) {
                try {
                    importHandler.createAssetImportFolder(scene7Asset, s7Config);
                    importHandler.importAsset(scene7Asset, s7Config);
                }
                catch (Exception e) {
                    LOG.error("Unable to import asset " + scene7Asset.getName(), (Throwable)e);
                }
            } else {
                LOG.error("Could not find handler for asset {} of type {}", (Object)scene7Asset.getName(), (Object)scene7Asset.getAssetType().getValue());
            }
        }
        return true;
    }

    protected void activate(ComponentContext componentContext) {
        Hashtable<String, String> jobEventsDictionary = new Hashtable<String, String>();
        ((Dictionary)jobEventsDictionary).put("event.topics", TOPIC);
        this.eventHandlerRegistration = componentContext.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, jobEventsDictionary);
        LOG.info("Registered for OSGi events on topics={}", (Object)TOPIC);
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
    }

    protected void bindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7ConfigResolver = s7ConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7ConfigResolver == s7ConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }

    protected void bindHandlerLookupService(Scene7ImportHandlerLookupService scene7ImportHandlerLookupService) {
        this.handlerLookupService = scene7ImportHandlerLookupService;
    }

    protected void unbindHandlerLookupService(Scene7ImportHandlerLookupService scene7ImportHandlerLookupService) {
        if (this.handlerLookupService == scene7ImportHandlerLookupService) {
            this.handlerLookupService = null;
        }
    }
}

