/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandler;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandlerLookupService;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.impl.importer.Scene7AbstractImportHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Reference(referenceInterface=Scene7ImportHandler.class, name="importHandler", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
public class Scene7ImportHandlerLookupServiceImpl
implements Scene7ImportHandlerLookupService {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scene7ImportHandlerLookupServiceImpl.class);
    private ComponentContext componentContext;
    private List<ServiceReference> handlerReferences = new CopyOnWriteArrayList<ServiceReference>();

    @Override
    public Scene7ImportHandler getImportHandler(Scene7Asset asset) {
        Scene7AbstractImportHandler importHandler = null;
        Scene7AbstractImportHandler genericImportHandler = null;
        if (asset != null) {
            String assetType = asset.getAssetType().getValue();
            for (ServiceReference importHandlerReference : this.handlerReferences) {
                String importHandlerAssetType = (String)importHandlerReference.getProperty("scene7.asset.type");
                if (importHandlerAssetType.equals(Scene7AssetType.GENERIC.getValue())) {
                    genericImportHandler = (Scene7AbstractImportHandler)this.componentContext.locateService("importHandler", importHandlerReference);
                    LOGGER.debug("Found {} import handler for generic asstes", (Object)genericImportHandler.getClass().getName());
                }
                if (!assetType.equals(importHandlerAssetType)) continue;
                importHandler = (Scene7AbstractImportHandler)this.componentContext.locateService("importHandler", importHandlerReference);
                LOGGER.debug("Found {} import handler for asset of type {}", (Object)importHandler.getClass().getName(), (Object)assetType);
                break;
            }
            if (importHandler == null) {
                importHandler = genericImportHandler;
            }
        } else {
            LOGGER.debug("Cannot locate Scene7ImportHandler for null asset type");
        }
        return importHandler;
    }

    protected void bindImportHandler(ServiceReference ref) {
        this.handlerReferences.add(ref);
    }

    protected void unbindImportHandler(ServiceReference ref) {
        this.handlerReferences.remove(ref);
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        this.componentContext = null;
    }
}

