/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.importer.LockAssetUtils;
import com.day.cq.dam.scene7.api.importer.Scene7ImportService;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.impl.importer.ImportJobUtils;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.Statistics;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.dam.scene7.importservice.name", description="%cq.dam.scene7.importservice.desc")
@Service
@Properties(value={@Property(name="cq.dam.scene7.importservice.excludeassets", description="%cq.dam.scene7.importservice.excludeassets.description", value={"Fxg"}, unbounded=PropertyUnbounded.ARRAY)})
public class Scene7ImportServiceImpl
implements Scene7ImportService {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ImportServiceImpl.class);
    private static final int UNRECOVERABLE_ERROR_STOP_COUNT = 5;
    static final String SCR_PROP_NAME_EXCLUDE_ASSETS = "cq.dam.scene7.importservice.excludeassets";
    static final String[] SCR_PROP_DEFAULT_EXCLUDE_ASSETS = new String[]{"Fxg"};
    private static Map<String, Boolean> importsInProgress = new HashMap<String, Boolean>();
    private String[] excludedAssets;
    private HashSet<String> excludedAssetsSet;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private JobManager slingJobManager;
    @Reference
    private Scene7Service scene7Service;
    @Reference
    private ResourceResolverFactory rrf;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private LockAssetUtils lockAssetUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importAssets(final S7Config s7Config) {
        if (s7Config != null) {
            try {
                String importQueueTopic = s7Config.get("importQueueTopic");
                if (StringUtils.isEmpty((String)importQueueTopic)) {
                    LOG.error("Cannot find a topic for the Scene7 import queue for configuration " + s7Config.getCloudConfigPath() + ". Exiting import process.");
                    return;
                }
                Map<String, Boolean> map = importsInProgress;
                synchronized (map) {
                    block40: {
                        Boolean importInProgress = importsInProgress.get(s7Config.getCloudConfigPath());
                        if (importInProgress == null || !Boolean.TRUE.equals(importInProgress)) break block40;
                        LOG.warn("Import already in progress!");
                        return;
                    }
                    importsInProgress.put(s7Config.getCloudConfigPath(), Boolean.TRUE);
                }
                LOG.info("Started Scene7 import process");
                String rootPath = s7Config.getRootPath();
                List<Scene7Asset> assets = this.scene7Service.searchAssets(rootPath, true, true, null, null, null, null, s7Config);
                HashSet<String> ignoredAssetHandles = new HashSet<String>();
                ArrayList<Scene7Asset> containerAssets = new ArrayList<Scene7Asset>();
                Iterator<Scene7Asset> assetIterator = assets.iterator();
                int assetsToImport = 0;
                String adhocFolder = s7Config.getAdhocFolder();
                if (!adhocFolder.endsWith("/")) {
                    adhocFolder = adhocFolder + "/";
                }
                while (assetIterator.hasNext()) {
                    Scene7Asset asset = assetIterator.next();
                    if (this.excludedAssetsSet.contains(asset.getAssetType().getValue())) {
                        assetIterator.remove();
                        continue;
                    }
                    String assetFolder = asset.getFolder();
                    if (assetFolder != null && assetFolder.startsWith(adhocFolder)) {
                        assetIterator.remove();
                        continue;
                    }
                    if (asset.getAssetType().equals((Object)Scene7AssetType.MBR_SET)) {
                        assetIterator.remove();
                        continue;
                    }
                    if (!this.hasAssociatedAssets(asset) || (asset = this.scene7Service.getAssociatedAssets(asset, s7Config)).getSubAssets().size() <= 0) continue;
                    if (this.importContainerAsset(asset)) {
                        containerAssets.add(asset);
                    }
                    assetIterator.remove();
                    for (Scene7Asset subAsset : asset.getSubAssets()) {
                        ignoredAssetHandles.add(subAsset.getAssetHandle());
                    }
                }
                LOG.debug("Preparing to import {} assets, out of which {} container assets.", (Object)assetsToImport, (Object)containerAssets.size());
                Queue importQueue = ImportJobUtils.getImportJobQueue(s7Config, this.slingJobManager);
                if (importQueue != null) {
                    importQueue.getStatistics().reset();
                }
                for (Scene7Asset asset : containerAssets) {
                    if (ImportJobUtils.isImportQueueSuspended(s7Config, this.slingJobManager)) break;
                    assetsToImport = this.importAsset(asset, s7Config, assetsToImport);
                }
                for (Scene7Asset asset : assets) {
                    if (ignoredAssetHandles.contains(asset.getAssetHandle())) continue;
                    if (ImportJobUtils.isImportQueueSuspended(s7Config, this.slingJobManager)) break;
                    assetsToImport = this.importAsset(asset, s7Config, assetsToImport);
                }
                if (assetsToImport > 0 && !ImportJobUtils.isImportQueueSuspended(s7Config, this.slingJobManager)) {
                    final int totalAssetsToImport = assetsToImport;
                    Runnable jobTopicChecker = new Runnable(){

                        @Override
                        public void run() {
                            boolean finished = false;
                            int errorCount = 0;
                            while (!finished) {
                                try {
                                    Queue importQueue = ImportJobUtils.getImportJobQueue(s7Config, Scene7ImportServiceImpl.this.slingJobManager);
                                    long totalJobs = 0L;
                                    Statistics queueStatistics = null;
                                    if (importQueue != null && (queueStatistics = importQueue.getStatistics()) != null) {
                                        totalJobs = queueStatistics.getNumberOfProcessedJobs();
                                    }
                                    LOG.debug("Total Processed Jobs={}", (Object)totalJobs);
                                    boolean isSuspended = ImportJobUtils.isImportQueueSuspended(s7Config, Scene7ImportServiceImpl.this.slingJobManager);
                                    LOG.debug("Scene7 import queue checker status: totalProcessedJobs={}, null import queue={}, queue suspended={}", new Object[]{totalJobs, importQueue == null, isSuspended});
                                    if (totalJobs >= (long)totalAssetsToImport || importQueue == null || isSuspended) {
                                        finished = true;
                                        if (importQueue != null) {
                                            importQueue.getStatistics().reset();
                                        }
                                    } else {
                                        Thread.sleep(1000L);
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error("Error while waiting for the import process to finish!", (Throwable)e);
                                    ++errorCount;
                                }
                                if (errorCount < 5) continue;
                                LOG.error("Got more than 5 exceptions while waiting for the import process to finish, terminating waiting thread!");
                                finished = true;
                            }
                        }
                    };
                    Thread queueMonitor = new Thread(jobTopicChecker);
                    queueMonitor.start();
                    queueMonitor.join();
                }
                this.deleteUntouchedAssets(s7Config);
                this.deleteEmptyFolders(s7Config);
                this.unmarkProcessedFlag(s7Config);
            }
            catch (Exception e) {
                LOG.error("Error while performing import finish operations!", (Throwable)e);
            }
            finally {
                Map<String, Boolean> map = importsInProgress;
                synchronized (map) {
                    importsInProgress.put(s7Config.getCloudConfigPath(), Boolean.FALSE);
                    LOG.info("Finished Scene7 import process");
                }
            }
        } else {
            LOG.error("Null Scene7 configuration provided");
        }
    }

    private boolean hasAssociatedAssets(Scene7Asset scene7Asset) {
        Scene7AssetType s7AssetType = scene7Asset.getAssetType();
        return s7AssetType.equals((Object)Scene7AssetType.TEMPLATE) || s7AssetType.equals((Object)Scene7AssetType.VIDEO) || s7AssetType.equals((Object)Scene7AssetType.MASTER_VIDEO) || s7AssetType.equals((Object)Scene7AssetType.CATALOG);
    }

    private boolean importContainerAsset(Scene7Asset scene7Asset) {
        return !scene7Asset.getAssetType().equals((Object)Scene7AssetType.CATALOG);
    }

    private int importAsset(Scene7Asset asset, S7Config s7Config, int assetsToImport) {
        try {
            Hashtable<String, Object> jobProps = new Hashtable<String, Object>();
            String eventTopic = s7Config.getImportQueueTopic();
            ((Dictionary)jobProps).put("event.job.topic", eventTopic);
            ((Dictionary)jobProps).put("event.job.retries", 0);
            ((Dictionary)jobProps).put("event.job.parallel", "true");
            ((Dictionary)jobProps).put("scene7Asset", asset);
            ((Dictionary)jobProps).put("scene7Config", s7Config.getCloudConfigPath());
            Event s7AssetImportEvent = new Event("org/apache/sling/event/job", jobProps);
            this.eventAdmin.sendEvent(s7AssetImportEvent);
            ++assetsToImport;
        }
        catch (Exception e) {
            LOG.error("Unable to create asset import folder. Skipping import of asset " + asset.getName(), (Throwable)e);
        }
        return assetsToImport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarkProcessedFlag(S7Config s7Config) {
        block18: {
            ResourceResolver rr = null;
            try {
                rr = this.rrf.getAdministrativeResourceResolver(null);
                Session session = (Session)rr.adaptTo(Session.class);
                if (session == null) break block18;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("path", s7Config.getTargetPath());
                map.put("type", "dam:Asset");
                Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
                SearchResult result = query.getResult();
                List hits = result.getHits();
                Resource resource = null;
                for (Hit hit : hits) {
                    String resourcePath = null;
                    try {
                        resource = hit.getResource();
                        resourcePath = resource.getPath();
                        this.lockAssetUtils.lockAsset(resourcePath);
                        PersistableValueMap properties = (PersistableValueMap)resource.getChild("jcr:content").getChild("metadata").adaptTo(PersistableValueMap.class);
                        properties.remove((Object)"dam:scene7ImportProcessed");
                        properties.save();
                    }
                    catch (Exception e) {
                        LOG.error("Unable to remove dam:scene7ImportProcessed flag from " + resource.getPath(), (Throwable)e);
                        session.refresh(false);
                    }
                    finally {
                        try {
                            this.lockAssetUtils.unlockAsset(resource.getPath());
                        }
                        catch (Exception e) {
                            LOG.error("Unable to unlock S7 asset lock for " + resourcePath, (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unable to remove dam:scene7ImportProcessed flag from imported assets", (Throwable)e);
            }
            finally {
                if (rr != null) {
                    rr.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUntouchedAssets(S7Config s7Config) {
        ResourceResolver rr = null;
        try {
            rr = this.rrf.getAdministrativeResourceResolver(null);
            Session session = (Session)rr.adaptTo(Session.class);
            if (session != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("path", s7Config.getTargetPath());
                map.put("type", "dam:Asset");
                HashMap<String, String> notProcessedMap = new HashMap<String, String>();
                notProcessedMap.put("1_property", "jcr:content/metadata/dam:scene7ImportProcessed");
                notProcessedMap.put("1_property.value", "true");
                HashMap<String, String> scene7AssetsMap = new HashMap<String, String>();
                scene7AssetsMap.put("2_property", "jcr:content/metadata/dam:scene7ID");
                scene7AssetsMap.put("2_property.operation", "exists");
                PredicateGroup predicateGroup = PredicateGroup.create(map);
                PredicateGroup notProcessedPredicate = PredicateGroup.create(notProcessedMap);
                notProcessedPredicate.set("not", "true");
                predicateGroup.add((Predicate)notProcessedPredicate);
                predicateGroup.add((Predicate)PredicateGroup.create(scene7AssetsMap));
                session.refresh(true);
                Query query = this.queryBuilder.createQuery(predicateGroup, session);
                SearchResult result = query.getResult();
                List hits = result.getHits();
                for (Hit hit : hits) {
                    try {
                        String path = hit.getPath();
                        session.removeItem(path);
                        session.save();
                        LOG.info("Removed stale S7 DAM asset {}", (Object)path);
                    }
                    catch (RepositoryException e) {
                        session.refresh(false);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to delete assets no longer existing in Scene7", (Throwable)e);
        }
        finally {
            if (rr != null) {
                rr.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEmptyFolders(S7Config s7Config) {
        ResourceResolver rr = null;
        try {
            rr = this.rrf.getAdministrativeResourceResolver(null);
            Session session = (Session)rr.adaptTo(Session.class);
            if (session != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("path", s7Config.getTargetPath());
                map.put("type", "sling:OrderedFolder");
                Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
                SearchResult result = query.getResult();
                List hits = result.getHits();
                for (Hit hit : hits) {
                    try {
                        Node node = hit.getNode();
                        NodeIterator iterator = node.getNodes();
                        if (iterator.hasNext()) continue;
                        String path = node.getPath();
                        session.removeItem(path);
                        session.save();
                        LOG.info("Removed stale S7 DAM folder {}", (Object)path);
                    }
                    catch (RepositoryException e) {
                        session.refresh(false);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to remove stale folders", (Throwable)e);
        }
        finally {
            if (rr != null) {
                rr.close();
            }
        }
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.excludedAssets = OsgiUtil.toStringArray(properties.get(SCR_PROP_NAME_EXCLUDE_ASSETS), (String[])SCR_PROP_DEFAULT_EXCLUDE_ASSETS);
        this.excludedAssetsSet = new HashSet(this.excludedAssets.length);
        for (int i = 0; i < this.excludedAssets.length; ++i) {
            this.excludedAssetsSet.add(this.excludedAssets[i]);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindSlingJobManager(JobManager jobManager) {
        this.slingJobManager = jobManager;
    }

    protected void unbindSlingJobManager(JobManager jobManager) {
        if (this.slingJobManager == jobManager) {
            this.slingJobManager = null;
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindLockAssetUtils(LockAssetUtils lockAssetUtils) {
        this.lockAssetUtils = lockAssetUtils;
    }

    protected void unbindLockAssetUtils(LockAssetUtils lockAssetUtils) {
        if (this.lockAssetUtils == lockAssetUtils) {
            this.lockAssetUtils = null;
        }
    }
}

