/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.importer.Scene7ImportService;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service
@Properties(value={@Property(name="importer.scheme", value={"scene7"}, propertyPrivate=true)})
public class Scene7Importer
implements Importer {
    static final String IMPORTER_SCHEME = "scene7";
    private static final Logger LOG = LoggerFactory.getLogger(Scene7Importer.class);
    @Reference
    private Scene7ImportService scene7ImportService;
    @Property(boolValue={false})
    private static final String IMPORTER_ENABLED = "cq.dam.scene7.importer.enabled";
    private boolean importerEnabled = false;

    public void importData(String scheme, String dataSource, Resource target) throws ImportException {
        if (this.importerEnabled) {
            LOG.debug("Polling import using scheme = {}, dataSource = {}", (Object)scheme, (Object)dataSource);
            Resource scene7ConfigResource = target.getParent();
            S7Config s7Config = (S7Config)scene7ConfigResource.adaptTo(S7Config.class);
            if (s7Config != null) {
                this.scene7ImportService.importAssets(s7Config);
            }
        } else {
            LOG.debug("Polling importer is disabled");
        }
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext) {
        this.importerEnabled = OsgiUtil.toBoolean(componentContext.getProperties().get(IMPORTER_ENABLED), (boolean)false);
    }

    protected void bindScene7ImportService(Scene7ImportService scene7ImportService) {
        this.scene7ImportService = scene7ImportService;
    }

    protected void unbindScene7ImportService(Scene7ImportService scene7ImportService) {
        if (this.scene7ImportService == scene7ImportService) {
            this.scene7ImportService = null;
        }
    }
}

