/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandler;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.impl.importer.Scene7AbstractImportHandler;
import com.day.cq.dam.scene7.impl.utils.Scene7AssetUtils;
import java.io.InputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.dam.scene7.templateimporthandler.name", description="%cq.dam.scene7.templateimporthandler.description")
@Service(value={Scene7ImportHandler.class})
public class Scene7TemplateImportHandler
extends Scene7AbstractImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7TemplateImportHandler.class);
    @Property(name="scene7.asset.type")
    public static final String SCR_PROP_VALUE_S7_ASSET_TYPE = Scene7AssetType.TEMPLATE.getValue();
    @Reference
    private Scene7Service scene7Service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Asset importAsset(Scene7Asset asset, S7Config s7Config) throws Exception {
        Scene7Asset importAsset;
        Asset damAsset = null;
        if (asset == null) {
            throw new NullPointerException("Null asset");
        }
        if (s7Config == null) {
            throw new NullPointerException("Null Scene7 configuration");
        }
        if (Scene7AssetType.TEMPLATE.equals((Object)asset.getAssetType()) && (importAsset = this.getImportAsset(asset)) != null) {
            ResourceResolver rr = null;
            try {
                rr = this.rrf.getAdministrativeResourceResolver(null);
                damAsset = this.createOrUpdateAsset(rr, s7Config, asset, asset.getModifiedDate().getTime());
            }
            finally {
                if (rr != null) {
                    rr.close();
                }
            }
        }
        return damAsset;
    }

    @Override
    public void createAssetImportFolder(Scene7Asset asset, S7Config s7Config) throws Exception {
        if (asset == null) {
            throw new NullPointerException("Null asset");
        }
        if (s7Config == null) {
            throw new NullPointerException("Null Scene7 configuration");
        }
        if (Scene7AssetType.TEMPLATE.equals((Object)asset.getAssetType())) {
            Scene7Asset importAsset = this.getImportAsset(asset);
            super.createAssetImportFolder(importAsset, s7Config);
        }
    }

    @Override
    protected Scene7Asset getImportAsset(Scene7Asset scene7Asset) {
        Scene7Asset importAsset = scene7Asset;
        if (scene7Asset.getOriginatorAsset() != null) {
            importAsset = scene7Asset.getOriginatorAsset();
        }
        return importAsset;
    }

    @Override
    protected InputStream getAssetFileStream(Scene7Asset scene7Asset, S7Config s7Config) {
        Scene7Asset originator = scene7Asset.getOriginatorAsset();
        InputStream importInputStream = null;
        importInputStream = originator != null ? super.getAssetFileStream(scene7Asset, s7Config) : this.scene7APIClient.getThumbnailForAsset(this.getImportMetadataAsset(scene7Asset), s7Config);
        return importInputStream;
    }

    @Override
    protected void updateAssetMetadata(Asset damAsset, Scene7Asset scene7Asset, S7Config s7Config) {
        super.updateAssetMetadata(damAsset, scene7Asset, s7Config);
        try {
            this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7TemplateParameters", Scene7AssetUtils.extractTemplateParams(scene7Asset.getUrlModifier()));
            scene7Asset = Scene7AssetUtils.extractTemplateSizeInformation(scene7Asset, this.scene7Service, s7Config);
            this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7Width", scene7Asset.getWidth());
            this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7Height", scene7Asset.getHeight());
        }
        catch (Exception e) {
            LOG.error("Unable to update asset metadata for " + damAsset.getPath(), (Throwable)e);
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }
}

