/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.importer;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.importer.Scene7ImportHandler;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.impl.importer.Scene7GenericImportHandler;
import com.day.cq.dam.scene7.impl.rendition.Scene7RenditionProperty;
import java.util.HashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service(value={Scene7ImportHandler.class})
public class Scene7VideoImportHandler
extends Scene7GenericImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7VideoImportHandler.class);
    @Property(name="scene7.asset.type")
    public static final String SCR_PROP_VALUE_S7_ASSET_TYPE = Scene7AssetType.VIDEO.getValue();
    public static final String PROXY_RENDITION_PREFIX = "cq5dam.video.s7";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Asset importAsset(Scene7Asset asset, S7Config s7Config) throws Exception {
        Scene7Asset originator;
        Asset damAsset = null;
        if (asset == null) {
            throw new NullPointerException("Null asset");
        }
        if (s7Config == null) {
            throw new NullPointerException("Null Scene7 configuration");
        }
        if (this.acceptAssetType(asset) && (originator = this.getImportAsset(asset)) != null) {
            ResourceResolver rr = null;
            try {
                rr = this.rrf.getAdministrativeResourceResolver(null);
                long scene7LastModifiedTimeStamp = originator.getModifiedDate().getTime();
                damAsset = this.createOrUpdateAsset(rr, s7Config, asset, scene7LastModifiedTimeStamp);
            }
            finally {
                if (rr != null) {
                    rr.close();
                }
            }
        }
        return damAsset;
    }

    @Override
    protected void updateAssetMetadata(Asset damAsset, Scene7Asset scene7Asset, S7Config s7Config) {
        if (damAsset != null && scene7Asset != null) {
            try {
                this.scene7FileMetadataService.setAssetMetadataProperty(damAsset, "dam:scene7PollingImporterMarker", "");
            }
            catch (Exception e) {
                LOG.error("Unable to mark asset " + damAsset.getPath() + " as touched by the Scene7 Polling Importer", (Throwable)e);
            }
            for (Scene7Asset associatedVideo : scene7Asset.getSubAssets()) {
                String associatedVideMimeType = this.mimeTypeService.getMimeType(associatedVideo.getFileName());
                String associatedVideoUrl = s7Config.getPublishServer() + "e2/" + associatedVideo.getOriginalPath() + associatedVideo.getOriginalFile();
                HashMap<String, String> renditionConfig = new HashMap<String, String>();
                renditionConfig.put("rendition.handler.id", "scene7");
                renditionConfig.put(Scene7RenditionProperty.SCENE7_URL.getPropertyName(), associatedVideoUrl);
                renditionConfig.put(Scene7RenditionProperty.MIME_TYPE.getPropertyName(), associatedVideMimeType);
                renditionConfig.put(Scene7RenditionProperty.SIZE.getPropertyName(), String.valueOf(associatedVideo.getFileSize()));
                renditionConfig.put(Scene7RenditionProperty.ASSET_HANDLE.getPropertyName(), associatedVideo.getAssetHandle());
                renditionConfig.put(Scene7RenditionProperty.SCENE7_TYPE.getPropertyName(), associatedVideo.getAssetType().getValue());
                renditionConfig.put(Scene7RenditionProperty.ENCODING_PRESET_HANDLE.getPropertyName(), associatedVideo.getVideoEncodingPresetId());
                renditionConfig.put(Scene7RenditionProperty.ASSET_HANDLE.getPropertyName(), associatedVideo.getAssetHandle());
                renditionConfig.put(Scene7RenditionProperty.NAME.getPropertyName(), associatedVideo.getName());
                String proxyRenditionName = "cq5dam.video.s7." + associatedVideo.getVideoEncodingPresetId();
                damAsset.addRendition(proxyRenditionName, null, renditionConfig);
            }
        }
    }

    @Override
    protected Scene7Asset getImportAsset(Scene7Asset scene7Asset) {
        return scene7Asset.getOriginatorAsset() != null ? scene7Asset.getOriginatorAsset() : scene7Asset;
    }

    @Override
    protected Scene7Asset getImportMetadataAsset(Scene7Asset scene7Asset) {
        return scene7Asset.getOriginatorAsset() != null ? scene7Asset.getOriginatorAsset() : scene7Asset;
    }

    protected boolean acceptAssetType(Scene7Asset scene7Asset) {
        boolean isAccepted = false;
        if (scene7Asset != null && Scene7AssetType.VIDEO.equals((Object)scene7Asset.getAssetType())) {
            isAccepted = true;
        }
        return isAccepted;
    }
}

