/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.model;

import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.io.InvalidObjectException;

public class S7ConfigImpl
implements S7Config {
    private Configuration configuration;
    private InheritanceValueMap map;
    private String region;
    private String basePath = "";
    private String email;
    private String password;
    private boolean shared;

    public S7ConfigImpl(Configuration configuration) throws InvalidObjectException {
        if (configuration == null) {
            throw new InvalidObjectException("The configuration object cannot be null");
        }
        this.configuration = configuration;
        this.map = configuration.getProperties();
        this.region = (String)this.map.get((Object)"region");
    }

    public S7ConfigImpl(Configuration configuration, boolean shared) throws InvalidObjectException {
        this(configuration);
        this.shared = shared;
    }

    public S7ConfigImpl(String email, String password, String region) throws InvalidObjectException {
        this.email = email;
        this.password = password;
        this.region = region;
    }

    @Override
    public String getCloudConfigPath() {
        return this.configuration.getPath();
    }

    @Override
    public String getEmail() {
        return this.email == null ? (String)this.map.get((Object)"email") : this.email;
    }

    @Override
    public String getPassword() {
        return this.password == null ? (String)this.map.get((Object)"password") : this.password;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getUserHandle() {
        return (String)this.map.get("userHandle", String.class);
    }

    @Override
    public String getCompanyHandle() {
        return this.shared ? "Shared" : (String)this.map.get("companyHandle", String.class);
    }

    @Override
    public String getRootPath() {
        return this.shared ? "Scene7SharedAssets/" : (String)this.map.get("rootPath", String.class);
    }

    @Override
    public String isSyncEnabled() {
        return this.shared ? "off" : (String)this.map.get("syncEnabled", String.class);
    }

    @Override
    public String getBasePath() {
        int index;
        String cqRootPath;
        if (this.basePath.equals("") && (cqRootPath = this.getRootPath()) != null && (index = cqRootPath.indexOf("/")) != -1) {
            this.basePath = cqRootPath.substring(0, index + 1);
        }
        return this.basePath;
    }

    @Override
    public String get(String prop) {
        String value = null;
        value = "email".equals(prop) ? this.getEmail() : ("region".equals(prop) ? this.getRegion() : ("password".equals(prop) ? this.getPassword() : ("companyHandle".equals(prop) ? this.getCompanyHandle() : ("rootPath".equals(prop) ? this.getRootPath() : ("cqRootPath".equals(prop) ? this.getBasePath() : ("userHandle".equals(prop) ? this.getUserHandle() : ("syncEnabled".equals(prop) ? this.isSyncEnabled() : (String)this.map.get(prop, String.class))))))));
        return value;
    }

    @Override
    public InheritanceValueMap getPropertiesMap() {
        return this.map;
    }

    @Override
    public String getPublishServer() {
        return (String)this.map.get("publishServer", String.class);
    }

    @Override
    public String getFlashTemplatesServer() {
        return (String)this.map.get("flashTemplatesServer", String.class);
    }

    @Override
    public String getTargetPath() {
        return (String)this.map.get("targetPath", String.class);
    }

    @Override
    public boolean isDefault() {
        Boolean defaultProperty = (Boolean)this.map.get("defaultConfiguration", (Object)Boolean.FALSE);
        return defaultProperty;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof S7Config) {
            S7Config anotherS7Config = (S7Config)obj;
            return this.getCloudConfigPath().equals(anotherS7Config.getCloudConfigPath());
        }
        return false;
    }

    @Override
    public String getFXGServer() {
        return (String)this.map.get("fxgServer", String.class);
    }

    @Override
    public String getAdhocFolder() {
        return (String)this.map.get("adhocFolder", String.class);
    }

    @Override
    public String getImportQueueName() {
        return (String)this.map.get("importQueueName", String.class);
    }

    @Override
    public String getImportQueueTopic() {
        return (String)this.map.get("importQueueTopic", String.class);
    }
}

