/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7FileMetadataService;
import com.day.cq.dam.scene7.api.Scene7UploadService;
import com.day.cq.dam.scene7.api.importer.LockAssetUtils;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Scene7 Upload"})
public class Scene7UploadProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7UploadProcess.class);
    @Reference
    private Scene7UploadService scene7UploadService;
    @Reference
    private S7ConfigResolver s7ConfigResolver;
    @Reference
    private Scene7FileMetadataService scene7FileMetadataService;
    @Reference
    private LockAssetUtils lockAssetUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        Session session = workflowSession.getSession();
        Resource payloadResource = this.getResourceFromPayload(workItem, session);
        if (payloadResource != null) {
            MetaDataMap workflowMetaDataMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
            ResourceResolver resolver = this.getResourceResolver(session);
            String payloadResourcePath = payloadResource.getPath();
            try {
                session.save();
                if (!this.isFolder(payloadResource)) {
                    this.lockAssetUtils.lockAsset(payloadResourcePath);
                }
                String[] args = this.buildArguments(workflowMetaDataMap);
                S7Config s7Config = null;
                List argsValues = this.getValuesFromArgs(Arguments.PAGE_CC_PATH.argumentName, args);
                s7Config = argsValues.size() == 1 ? this.s7ConfigResolver.getS7Config((String)argsValues.get(0)) : this.s7ConfigResolver.getS7ConfigForResource(payloadResource);
                if (s7Config != null) {
                    if (this.isUploadEnabled(args, s7Config)) {
                        boolean shouldAllowUpload = true;
                        try {
                            Resource damAssetResource;
                            Resource damAssetMetadataResource;
                            Node damAssetMetadataNode;
                            if (this.isFolder(payloadResource) || !(damAssetMetadataNode = (Node)(damAssetMetadataResource = (damAssetResource = payloadResource).getChild("jcr:content/metadata")).adaptTo(Node.class)).hasProperty("dam:scene7PollingImporterMarker")) return;
                            shouldAllowUpload = false;
                            this.scene7FileMetadataService.removeAssetMetadataProperty((Asset)damAssetResource.adaptTo(Asset.class), "dam:scene7PollingImporterMarker");
                            damAssetMetadataNode.getSession().save();
                            return;
                        }
                        catch (Exception e) {
                            LOG.error("Cannot check Scene7 Polling Importer marker status for asset " + payloadResourcePath, (Throwable)e);
                            return;
                        }
                        finally {
                            if (shouldAllowUpload) {
                                this.upload(payloadResource, s7Config.getCloudConfigPath(), resolver);
                            }
                        }
                    }
                    LOG.warn("Not uploading file to Scene7, make sure that automatic upload is enabled for the {} S7 config!", (Object)s7Config.getCloudConfigPath());
                    return;
                }
                LOG.warn("execute: unable to extract cloud configuration from workflow or parent folder");
                return;
            }
            catch (Exception e) {
                LOG.error("Error during asset lock / unlock for " + payloadResourcePath, (Throwable)e);
                return;
            }
            finally {
                try {
                    if (!this.isFolder(payloadResource)) {
                        this.lockAssetUtils.unlockAsset(payloadResourcePath);
                    }
                }
                catch (Exception e) {
                    LOG.error("Unable to unloc S7 asset lock for " + payloadResourcePath, (Throwable)e);
                }
            }
        }
        LOG.error("Failed to obtain a valid DAM asset from upload workflow payload!");
    }

    private boolean isUploadEnabled(String[] workflowArgs, S7Config s7Config) {
        boolean isInteractiveUpload = false;
        boolean isScene7SyncEnabled = false;
        if (workflowArgs != null && s7Config != null) {
            List argumentValues = this.getValuesFromArgs(Arguments.IS_INTERACTIVE_UPLOAD_ARGUMENT.argumentName, workflowArgs);
            if (argumentValues.size() == 1) {
                isInteractiveUpload = Boolean.parseBoolean((String)argumentValues.get(0));
            }
            isScene7SyncEnabled = "on".equalsIgnoreCase(s7Config.isSyncEnabled());
        } else {
            LOG.warn("Could not determine if the Scene7 upload should be triggered from workflow because the workflow parameters or the S7Config are invalid!");
        }
        LOG.debug("Scene7 upload process: interactive upload={}, syncEnabled={} => isUploadEnabled={}", new Object[]{isInteractiveUpload, isScene7SyncEnabled, isInteractiveUpload || isScene7SyncEnabled});
        return isInteractiveUpload || isScene7SyncEnabled;
    }

    private Resource getResourceFromPayload(WorkItem workItem, Session session) {
        Resource payloadResource = null;
        try {
            Asset damAsset = this.getAssetFromPayload(workItem, session);
            if (damAsset != null) {
                payloadResource = (Resource)damAsset.adaptTo(Resource.class);
            } else {
                Node nodeResource = this.getNodeFromPayload(workItem, session);
                ResourceResolver rr = this.getResourceResolver(session);
                payloadResource = rr.getResource(nodeResource.getPath());
            }
        }
        catch (Exception e) {
            LOG.error("Could not get the resource from the payload!", (Throwable)e);
        }
        return payloadResource;
    }

    private boolean isFolder(Resource resource) {
        boolean isResourceFolder = false;
        if (resource != null) {
            isResourceFolder = "sling:OrderedFolder".equals(resource.getResourceType());
        }
        return isResourceFolder;
    }

    private void upload(Resource resource, String configPath, ResourceResolver resolver) {
        if (DamUtil.isAsset((Resource)resource)) {
            this.scene7UploadService.uploadFile(resource.getPath(), configPath, resolver);
        } else if (this.isFolder(resource)) {
            this.scene7UploadService.uploadFolder(resource.getPath(), configPath, resolver);
        }
    }

    private String[] buildArguments(MetaDataMap metaData) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (Arguments argument : Arguments.values()) {
            String argumentValue = (String)metaData.get(argument.argumentName, String.class);
            if (!StringUtils.isNotBlank((String)argumentValue)) continue;
            arguments.add(argument.getArgumentPrefix() + argumentValue);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected void bindScene7UploadService(Scene7UploadService scene7UploadService) {
        this.scene7UploadService = scene7UploadService;
    }

    protected void unbindScene7UploadService(Scene7UploadService scene7UploadService) {
        if (this.scene7UploadService == scene7UploadService) {
            this.scene7UploadService = null;
        }
    }

    protected void bindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7ConfigResolver = s7ConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7ConfigResolver == s7ConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }

    protected void bindScene7FileMetadataService(Scene7FileMetadataService scene7FileMetadataService) {
        this.scene7FileMetadataService = scene7FileMetadataService;
    }

    protected void unbindScene7FileMetadataService(Scene7FileMetadataService scene7FileMetadataService) {
        if (this.scene7FileMetadataService == scene7FileMetadataService) {
            this.scene7FileMetadataService = null;
        }
    }

    protected void bindLockAssetUtils(LockAssetUtils lockAssetUtils) {
        this.lockAssetUtils = lockAssetUtils;
    }

    protected void unbindLockAssetUtils(LockAssetUtils lockAssetUtils) {
        if (this.lockAssetUtils == lockAssetUtils) {
            this.lockAssetUtils = null;
        }
    }

    public static enum Arguments {
        PAGE_CC_PATH("pageCloudConfigPath"),
        IS_INTERACTIVE_UPLOAD_ARGUMENT("isInteractiveUpload");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

