/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.protocol;

import java.util.Vector;
import org.apache.jackrabbit.util.Text;

public class NameValue {
    private String name = null;
    private String value = null;
    private String defaultValue = null;
    private NameValue parent = null;
    private boolean enabled = true;
    private Vector<NameValue> children = new Vector();

    public NameValue(String name, String value, String defaultValue) {
        this.setName(name);
        this.setValue(value);
        this.setDefaultValue(defaultValue);
    }

    public NameValue(String name, String value) {
        this(name, value, null);
    }

    public NameValue(String name) {
        this(name, null, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String val) {
        this.name = val;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String val) {
        this.value = val;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String val) {
        this.defaultValue = val;
    }

    public String getCheckedValue() {
        String val = this.getValue();
        if (val != null && val.equals(this.getDefaultValue())) {
            return null;
        }
        return val;
    }

    public NameValue getParent() {
        return this.parent;
    }

    public void setParent(NameValue parent) {
        this.parent = parent;
    }

    public NameValue getRoot() {
        NameValue root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean val) {
        this.enabled = val;
    }

    public void addNode(NameValue node) {
        this.addNodeAt(node, this.children.size());
    }

    public void addNodeAt(NameValue node, int idx) {
        this.children.add(idx < 0 ? 0 : (idx > this.children.size() ? this.children.size() : idx), node);
        node.setParent(this);
    }

    public NameValue removeNode(String name, String value) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equals(name) || value != null && !this.children.get(i).getValue().equals(value)) continue;
            NameValue ret = this.children.get(i);
            this.children.remove(i);
            ret.setParent(null);
            return ret;
        }
        return null;
    }

    public NameValue removeNode(String name) {
        return this.removeNode(name, null);
    }

    public void removeAllNodes() {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).setParent(null);
        }
        this.children = new Vector();
    }

    public NameValue getNode(String name, String value) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equals(name) || value != null && !this.children.get(i).getValue().equals(value)) continue;
            return this.children.get(i);
        }
        return null;
    }

    public NameValue getNode(String name) {
        return this.getNode(name, null);
    }

    public Vector<NameValue> getNodeArray(String name, String value, boolean includeDisabled) {
        Vector<NameValue> ret = new Vector<NameValue>();
        for (int i = 0; i < this.children.size(); ++i) {
            if (name != null && !name.equals(this.children.get(i).getName()) || value != null && !value.equals(this.children.get(i).getValue()) || !includeDisabled && !this.children.get(i).getEnabled()) continue;
            ret.add(this.children.get(i));
        }
        return ret;
    }

    public Vector<NameValue> getNodeArray() {
        return this.getNodeArray(null, null, true);
    }

    public void searchNodeArray(Vector<NameValue> arr, String name, String value, boolean includeDisabled) {
        if ((name == null || name.equals(this.getName())) && (value == null || value.equals(this.getValue())) && (includeDisabled || this.getEnabled())) {
            arr.add(this);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).searchNodeArray(arr, name, value, includeDisabled);
        }
    }

    public void searchNodeArray(Vector<NameValue> arr) {
        this.searchNodeArray(arr, null, null, true);
    }

    public String nodeString(boolean checked, boolean encode) {
        String locValue;
        String string = locValue = checked ? this.getCheckedValue() : this.getValue();
        if (this.getName() != null && this.getName().length() > 0 && locValue != null) {
            String locName = this.getName();
            if (encode && locName != null) {
                locName = Text.escape((String)locName);
            }
            if (encode && locValue != null) {
                locValue = Text.escape((String)locValue);
            }
            return "&" + locName + "=" + locValue;
        }
        return "";
    }

    public String childString(boolean checked, boolean encode) {
        String childStr = "";
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getEnabled()) continue;
            childStr = childStr + this.children.get(i).nodeString(checked, encode) + this.children.get(i).childString(checked, encode);
        }
        return childStr;
    }

    public String toString(boolean checked, boolean encode) {
        String ret = this.nodeString(checked, encode) + this.childString(checked, encode);
        if (ret.length() > 0 && ret.charAt(0) == '&') {
            return ret.substring(1);
        }
        return ret;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public Vector<NameValue> getChildren() {
        return this.children;
    }
}

