/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.protocol.is;

import com.day.cq.dam.scene7.impl.protocol.NameValue;
import com.day.cq.dam.scene7.impl.protocol.is.ParamUtils;
import com.day.cq.dam.scene7.impl.protocol.is.Paramable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Vector;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamCommand
extends NameValue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Vector<Paramable> refs = new Vector();
    private boolean lock = false;
    private String staticType = null;

    public ParamCommand(String name, String value) {
        super(name, value);
    }

    @Override
    public void setParent(NameValue parent) {
        super.setParent(parent);
        String newValue = this.getValue();
        if (newValue != null) {
            try {
                newValue = URLDecoder.decode(newValue, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.log.warn("Could not decode string {}!", (Object)newValue);
            }
            this.setValue(newValue);
        }
    }

    @Override
    public void setName(String val) {
        if (val.equals(super.getName())) {
            return;
        }
        Vector<NameValue> arr = ParamUtils.getParameters(this.getRoot());
        for (int i = 0; i < arr.size(); ++i) {
            if (!val.equals(arr.get(i).getName())) continue;
            this.log.debug("Duplicate parameter name: " + val);
            return;
        }
        super.setName(val);
    }

    @Override
    public String getValue() {
        return this.getRef() != null && !this.getType().equals("text") && !this.getType().equals("textps") ? this.getRef().getDefaultParameterValue() : super.getValue();
    }

    @Override
    public String nodeString(boolean checked, boolean encode) {
        if (super.nodeString(checked, encode).length() == 0) {
            return "";
        }
        String locValue = this.getValue();
        if (encode && locValue != null) {
            locValue = Text.escape((String)locValue);
        }
        return "&" + this.getName() + "=" + locValue;
    }

    public String getType() {
        return this.getRef() != null ? this.getRef().getName() : this.staticType;
    }

    public String getDisplayName() {
        return this.getName().substring(1);
    }

    private Paramable getRef() {
        return this.refs.size() > 0 ? this.refs.get(0) : null;
    }

    public void addRef(Paramable inRef) {
        for (int i = 0; i < this.refs.size(); ++i) {
            if (this.refs.get(i) != inRef) continue;
            return;
        }
        this.refs.add(inRef);
        if (this.getParent() == null) {
            inRef.getRoot().addNodeAt(this, 0);
        }
    }

    public void removeRef(NameValue inRef) {
        int idx = this.refs.indexOf(inRef);
        if (idx == -1) {
            return;
        }
        this.refs.remove(idx);
        if (this.refs.size() == 0) {
            this.getParent().removeNode(this.getName());
        }
    }

    public void updateRefs(String newValue, NameValue caller) {
        if (this.lock) {
            return;
        }
        this.lock = true;
        for (int i = 0; i < this.refs.size(); ++i) {
            if (caller != null && caller == this.refs.get(i)) continue;
            this.refs.get(i).setValue(newValue);
        }
        this.lock = false;
    }

    public Vector<Paramable> getRefs() {
        return this.refs;
    }

    public void clearRefs() {
        this.staticType = this.getType();
        this.refs = new Vector();
    }

    private void dumpRefs() {
        if (this.refs.size() == 0) {
            this.log.debug("No refs left");
            return;
        }
        this.log.debug("Param refs: ");
        for (int i = 0; i < this.refs.size(); ++i) {
            this.log.debug(this.refs.get(i).toString());
        }
    }

    public static boolean validateName(String name) {
        return name.matches("[^a-zA-Z0-9-_.]");
    }
}

